/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.browser.jxbrowser;

import com.teamdev.jxbrowser.browser.Browser;
import com.teamdev.jxbrowser.browser.callback.ShowContextMenuCallback;
import com.teamdev.jxbrowser.frame.EditorCommand;
import com.teamdev.jxbrowser.frame.Frame;
import com.teamdev.jxbrowser.ui.Point;
import de.riwagis.browser.util.BrowserSupport;
import de.riwagis.util.Config;
import de.riwagis.util.gui.OSFile;
import de.riwagis.util.gui.components.WaitDialog;
import de.riwagis.util.i18n.I18N;
import java.io.File;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JxContextMenuHander {
    public static final File USERPROFILE = new File(StringUtils.defaultString((String)System.getenv("USERPROFILE"), (String)System.getProperty("user.home")));
    public static final File TEMPDIR = new File(USERPROFILE, ".wgBrowser");
    private static final Logger LOG = LoggerFactory.getLogger(JxContextMenuHander.class);
    private static final I18N i18n = new I18N(Config.LOCALE, "de.riwagis.browser.i18n.i18n");

    private JMenuItem createMenuItem(String title, Runnable action) {
        JMenuItem reloadMenuItem = new JMenuItem(title);
        reloadMenuItem.addActionListener(e -> action.run());
        return reloadMenuItem;
    }

    public void showContextMenu(ShowContextMenuCallback.Params params, final ShowContextMenuCallback.Action tell, JComponent parent) {
        SwingUtilities.invokeLater(() -> {
            JPopupMenu popupMenu = new JPopupMenu();
            popupMenu.addPopupMenuListener(new PopupMenuListener(){

                @Override
                public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                }

                @Override
                public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                    tell.close();
                }

                @Override
                public void popupMenuCanceled(PopupMenuEvent e) {
                    tell.close();
                }
            });
            Browser browser = params.browser();
            popupMenu.add(this.createMenuItem(i18n.get("jxbrowser.ContextMenu.reload"), () -> browser.navigation().reload()));
            popupMenu.add(this.createMenuItem(i18n.get("jxbrowser.ContextMenu.stop"), () -> browser.navigation().stop()));
            popupMenu.add(this.createMenuItem(i18n.get("jxbrowser.ContextMenu.clear-cache"), () -> {
                WaitDialog dlgWait = new WaitDialog(null, i18n.get("jxbrowser.ContextMenu.downloading-source"));
                dlgWait.addWorkToDo(() -> browser.engine().httpCache().clear());
                dlgWait.setVisible(true);
            }));
            popupMenu.addSeparator();
            popupMenu.add(this.createMenuItem(i18n.get("common.copy"), () -> ((Frame)browser.mainFrame().orElseThrow()).execute(EditorCommand.copy())));
            popupMenu.add(this.createMenuItem(i18n.get("common.paste"), () -> ((Frame)browser.mainFrame().orElseThrow()).execute(EditorCommand.paste())));
            popupMenu.add(this.createMenuItem(i18n.get("common.cut"), () -> ((Frame)browser.mainFrame().orElseThrow()).execute(EditorCommand.cut())));
            popupMenu.addSeparator();
            popupMenu.add(this.createMenuItem(i18n.get("jxbrowser.ContextMenu.zoom-in"), () -> browser.zoom().in()));
            popupMenu.add(this.createMenuItem(i18n.get("jxbrowser.ContextMenu.zoom-out"), () -> browser.zoom().out()));
            popupMenu.addSeparator();
            browser.focusedFrame().ifPresent(frame -> popupMenu.add(this.createMenuItem(i18n.get("jxbrowser.ContextMenu.show-source"), () -> {
                WaitDialog dlgWait = new WaitDialog(null, i18n.get("jxbrowser.ContextMenu.downloading-source"));
                dlgWait.addWorkToDo(() -> {
                    File fBrowserSource = new File(TEMPDIR, "browsersource.txt");
                    try {
                        FileUtils.write((File)fBrowserSource, (CharSequence)frame.html());
                        OSFile.showFile((File)fBrowserSource, (boolean)true);
                    }
                    catch (Exception e) {
                        LOG.error(String.format("Error writing browser sources into file %s.", fBrowserSource.toString()), (Throwable)e);
                    }
                });
                dlgWait.setVisible(true);
            })));
            browser.focusedFrame().ifPresent(frame -> popupMenu.add(this.createMenuItem(i18n.get("jxbrowser.ContextMenu.show-source-frame"), () -> {
                WaitDialog dlgWait = new WaitDialog(null, "Writing sources into file");
                dlgWait.addWorkToDo(() -> {
                    File fBrowserSource = new File(TEMPDIR, "browsersource.html");
                    try {
                        FileUtils.write((File)fBrowserSource, (CharSequence)frame.html());
                        OSFile.showFile((File)fBrowserSource, (boolean)true);
                    }
                    catch (Exception e) {
                        LOG.error(String.format("Error writing browser sources into file %s.", fBrowserSource.toString()), (Throwable)e);
                    }
                });
                dlgWait.setVisible(true);
            })));
            popupMenu.add(this.createMenuItem(i18n.get("jxbrowser.ContextMenu.open-in-browser"), () -> BrowserSupport.openBrowser(browser.url())));
            Point location = params.location();
            popupMenu.show(parent, location.x(), location.y());
        });
    }
}

