/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.browser.jxbrowser;

import com.teamdev.jxbrowser.browser.Browser;
import com.teamdev.jxbrowser.browser.callback.ShowContextMenuCallback;
import com.teamdev.jxbrowser.browser.event.BrowserClosed;
import com.teamdev.jxbrowser.callback.Callback;
import com.teamdev.jxbrowser.engine.Engine;
import com.teamdev.jxbrowser.frame.Frame;
import com.teamdev.jxbrowser.js.JsObject;
import com.teamdev.jxbrowser.navigation.callback.StartNavigationCallback;
import com.teamdev.jxbrowser.view.swing.BrowserView;
import de.riwagis.browser.BrowserPanel;
import de.riwagis.browser.JSResponseListener;
import de.riwagis.browser.QueryListener;
import de.riwagis.browser.QueryRouter;
import de.riwagis.browser.jxbrowser.JxContextMenuHander;
import de.riwagis.browser.jxbrowser.JxResponseCallbackDelegate;
import de.riwagis.browser.jxbrowser.JxWindowManager;
import de.riwagis.browser.util.BrowserSupport;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Collection;
import java.util.function.Consumer;
import javax.swing.JComponent;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JxBrowserPanel
extends BrowserPanel {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JxBrowserPanel.class);
    private final Browser browser;
    private boolean allowOnNextNavigation = true;
    private boolean openLinkExternal = false;
    private JSResponseListener jsResponseListener = new JSResponseListener();
    private QueryRouter queryRouter = new QueryRouter(this);

    public JxBrowserPanel() {
        this.browser = ((JxWindowManager)JxWindowManager.getInstance()).createNewBrowser();
        this.browser.navigation().set(StartNavigationCallback.class, (Callback)((StartNavigationCallback)params -> {
            System.out.println(params.url());
            if (StringUtils.isEmpty((CharSequence)params.url()) || StringUtils.equals((CharSequence)"about:blank", (CharSequence)params.url()) || this.allowOnNextNavigation) {
                this.allowOnNextNavigation = false;
                return StartNavigationCallback.Response.start();
            }
            if (this.openLinkExternal) {
                BrowserSupport.openBrowser(params.url());
                return StartNavigationCallback.Response.ignore();
            }
            return StartNavigationCallback.Response.start();
        }));
        this.browser.on(BrowserClosed.class, browserClosed -> {
            Engine engine = this.browser.engine();
            if (engine.browsers().isEmpty()) {
                this.browser.engine().close();
            }
        });
        JxContextMenuHander contextMenuHander = new JxContextMenuHander();
        BrowserView view = BrowserView.newInstance((Browser)this.browser);
        this.browser.set(ShowContextMenuCallback.class, (Callback)((ShowContextMenuCallback)(params, tell) -> contextMenuHander.showContextMenu((ShowContextMenuCallback.Params)params, (ShowContextMenuCallback.Action)tell, (JComponent)view)));
        this.queryRouter.addListener(this.jsResponseListener);
        JsObject window = (JsObject)((Frame)this.browser.mainFrame().orElseThrow()).executeJavaScript("window");
        window.putProperty("cefQuery", args -> {
            JsObject cefQuery = (JsObject)args[0];
            String request = (String)cefQuery.property("request").orElseThrow();
            JxResponseCallbackDelegate responseCallback = new JxResponseCallbackDelegate(cefQuery);
            this.queryRouter.dispatch(request, responseCallback);
            return null;
        });
        this.setLayout(new BorderLayout());
        this.add((Component)view, "Center");
    }

    @Override
    public void navigate(String strURL) {
        if (strURL == null) {
            return;
        }
        this.allowOnNextNavigation = true;
        this.browser.navigation().loadUrl(strURL);
    }

    @Override
    public void refresh() {
        this.browser.navigation().reload();
    }

    @Override
    public boolean isLoading() {
        return this.browser.navigation().isLoading();
    }

    @Override
    public void dispose() {
        this.browser.close();
    }

    @Override
    public String getHTML() {
        return ((Frame)this.browser.mainFrame().orElseThrow()).html();
    }

    @Override
    public void setHTML(String html) {
        ((Frame)this.browser.mainFrame().orElseThrow()).loadHtml(html);
    }

    @Override
    public String getURL() {
        return this.browser.url();
    }

    @Override
    public boolean getOpenLinkExternal() {
        return this.openLinkExternal;
    }

    @Override
    public void setOpenLinkExternal(boolean openLinkExternal) {
        this.openLinkExternal = openLinkExternal;
    }

    @Override
    public void execJS(String jscript) {
        ((Frame)this.browser.mainFrame().orElseThrow()).executeJavaScript(jscript);
    }

    @Override
    public String execJSWithReturn(String jscript) {
        try {
            return this.jsResponseListener.executeAndWait(this, jscript, 60000L);
        }
        catch (InterruptedException ex) {
            throw new IllegalStateException("JavaScript didn't answer in time.", ex);
        }
    }

    @Override
    public void execJSWithReturn(String jscript, Consumer<String> successHandler, Consumer<String> errorHandler) {
        this.jsResponseListener.execute(this, jscript, successHandler, errorHandler);
    }

    @Override
    public void addQueryListener(QueryListener listener) {
        this.queryRouter.addListener(listener);
    }

    @Override
    public void removeQueryListener(QueryListener listener) {
        this.queryRouter.removeListener(listener);
    }

    @Override
    public Collection<QueryListener> getQueryListeners() {
        return this.queryRouter.getListeners();
    }
}

