/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.browser.jxbrowser;

import com.teamdev.jxbrowser.browser.Browser;
import com.teamdev.jxbrowser.browser.callback.ShowContextMenuCallback;
import com.teamdev.jxbrowser.browser.event.BrowserClosed;
import com.teamdev.jxbrowser.browser.event.TitleChanged;
import com.teamdev.jxbrowser.callback.Callback;
import com.teamdev.jxbrowser.engine.Engine;
import com.teamdev.jxbrowser.event.Subscription;
import com.teamdev.jxbrowser.frame.Frame;
import com.teamdev.jxbrowser.js.JsObject;
import com.teamdev.jxbrowser.navigation.LoadUrlParams;
import com.teamdev.jxbrowser.navigation.event.LoadFinished;
import com.teamdev.jxbrowser.net.HttpHeader;
import com.teamdev.jxbrowser.view.swing.BrowserView;
import de.riwagis.browser.BrowserFrame;
import de.riwagis.browser.JSResponseListener;
import de.riwagis.browser.QueryListener;
import de.riwagis.browser.QueryRouter;
import de.riwagis.browser.images.IconLoader;
import de.riwagis.browser.jxbrowser.JxContextMenuHander;
import de.riwagis.browser.jxbrowser.JxResponseCallbackDelegate;
import de.riwagis.browser.jxbrowser.JxWindowManager;
import de.riwagis.util.Config;
import de.riwagis.util.i18n.I18N;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Collection;
import java.util.function.Consumer;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JxBrowserFrame
extends JFrame
implements BrowserFrame {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JxBrowserFrame.class);
    private static final I18N i18n = new I18N(Config.LOCALE, "de.riwagis.browser.i18n.i18n");
    private final Browser browser;
    private final JToolBar toolBar;
    private JSResponseListener jsResponseListener = new JSResponseListener();
    private QueryRouter queryRouter = new QueryRouter(this);

    public JxBrowserFrame() {
        this.browser = ((JxWindowManager)JxWindowManager.getInstance()).createNewBrowser();
        this.browser.on(TitleChanged.class, titleChanged -> SwingUtilities.invokeLater(() -> this.setTitle(titleChanged.title())));
        this.browser.on(BrowserClosed.class, browserClosed -> {
            Engine engine = this.browser.engine();
            if (engine.browsers().isEmpty()) {
                this.browser.engine().close();
            }
        });
        JxContextMenuHander contextMenuHander = new JxContextMenuHander();
        BrowserView view = BrowserView.newInstance((Browser)this.browser);
        this.browser.set(ShowContextMenuCallback.class, (Callback)((ShowContextMenuCallback)(params, tell) -> contextMenuHander.showContextMenu((ShowContextMenuCallback.Params)params, (ShowContextMenuCallback.Action)tell, (JComponent)view)));
        this.queryRouter.addListener(this.jsResponseListener);
        JsObject window = (JsObject)((Frame)this.browser.mainFrame().orElseThrow()).executeJavaScript("window");
        window.putProperty("cefQuery", args -> {
            JsObject cefQuery = (JsObject)args[0];
            String request = (String)cefQuery.property("request").orElseThrow();
            JxResponseCallbackDelegate responseCallback = new JxResponseCallbackDelegate(cefQuery);
            this.queryRouter.dispatch(request, responseCallback);
            return null;
        });
        JButton printButton = new JButton(i18n.get("jxbrowser.BrowserFrame.print"));
        printButton.addActionListener(e -> ((Frame)this.browser.mainFrame().orElseThrow()).print());
        this.toolBar = new JToolBar();
        this.toolBar.add(printButton);
        this.toolBar.setFloatable(false);
        this.toolBar.setRollover(true);
        this.toolBar.setVisible(false);
        this.setDefaultCloseOperation(2);
        this.setIconImage(IconLoader.image("icon.png"));
        this.setLayout(new BorderLayout());
        this.add((Component)view, "Center");
        this.add((Component)this.toolBar, "North");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                JxBrowserFrame.this.browser.close();
            }
        });
    }

    @Override
    public void setPosSize(int left, int top, int width, int height) {
        this.setLocation(left, top);
        this.setSize(width, height);
    }

    @Override
    public void showToolbar() {
        this.toolBar.setVisible(true);
    }

    @Override
    public String getURL() {
        return this.browser.url();
    }

    @Override
    public void navigate(String strURL) {
        if (this.browser.isClosed()) {
            return;
        }
        this.browser.navigation().loadUrl(strURL);
    }

    public void navigateWithPostData(String url, String post, Runnable callEndedListener) {
        if (this.browser.isClosed()) {
            return;
        }
        LoadUrlParams call = LoadUrlParams.newBuilder((String)url).addExtraHeader(HttpHeader.of((String)"Content-Type", (String)"application/x-www-form-urlencoded; charset=utf-8")).postData(post).build();
        if (callEndedListener != null) {
            Subscription[] subscription = new Subscription[]{null};
            subscription[0] = this.browser.navigation().on(LoadFinished.class, event -> {
                callEndedListener.run();
                if (subscription[0] != null) {
                    subscription[0].unsubscribe();
                }
            });
        }
        this.browser.navigation().loadUrl(call);
    }

    @Override
    public void refresh() {
        if (this.browser.isClosed()) {
            return;
        }
        this.browser.navigation().reload();
    }

    @Override
    public void centreOnScreen() {
        this.setLocationRelativeTo(null);
    }

    @Override
    public void execJS(String jscript) {
        ((Frame)this.browser.mainFrame().orElseThrow()).executeJavaScript(jscript);
    }

    @Override
    public String execJSWithReturn(String jscript) {
        try {
            return this.jsResponseListener.executeAndWait(this, jscript, 60000L);
        }
        catch (InterruptedException ex) {
            throw new IllegalStateException("JavaScript didn't answer in time.", ex);
        }
    }

    @Override
    public void execJSWithReturn(String jscript, Consumer<String> successHandler, Consumer<String> errorHandler) {
        this.jsResponseListener.execute(this, jscript, successHandler, errorHandler);
    }

    @Override
    public void addQueryListener(QueryListener listener) {
        this.queryRouter.addListener(listener);
    }

    @Override
    public void removeQueryListener(QueryListener listener) {
        this.queryRouter.removeListener(listener);
    }

    @Override
    public Collection<QueryListener> getQueryListeners() {
        return this.queryRouter.getListeners();
    }

    @Override
    public boolean isLoading() {
        return this.browser.navigation().isLoading();
    }
}

