/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.browser.jcef.handler;

import de.riwagis.browser.jcef.DelegatingQueuedBrowser;
import de.riwagis.browser.jcef.JCEFBrowserFrame;
import java.awt.Window;
import javax.swing.SwingUtilities;
import lombok.Generated;
import org.cef.browser.CefBrowser;
import org.cef.browser.CefFrame;
import org.cef.handler.CefLifeSpanHandlerAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueuedLifeSpanHandler
extends CefLifeSpanHandlerAdapter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(QueuedLifeSpanHandler.class);
    private final DelegatingQueuedBrowser delegatingQueuedBrowser;
    private final Runnable closeSignaller;

    public QueuedLifeSpanHandler(DelegatingQueuedBrowser delegatingQueuedBrowser) {
        this.delegatingQueuedBrowser = delegatingQueuedBrowser;
        this.closeSignaller = null;
    }

    public QueuedLifeSpanHandler(DelegatingQueuedBrowser delegatingQueuedBrowser, Runnable closeSignaller) {
        this.delegatingQueuedBrowser = delegatingQueuedBrowser;
        this.closeSignaller = closeSignaller;
    }

    public boolean onBeforePopup(CefBrowser browser, CefFrame frame, String target_url, String target_frame_name) {
        JCEFBrowserFrame jcefBrowserFrame = new JCEFBrowserFrame(target_url, false);
        Window windowAncestor = SwingUtilities.getWindowAncestor(browser.getUIComponent());
        jcefBrowserFrame.setPosSize(windowAncestor.getX() + 10, windowAncestor.getY() + 10, windowAncestor.getWidth(), windowAncestor.getHeight());
        jcefBrowserFrame.setIconImages(windowAncestor.getIconImages());
        jcefBrowserFrame.setVisible(true);
        return true;
    }

    public void onAfterCreated(CefBrowser cb) {
        if (cb.getIdentifier() != this.delegatingQueuedBrowser.getIdentifier()) {
            return;
        }
        this.delegatingQueuedBrowser.runQueuedOperations();
    }

    public boolean doClose(CefBrowser browser) {
        log.debug("User and/or browser signalled closing is OK now");
        if (this.closeSignaller != null) {
            this.closeSignaller.run();
        }
        return browser.doClose();
    }
}

