/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.browser.jcef.handler;

import java.awt.Desktop;
import java.io.IOException;
import java.net.URI;
import lombok.Generated;
import org.cef.callback.CefCallback;
import org.cef.handler.CefResourceHandlerAdapter;
import org.cef.network.CefRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MailSchemeHandler
extends CefResourceHandlerAdapter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MailSchemeHandler.class);
    public static final String SCHEME = "mailto";
    public static final String DOMAIN = "";

    public static boolean openURLInShell(URI uri) {
        if (!Desktop.isDesktopSupported()) {
            return false;
        }
        Desktop desktop = Desktop.getDesktop();
        if (!desktop.isSupported(Desktop.Action.BROWSE)) {
            return false;
        }
        try {
            desktop.browse(uri);
            return true;
        }
        catch (IOException e) {
            log.error("Could not open link!", (Throwable)e);
            return false;
        }
    }

    public boolean processRequest(CefRequest request, CefCallback callback) {
        URI requestUrl = URI.create(request.getURL());
        log.debug("Opening link {}", (Object)requestUrl);
        MailSchemeHandler.openURLInShell(requestUrl);
        return false;
    }
}

