/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.browser.jcef.handler;

import java.util.function.Consumer;
import org.cef.browser.CefBrowser;
import org.cef.handler.CefKeyboardHandler;
import org.cef.handler.CefKeyboardHandlerAdapter;
import org.cef.misc.BoolRef;

public class KeyboardHandler
extends CefKeyboardHandlerAdapter {
    private final CefBrowser parentBrowser;
    private boolean shiftDown = false;
    private final Consumer<CefBrowser> devToolsToggler;

    public KeyboardHandler(CefBrowser parentBrowser) {
        this(parentBrowser, null);
    }

    public KeyboardHandler(CefBrowser parentBrowser, Consumer<CefBrowser> devToolsToggler) {
        this.parentBrowser = parentBrowser;
        this.devToolsToggler = devToolsToggler;
    }

    public boolean onPreKeyEvent(CefBrowser cb, CefKeyboardHandler.CefKeyEvent cke, BoolRef br) {
        return super.onPreKeyEvent(cb, cke, br);
    }

    public boolean onKeyEvent(CefBrowser browser, CefKeyboardHandler.CefKeyEvent event) {
        if (this.parentBrowser.getIdentifier() == browser.getIdentifier()) {
            boolean bl = this.shiftDown = (event.modifiers & 2) != 0;
            if (this.devToolsToggler != null && event.windows_key_code == 123 && event.type == CefKeyboardHandler.CefKeyEvent.EventType.KEYEVENT_RAWKEYDOWN) {
                this.devToolsToggler.accept(this.parentBrowser);
                return true;
            }
        }
        return super.onKeyEvent(browser, event);
    }

    public boolean isShiftDown() {
        return this.shiftDown;
    }

    public boolean isShiftDownAndReset() {
        boolean _shiftDown = this.shiftDown;
        this.shiftDown = false;
        return _shiftDown;
    }
}

