/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.browser.jcef.handler;

import de.riwagis.browser.WindowManager;
import de.riwagis.browser.jcef.JCEFIntegration;
import de.riwagis.util.i18n.I18N;
import java.awt.Component;
import java.lang.reflect.InvocationTargetException;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import lombok.Generated;
import org.cef.browser.CefBrowser;
import org.cef.callback.CefJSDialogCallback;
import org.cef.handler.CefJSDialogHandler;
import org.cef.handler.CefJSDialogHandlerAdapter;
import org.cef.misc.BoolRef;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JSDialogHandler
extends CefJSDialogHandlerAdapter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JSDialogHandler.class);
    private final I18N i18n = JCEFIntegration.getInstance().getI18n();

    public boolean onJSDialog(CefBrowser browser, String origin_url, CefJSDialogHandler.JSDialogType dialog_type, String message_text, String default_prompt_text, CefJSDialogCallback callback, BoolRef suppress_message) {
        Component parent = Optional.ofNullable(SwingUtilities.getRoot(browser.getUIComponent())).orElse(WindowManager.getInstance().getFallbackParentFrame());
        Objects.requireNonNull(parent);
        switch (dialog_type) {
            case JSDIALOGTYPE_ALERT: {
                Executors.newSingleThreadExecutor().submit(() -> {
                    try {
                        SwingUtilities.invokeAndWait(() -> JOptionPane.showMessageDialog(parent, message_text));
                    }
                    catch (InterruptedException | InvocationTargetException ex) {
                        callback.Continue(false, null);
                        log.error("Error while displaying JS Popup!", (Throwable)ex);
                    }
                    callback.Continue(true, null);
                });
                return true;
            }
            case JSDIALOGTYPE_CONFIRM: {
                Executors.newSingleThreadExecutor().submit(() -> {
                    AtomicBoolean result = new AtomicBoolean(false);
                    try {
                        SwingUtilities.invokeAndWait(() -> result.set(JOptionPane.showConfirmDialog(parent, message_text, this.i18n.get("jcef.jsdialog.confirm-title"), 2) == 0));
                    }
                    catch (InterruptedException | InvocationTargetException ex) {
                        callback.Continue(false, null);
                        log.error("Error while displaying JS Popup!", (Throwable)ex);
                    }
                    callback.Continue(result.get(), null);
                });
                return true;
            }
            case JSDIALOGTYPE_PROMPT: {
                Executors.newSingleThreadExecutor().submit(() -> {
                    AtomicReference<String> result = new AtomicReference<String>("");
                    try {
                        SwingUtilities.invokeAndWait(() -> result.set(JOptionPane.showInputDialog(parent, message_text, default_prompt_text)));
                    }
                    catch (InterruptedException | InvocationTargetException ex) {
                        callback.Continue(false, null);
                        log.error("Error while displaying JS Popup!", (Throwable)ex);
                    }
                    callback.Continue(true, result.get());
                });
                return true;
            }
        }
        return false;
    }
}

