/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.browser.jcef.handler;

import java.awt.KeyboardFocusManager;
import javax.swing.SwingUtilities;
import lombok.Generated;
import org.cef.browser.CefBrowser;
import org.cef.handler.CefFocusHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FocusHandler
implements CefFocusHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FocusHandler.class);

    public void onTakeFocus(CefBrowser browser, boolean next) {
        log.trace("Browser #{} was focus taken away by {} component", (Object)browser.getIdentifier(), (Object)(next ? "next" : "last"));
    }

    public boolean onSetFocus(CefBrowser browser, CefFocusHandler.FocusSource source) {
        log.trace("Browser #{} requests focus through {}", (Object)browser.getIdentifier(), (Object)source.name());
        if (source == CefFocusHandler.FocusSource.FOCUS_SOURCE_SYSTEM) {
            return true;
        }
        SwingUtilities.invokeLater(() -> KeyboardFocusManager.getCurrentKeyboardFocusManager().clearGlobalFocusOwner());
        return false;
    }

    public void onGotFocus(CefBrowser browser) {
        log.trace("Browser #{} has gotten focus", (Object)browser.getIdentifier());
    }
}

