/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.browser.jcef.handler;

import de.riwagis.browser.jcef.JCEFIntegration;
import de.riwagis.util.i18n.I18N;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Window;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import javax.swing.ProgressMonitor;
import javax.swing.SwingUtilities;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.cef.browser.CefBrowser;
import org.cef.callback.CefBeforeDownloadCallback;
import org.cef.callback.CefDownloadItem;
import org.cef.callback.CefDownloadItemCallback;
import org.cef.handler.CefDownloadHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DownloadHandler
implements CefDownloadHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DownloadHandler.class);
    private final Supplier<Window> windowSupplier;
    private final Map<Integer, ProgressMonitor> monitors = new HashMap<Integer, ProgressMonitor>();
    private final I18N i18n = JCEFIntegration.getInstance().getI18n();

    public DownloadHandler(Supplier<Window> windowSupplier) {
        this.windowSupplier = windowSupplier;
    }

    public boolean onBeforeDownload(CefBrowser browser, CefDownloadItem downloadItem, String suggestedName, CefBeforeDownloadCallback callback) {
        this.hideDialogIfBlankDownload(browser);
        callback.Continue(suggestedName, true);
        return true;
    }

    public void onDownloadUpdated(CefBrowser browser, CefDownloadItem downloadItem, CefDownloadItemCallback callback) {
        int id = downloadItem.getId();
        int totalBytes = (int)downloadItem.getTotalBytes();
        int receivedBytes = (int)downloadItem.getReceivedBytes();
        if (downloadItem.isInProgress()) {
            SwingUtilities.invokeLater(() -> this.updateProgress(callback, id, totalBytes, receivedBytes));
        } else if (downloadItem.isCanceled()) {
            SwingUtilities.invokeLater(() -> {
                this.closeParentIfEmptyBlankTarget(browser);
                this.closeWindow(id);
            });
        } else if (downloadItem.isComplete()) {
            File downloadedFile = new File(downloadItem.getFullPath());
            SwingUtilities.invokeLater(() -> {
                this.closeParentIfEmptyBlankTarget(browser);
                this.closeWindow(id);
                this.openFile(downloadedFile);
            });
        }
    }

    private void hideDialogIfBlankDownload(CefBrowser browser) {
        SwingUtilities.invokeLater(() -> {
            Window window = this.getWindowIfEmptyBlankTarget(browser);
            if (window != null) {
                window.setVisible(false);
            }
        });
    }

    private void closeParentIfEmptyBlankTarget(CefBrowser browser) {
        Window window = this.getWindowIfEmptyBlankTarget(browser);
        if (window != null) {
            window.dispatchEvent(new WindowEvent(window, 201));
        }
    }

    private Window getWindowIfEmptyBlankTarget(CefBrowser browser) {
        Component browserUI = browser.getUIComponent();
        Window window = SwingUtilities.getWindowAncestor(browserUI);
        if (!(window instanceof Window) || StringUtils.isNotBlank((CharSequence)browser.getURL())) {
            return null;
        }
        return window;
    }

    public void updateProgress(CefDownloadItemCallback callback, int id, int totalBytes, int receivedBytes) {
        ProgressMonitor progressMonitor = this.monitors.computeIfAbsent(id, di -> new ProgressMonitor(this.windowSupplier.get(), this.i18n.get("jcef.download.running"), null, 0, totalBytes));
        progressMonitor.setMaximum(totalBytes);
        progressMonitor.setProgress(receivedBytes);
        if (progressMonitor.isCanceled()) {
            callback.cancel();
        }
    }

    public void closeWindow(int id) {
        this.monitors.remove(id).close();
    }

    public void openFile(File downloadedFile) {
        try {
            Desktop.getDesktop().open(downloadedFile);
        }
        catch (IOException e) {
            log.error("Could not open file '{}'", (Throwable)e);
        }
    }
}

