/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.browser.jcef.handler;

import de.riwagis.browser.jcef.JCEFIntegration;
import de.riwagis.browser.util.BrowserSupport;
import de.riwagis.util.i18n.I18N;
import java.awt.Component;
import java.awt.HeadlessException;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import java.util.function.Supplier;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import org.cef.browser.CefBrowser;
import org.cef.browser.CefFrame;
import org.cef.callback.CefContextMenuParams;
import org.cef.callback.CefMenuModel;
import org.cef.handler.CefContextMenuHandlerAdapter;

public class ContextMenuHandler
extends CefContextMenuHandlerAdapter {
    private final I18N i18n = JCEFIntegration.getInstance().getI18n();
    private final JCEFIntegration jcefIntegration = JCEFIntegration.getInstance();
    private Map<Integer, String> suggestions_ = new HashMap<Integer, String>();
    private static final int CMD_PAGE_URL_TO_CLIPBOARD = 26500;
    private static final int CMD_REMOTE_DEBUG_URL_TO_CLIPBOARD = 26501;
    private static final int CMD_PAGE_URL_TO_BROWSER = 26502;
    private static final int CMD_REMOTE_DEBUG_URL_TO_BROWSER = 26503;
    private static final int CMD_ZOOM_IN = 26504;
    private static final int CMD_ZOOM_OUT = 26505;
    private static final int CMD_ZOOM_RESET = 26506;
    private static final int CMD_VIEW_FRAME_SOURCE = 26507;
    private static final int CMD_ALWAYS_ON_TOP = 26508;
    private final Supplier<Boolean> shiftStateSupplier;

    public ContextMenuHandler() {
        this(() -> false);
    }

    public ContextMenuHandler(Supplier<Boolean> shiftStateSupplier) {
        this.shiftStateSupplier = shiftStateSupplier;
    }

    public void onBeforeContextMenu(CefBrowser cb, CefFrame cf, CefContextMenuParams ccmp, CefMenuModel cmm) {
        int typeFlags = ccmp.getTypeFlags();
        int editFlags = ccmp.getEditStateFlags();
        boolean shiftDown = this.shiftStateSupplier.get();
        cmm.clear();
        Vector suggestions = new Vector();
        ccmp.getDictionarySuggestions(suggestions);
        if (suggestions.size() == 0) {
            cmm.addItem(205, "Keine Vorschl\u00e4ge");
            cmm.setEnabled(205, false);
        } else {
            int id = 200;
            for (String suggestedWord : suggestions) {
                cmm.addItem(id, suggestedWord);
                this.suggestions_.put(id, suggestedWord);
                if (++id <= 204) continue;
                break;
            }
        }
        cmm.addSeparator();
        cmm.addItem(102, this.i18n.get("jcef.contextmenu.reload"));
        cmm.addItem(104, this.i18n.get("jcef.contextmenu.cancel-load"));
        if (shiftDown) {
            cmm.addItem(103, this.i18n.get("jcef.contextmenu.reload-no-cache"));
        }
        cmm.addSeparator();
        if (this.isStateFlagSet(typeFlags, 32)) {
            cmm.addItem(110, this.i18n.get("jcef.contextmenu.undo"));
            cmm.addItem(111, this.i18n.get("jcef.contextmenu.redo"));
            cmm.addSeparator();
            cmm.addItem(112, this.i18n.get("jcef.contextmenu.cut"));
            cmm.addItem(113, this.i18n.get("jcef.contextmenu.copy"));
            cmm.addItem(114, this.i18n.get("jcef.contextmenu.paste"));
            cmm.addItem(115, this.i18n.get("jcef.contextmenu.delete"));
            cmm.addSeparator();
            cmm.addItem(116, this.i18n.get("jcef.contextmenu.select-all"));
            cmm.addSeparator();
            cmm.setEnabled(110, this.isStateFlagSet(editFlags, 1));
            cmm.setEnabled(111, this.isStateFlagSet(editFlags, 2));
            cmm.setEnabled(112, this.isStateFlagSet(editFlags, 4));
            cmm.setEnabled(113, this.isStateFlagSet(editFlags, 8));
            cmm.setEnabled(114, this.isStateFlagSet(editFlags, 16));
            cmm.setEnabled(115, this.isStateFlagSet(editFlags, 32));
            cmm.setEnabled(116, this.isStateFlagSet(editFlags, 64));
        } else if (this.isStateFlagSet(typeFlags, 16)) {
            cmm.addItem(113, this.i18n.get("jcef.contextmenu.copy"));
            cmm.setEnabled(113, this.isStateFlagSet(editFlags, 8));
            cmm.addSeparator();
        }
        cmm.addItem(131, this.i18n.get("jcef.contextmenu.print"));
        JFrame rootPane = this.getRootFrame(cb);
        if (rootPane != null) {
            cmm.addCheckItem(26508, this.i18n.get("jcef.contextmenu.keep-in-front"));
            cmm.setChecked(26508, rootPane.isAlwaysOnTop());
        }
        cmm.addSeparator();
        cmm.addItem(26504, this.i18n.get("jcef.contextmenu.zoom-in"));
        cmm.addItem(26505, this.i18n.get("jcef.contextmenu.zoom-out"));
        cmm.addItem(26506, this.i18n.get("jcef.contextmenu.zoom-reset"));
        if (shiftDown) {
            cmm.addSeparator();
            cmm.addItem(132, this.i18n.get("jcef.contextmenu.view-source"));
            cmm.addItem(26500, this.i18n.get("jcef.contextmenu.copy-page-url-to-clipboard"));
            cmm.addItem(26502, this.i18n.get("jcef.contextmenu.open-page-in-external-browser"));
            if (this.jcefIntegration.isRemoteDebuggingEnabled()) {
                cmm.addItem(26501, this.i18n.get("jcef.contextmenu.copy-remote-debug-url-to-clipboard"));
                cmm.addItem(26503, this.i18n.get("jcef.contextmenu.open-remote-debug-url-in-external-browser"));
            }
        }
        cmm.setEnabled(104, cb.isLoading());
    }

    public boolean onContextMenuCommand(CefBrowser browser, CefFrame frame, CefContextMenuParams params, int commandId, int eventFlags) {
        String newWord;
        switch (commandId) {
            case 26500: {
                this.copyToClipboard(browser.getURL());
                return true;
            }
            case 26501: {
                this.copyToClipboard(this.jcefIntegration.getRemoteDebuggingURL());
                return true;
            }
            case 26502: {
                BrowserSupport.openBrowser(browser.getURL());
                return true;
            }
            case 26503: {
                BrowserSupport.openBrowser(this.jcefIntegration.getRemoteDebuggingURL());
                return true;
            }
            case 26504: {
                browser.setZoomLevel(browser.getZoomLevel() + 1.0);
                return true;
            }
            case 26505: {
                browser.setZoomLevel(browser.getZoomLevel() - 1.0);
                return true;
            }
            case 26506: {
                browser.setZoomLevel(0.0);
                return true;
            }
            case 26508: {
                JFrame rootPane = this.getRootFrame(browser);
                if (rootPane == null) break;
                SwingUtilities.invokeLater(() -> rootPane.setAlwaysOnTop(!rootPane.isAlwaysOnTop()));
                return true;
            }
        }
        if (commandId >= 200 && (newWord = this.suggestions_.get(commandId)) != null) {
            System.err.println("replacing " + params.getMisspelledWord() + " with " + newWord);
            browser.replaceMisspelling(newWord);
            return true;
        }
        return false;
    }

    private boolean isStateFlagSet(int flags, int flag) {
        return (flags & flag) != 0;
    }

    private void copyToClipboard(String text) throws HeadlessException {
        StringSelection selection = new StringSelection(text);
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        clipboard.setContents(selection, selection);
    }

    private JFrame getRootFrame(CefBrowser cb) {
        Component root = SwingUtilities.getRoot(cb.getUIComponent());
        return root instanceof JFrame ? (JFrame)root : null;
    }

    public void onContextMenuDismissed(CefBrowser browser, CefFrame frame) {
        this.suggestions_.clear();
    }
}

