/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.browser.jcef;

import de.riwagis.browser.jcef.DelegatingQueuedBrowser;
import java.awt.BorderLayout;
import java.awt.GraphicsConfiguration;
import java.awt.Rectangle;
import java.awt.Window;
import java.lang.reflect.Field;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import lombok.Generated;
import org.cef.browser.CefBrowser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RescalingWrapperPanel
extends JPanel {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RescalingWrapperPanel.class);
    private final CefBrowser browser;

    public RescalingWrapperPanel(CefBrowser browser) {
        super(new BorderLayout());
        this.browser = browser instanceof DelegatingQueuedBrowser ? ((DelegatingQueuedBrowser)browser).getDelegate() : browser;
        this.add(browser.getUIComponent(), "Center");
        this.addPropertyChangeListener("graphicsConfiguration", evt -> this.updateScalingInBrowser());
        if (browser instanceof DelegatingQueuedBrowser) {
            this.addPropertyChangeListener("ancestor", evt -> SwingUtilities.invokeLater(() -> this.resetBrowserBounds()));
        }
    }

    private void updateScalingInBrowser() {
        try {
            if (this.getBounds().isEmpty()) {
                return;
            }
            Field factorField = this.browser.getClass().getDeclaredField("scaleFactor_");
            factorField.setAccessible(true);
            double factor = factorField.getDouble(this.browser);
            GraphicsConfiguration graphicsConfiguration = this.getGraphicsConfiguration();
            if (graphicsConfiguration == null) {
                return;
            }
            double newFactor = graphicsConfiguration.getDefaultTransform().getScaleX();
            if (factor == newFactor) {
                return;
            }
            factorField.setDouble(this.browser, newFactor);
            this.resetBrowserBounds();
        }
        catch (Exception ex) {
            log.error("Could not update browser dpi scaling.", (Throwable)ex);
        }
    }

    private void resetBrowserBounds() {
        Window windowAncestor = SwingUtilities.getWindowAncestor(this.browser.getUIComponent());
        if (windowAncestor != null && windowAncestor.getClass().getSimpleName().equals("WorkbenchFrame")) {
            return;
        }
        Rectangle localBounds = this.getBounds();
        Rectangle absoluteBounds = SwingUtilities.convertRectangle(this, localBounds, null);
        this.browser.getUIComponent().setBounds(absoluteBounds);
    }
}

