/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.browser.jcef;

import de.riwagis.browser.BrowserFrame;
import de.riwagis.browser.BrowserPanel;
import de.riwagis.browser.NonEncodingURI;
import de.riwagis.browser.OpenWindowConfiguration;
import de.riwagis.browser.WindowManager;
import de.riwagis.browser.WindowManagerSettings;
import de.riwagis.browser.jcef.DelegatingQueuedBrowser;
import de.riwagis.browser.jcef.JCEFBrowserFrame;
import de.riwagis.browser.jcef.JCEFBrowserPanel;
import de.riwagis.browser.jcef.JCEFIntegration;
import de.riwagis.browser.jcef.handler.QueuedLifeSpanHandler;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import javax.swing.SwingUtilities;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.cef.browser.CefBrowser;
import org.cef.browser.CefFrame;
import org.cef.browser.CefMessageRouter;
import org.cef.handler.CefFocusHandler;
import org.cef.handler.CefFocusHandlerAdapter;
import org.cef.handler.CefLifeSpanHandler;
import org.cef.handler.CefLoadHandler;
import org.cef.handler.CefLoadHandlerAdapter;
import org.cef.network.CefPostData;
import org.cef.network.CefPostDataElement;
import org.cef.network.CefRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JCEFWindowManager
extends WindowManager<JCEFBrowserFrame> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JCEFWindowManager.class);
    private static WindowManager WM_INSTANCE = null;

    public JCEFWindowManager(WindowManagerSettings settings) {
        super(() -> new JCEFBrowserFrame());
        JCEFIntegration.startup(settings);
    }

    public static synchronized WindowManager getInstance() {
        if (WM_INSTANCE == null) {
            WindowManager defaultInstance = WindowManager.getInstance();
            WM_INSTANCE = defaultInstance instanceof JCEFWindowManager ? defaultInstance : new JCEFWindowManager(new WindowManagerSettings());
        }
        return WM_INSTANCE;
    }

    @Override
    public void closeWindow(String strName) {
        this.closeWindowInternal(strName);
    }

    @Override
    public void addWindowListeners(JCEFBrowserFrame browserFrame, final String strName) {
        if (StringUtils.isNotBlank((CharSequence)strName)) {
            browserFrame.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    JCEFWindowManager.this.removeWindow(strName);
                }
            });
        }
    }

    @Override
    public BrowserFrame openWindow(OpenWindowConfiguration configuration) {
        JCEFBrowserFrame frame = (JCEFBrowserFrame)this.openWindowInternal(configuration.getName());
        this.getWindowIcons().ifPresent(frame::setIconImages);
        frame.setName(configuration.getName());
        frame.setSize(configuration.getSize());
        if (configuration.getLocation() != null && configuration.getLocation().x > -1) {
            frame.setLocationRelativeToScreen(configuration.getLocation().x, configuration.getLocation().y);
        } else {
            frame.centreOnScreen();
        }
        if (configuration.isShowToolbar()) {
            frame.showToolbar();
        }
        frame.navigate(configuration.getAddress().toString());
        this.addWindowListeners(frame, configuration.getName());
        frame.setVisible(true);
        return frame;
    }

    @Override
    @Deprecated
    public synchronized void callServer(String url) {
        this.callServer(url, null, null);
    }

    @Override
    public void callServer(final String url, Map<String, String> postData, final Runnable callEndedListener) {
        log.debug(String.format("callServer('%s')", url));
        this.getBasicURL();
        SwingUtilities.invokeLater(() -> {
            CefBrowser invisibleBrowser;
            if (postData == null) {
                invisibleBrowser = JCEFIntegration.getInstance().createBrowser(this.resolveURL(url), false, c -> {
                    CefMessageRouter msgRouter = CefMessageRouter.create();
                    c.addMessageRouter(msgRouter);
                });
            } else {
                invisibleBrowser = JCEFIntegration.getInstance().createBrowser("about:blank", false, c -> {
                    CefMessageRouter msgRouter = CefMessageRouter.create();
                    c.addMessageRouter(msgRouter);
                });
                CefRequest cefRequest = CefRequest.create();
                String method = "POST";
                CefPostData posts = CefPostData.create();
                CefPostDataElement element = CefPostDataElement.create();
                String collect = postData.entrySet().stream().map(e -> (String)e.getKey() + "=" + (String)e.getValue()).collect(Collectors.joining("&"));
                byte[] bytes = collect.getBytes(StandardCharsets.UTF_8);
                element.setToBytes(bytes.length, bytes);
                posts.addElement(element);
                Map<String, String> headers = Map.of("Content-Type", "application/x-www-form-urlencoded; charset=utf-8");
                cefRequest.setFlags(0);
                cefRequest.set(this.resolveURL(url), "POST", posts, headers);
                invisibleBrowser.loadRequest(cefRequest);
            }
            invisibleBrowser.getClient().addFocusHandler((CefFocusHandler)new CefFocusHandlerAdapter(){

                public boolean onSetFocus(CefBrowser browser, CefFocusHandler.FocusSource source) {
                    return true;
                }
            });
            invisibleBrowser.getClient().addLifeSpanHandler((CefLifeSpanHandler)new QueuedLifeSpanHandler((DelegatingQueuedBrowser)invisibleBrowser){

                @Override
                public boolean doClose(CefBrowser browser) {
                    return true;
                }
            });
            invisibleBrowser.getClient().addLoadHandler((CefLoadHandler)new CefLoadHandlerAdapter(){

                public void onLoadError(CefBrowser browser, CefFrame frame, CefLoadHandler.ErrorCode errorCode, String errorText, String failedUrl) {
                    log.error("callServer('{}') has thrown error {}: {}. Closing browser instance.", new Object[]{url, errorCode, errorText});
                }

                public void onLoadEnd(CefBrowser browser, CefFrame frame, int httpStatusCode) {
                    log.debug("callServer('{}') has exited with status {}.", (Object)url, (Object)httpStatusCode);
                    this.fireEndListener();
                    Executors.newSingleThreadExecutor().submit(() -> {
                        try {
                            Thread.sleep(10000L);
                            SwingUtilities.invokeLater(() -> this.disposeBrowserAndClient());
                        }
                        catch (InterruptedException ex) {
                            log.error("Waiting for background browser failed!", (Throwable)ex);
                        }
                    });
                }

                private void disposeBrowserAndClient() {
                    invisibleBrowser.close(true);
                    invisibleBrowser.getClient().dispose();
                }

                private void fireEndListener() {
                    if (callEndedListener != null) {
                        callEndedListener.run();
                    }
                }
            });
            invisibleBrowser.createImmediately();
        });
    }

    @Override
    public BrowserPanel createBrowserPanel() {
        return new JCEFBrowserPanel();
    }

    @Override
    public void navigateAndFocusBrowserFrame(JCEFBrowserFrame brDlg, String strURL) {
        brDlg.setVisible(true);
        brDlg.requestFocus();
        if (StringUtils.isNotBlank((CharSequence)strURL)) {
            brDlg.navigate(this.resolveURL(strURL));
        }
    }

    public String resolveURL(String relativeURL) {
        return new NonEncodingURI(this.getBasicURL()).resolve(relativeURL).toString();
    }
}

