/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.browser.jcef;

import de.riwagis.browser.WindowManagerSettings;
import de.riwagis.browser.jcef.DelegatingQueuedBrowser;
import de.riwagis.browser.jcef.handler.FocusHandler;
import de.riwagis.browser.jcef.handler.JSDialogHandler;
import de.riwagis.browser.jcef.handler.MailSchemeHandler;
import de.riwagis.util.Config;
import de.riwagis.util.i18n.I18N;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.io.UncheckedIOException;
import java.net.ServerSocket;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Locale;
import java.util.Map;
import java.util.OptionalInt;
import java.util.function.Consumer;
import java.util.stream.IntStream;
import lombok.Generated;
import me.friwi.jcefmaven.CefAppBuilder;
import me.friwi.jcefmaven.CefInitializationException;
import me.friwi.jcefmaven.MavenCefAppHandlerAdapter;
import me.friwi.jcefmaven.UnsupportedPlatformException;
import org.apache.commons.io.FileUtils;
import org.cef.CefApp;
import org.cef.CefClient;
import org.cef.CefSettings;
import org.cef.browser.CefBrowser;
import org.cef.browser.CefFrame;
import org.cef.callback.CefSchemeHandlerFactory;
import org.cef.callback.CefSchemeRegistrar;
import org.cef.handler.CefFocusHandler;
import org.cef.handler.CefJSDialogHandler;
import org.cef.handler.CefResourceHandler;
import org.cef.network.CefRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JCEFIntegration {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JCEFIntegration.class);
    private static final boolean OSR_ENABLED = false;
    private static JCEFIntegration instance;
    private final I18N i18n = new I18N(Config.LOCALE, "de.riwagis.browser.i18n.i18n");
    private final CefApp cefApp;
    private final CefSettings cefSettings;

    private JCEFIntegration(WindowManagerSettings settings) {
        this.cleanupOldSessions();
        CefAppBuilder builder = new CefAppBuilder();
        builder.setInstallDir(new File("cef"));
        builder.setProgressHandler((state, percent) -> log.info("JCEF Builder - " + state + " |> " + (Serializable)(percent == -1.0f ? "In progress..." : Float.valueOf(percent))));
        builder.setSkipInstallation(true);
        Map<String, String> customSettings = settings.getCustomSettings();
        String cefArguments = customSettings.get("cef-arguments");
        if (cefArguments != null) {
            log.info("Native chromium arguments: {}", (Object)cefArguments);
            builder.addJcefArgs(cefArguments.split(" "));
        }
        this.cefSettings = builder.getCefSettings();
        this.cefSettings.windowless_rendering_enabled = false;
        if (settings.getDebugPort() != 0) {
            this.cefSettings.remote_debugging_port = settings.getDebugPort();
        } else {
            this.getFreePort(8555, 8565).ifPresent(i -> {
                this.cefSettings.remote_debugging_port = i;
            });
        }
        String cefLogLevel = customSettings.getOrDefault("cef-loglevel", CefSettings.LogSeverity.LOGSEVERITY_DISABLE.toString());
        log.info("Native chromium loglevel: {}", (Object)cefLogLevel);
        this.cefSettings.log_severity = CefSettings.LogSeverity.valueOf((String)cefLogLevel);
        String cefLogFile = customSettings.get("cef-logfile");
        if (cefLogFile != null) {
            log.info("Native chromium logfile: {}", (Object)cefLogFile);
            this.cefSettings.log_file = cefLogFile;
        }
        this.cefSettings.locale = Locale.getDefault().toString();
        try {
            Path sessionCacheDir = Files.createTempDirectory("riwajcef-", new FileAttribute[0]);
            this.cefSettings.root_cache_path = sessionCacheDir.toAbsolutePath().toString();
            this.cefSettings.cache_path = null;
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
        builder.setAppHandler(new MavenCefAppHandlerAdapter(){

            public void stateHasChanged(CefApp.CefAppState state) {
                if (state == CefApp.CefAppState.TERMINATED) {
                    log.debug("JCEF peacefully terminated. Exiting");
                    System.exit(0);
                }
            }

            public void onRegisterCustomSchemes(CefSchemeRegistrar registrar) {
                if (registrar.addCustomScheme("mailto", true, false, false, false, true, false, false)) {
                    log.debug("Added scheme {}://", (Object)"mailto");
                }
            }

            public void onContextInitialized() {
                CefApp.getInstance().registerSchemeHandlerFactory("mailto", "", (CefSchemeHandlerFactory)new SchemeHandlerFactory());
            }

            class SchemeHandlerFactory
            implements CefSchemeHandlerFactory {
                SchemeHandlerFactory() {
                }

                public CefResourceHandler create(CefBrowser browser, CefFrame frame, String schemeName, CefRequest request) {
                    if (schemeName.equals("mailto")) {
                        return new MailSchemeHandler();
                    }
                    return null;
                }
            }
        });
        this.cefApp = this.buildCefAppOrExit(builder);
        log.info("*** Initalized JCEF Integration ***");
        log.info("Offscreen rendering disabled");
        log.info("Remote debugging " + (String)(this.isRemoteDebuggingEnabled() ? "enabled on port " + this.cefSettings.remote_debugging_port : "disabled"));
        CefApp.CefVersion version = this.cefApp.getVersion();
        log.info("Using JCEF Version " + version.getJcefVersion());
        log.info("Using CEF Version " + version.getCefVersion());
        log.info("Using Chromium Version " + version.getChromeVersion());
    }

    private void cleanupOldSessions() {
        try {
            Path tempRoot = Path.of(System.getProperty("java.io.tmpdir"), new String[0]);
            Files.find(tempRoot, 1, (p, attrs) -> p.getFileName().toString().startsWith("riwajcef-"), new FileVisitOption[0]).filter(p -> !Files.exists(p.resolve("lockfile"), new LinkOption[0])).forEach(p -> {
                try {
                    FileUtils.deleteDirectory((File)p.toFile());
                }
                catch (IOException ioex) {
                    log.warn("Could not delete old chromium session directory.", (Throwable)ioex);
                }
            });
        }
        catch (IOException ex) {
            log.warn("Could not cleanup old chromium session directories.", (Throwable)ex);
        }
    }

    private CefApp buildCefAppOrExit(CefAppBuilder builder) {
        try {
            return builder.build();
        }
        catch (IOException | InterruptedException | CefInitializationException | UnsupportedPlatformException ex) {
            log.error("JCEF Startup initialization failed!");
            System.exit(-1);
            return null;
        }
    }

    public static synchronized JCEFIntegration startup(WindowManagerSettings settings) {
        if (instance != null) {
            throw new IllegalStateException("JCEF was already initialized");
        }
        instance = new JCEFIntegration(settings);
        return instance;
    }

    public static synchronized JCEFIntegration getInstance() {
        if (instance == null) {
            instance = new JCEFIntegration(new WindowManagerSettings());
        }
        return instance;
    }

    private CefClient createClient() {
        CefClient cefClient = this.cefApp.createClient();
        cefClient.addJSDialogHandler((CefJSDialogHandler)new JSDialogHandler());
        cefClient.addFocusHandler((CefFocusHandler)new FocusHandler());
        return cefClient;
    }

    public String getRemoteDebuggingURL() {
        if (this.cefSettings.remote_debugging_port == 0) {
            return null;
        }
        return String.format("http://127.0.0.1:%d/", this.cefSettings.remote_debugging_port);
    }

    public CefBrowser createBrowser(String url, boolean transparent, Consumer<CefClient> clientInitializer) {
        CefClient client = this.createClient();
        if (clientInitializer != null) {
            clientInitializer.accept(client);
        }
        return new DelegatingQueuedBrowser(client.createBrowser(url, false, transparent));
    }

    public boolean isRemoteDebuggingEnabled() {
        return this.cefSettings.remote_debugging_port != 0;
    }

    private OptionalInt getFreePort(int from, int to) {
        return IntStream.range(from, to).filter(this::isLocalPortFree).findFirst();
    }

    private boolean isLocalPortFree(int port) {
        try {
            new ServerSocket(port).close();
            return true;
        }
        catch (IOException ex) {
            return false;
        }
    }

    public I18N getI18n() {
        return this.i18n;
    }
}

