/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.browser.jcef;

import de.riwagis.browser.BrowserPanel;
import de.riwagis.browser.JSResponseListener;
import de.riwagis.browser.QueryListener;
import de.riwagis.browser.QueryRouter;
import de.riwagis.browser.jcef.DelegatingQueuedBrowser;
import de.riwagis.browser.jcef.JCEFIntegration;
import de.riwagis.browser.jcef.RescalingWrapperPanel;
import de.riwagis.browser.jcef.handler.ContextMenuHandler;
import de.riwagis.browser.jcef.handler.DownloadHandler;
import de.riwagis.browser.jcef.handler.KeyboardHandler;
import de.riwagis.browser.jcef.handler.MessageRouterHandler;
import de.riwagis.browser.jcef.handler.QueuedLifeSpanHandler;
import de.riwagis.browser.util.BrowserSupport;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Collection;
import java.util.concurrent.CountDownLatch;
import java.util.function.Consumer;
import javax.swing.SwingUtilities;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.cef.CefClient;
import org.cef.browser.CefBrowser;
import org.cef.browser.CefFrame;
import org.cef.browser.CefMessageRouter;
import org.cef.handler.CefContextMenuHandler;
import org.cef.handler.CefDownloadHandler;
import org.cef.handler.CefKeyboardHandler;
import org.cef.handler.CefLifeSpanHandler;
import org.cef.handler.CefMessageRouterHandler;
import org.cef.handler.CefRequestHandler;
import org.cef.handler.CefRequestHandlerAdapter;
import org.cef.network.CefRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JCEFBrowserPanel
extends BrowserPanel {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JCEFBrowserPanel.class);
    private final CefBrowser browser;
    private final Component browserUI;
    private final CefClient client;
    private boolean openLinkExternal;
    private File staticContentFile;
    private JSResponseListener jsResponseListener = new JSResponseListener();
    private QueryRouter queryRouter = new QueryRouter(this);

    private JCEFBrowserPanel(String url, boolean transparent) {
        this.browser = JCEFIntegration.getInstance().createBrowser(url, transparent, c -> {
            CefMessageRouter msgRouter = CefMessageRouter.create();
            msgRouter.addHandler((CefMessageRouterHandler)new MessageRouterHandler(this.queryRouter), true);
            this.queryRouter.addListener(this.jsResponseListener);
            c.addMessageRouter(msgRouter);
        });
        this.client = this.browser.getClient();
        KeyboardHandler keyboardHandler = new KeyboardHandler(this.browser);
        this.client.addKeyboardHandler((CefKeyboardHandler)keyboardHandler);
        this.client.addContextMenuHandler((CefContextMenuHandler)new ContextMenuHandler(keyboardHandler::isShiftDownAndReset));
        this.client.addLifeSpanHandler((CefLifeSpanHandler)new QueuedLifeSpanHandler((DelegatingQueuedBrowser)this.browser){

            @Override
            public boolean onBeforePopup(CefBrowser browser, CefFrame frame, String target_url, String target_frame_name) {
                if (!JCEFBrowserPanel.this.openLinkExternal) {
                    return super.onBeforePopup(browser, frame, target_url, target_frame_name);
                }
                JCEFBrowserPanel.this.openInSystemBrowser(target_url);
                return true;
            }
        });
        this.client.addDownloadHandler((CefDownloadHandler)new DownloadHandler(() -> SwingUtilities.windowForComponent(this.browser.getUIComponent())));
        this.client.addRequestHandler((CefRequestHandler)new CefRequestHandlerAdapter(){

            public boolean onBeforeBrowse(CefBrowser browser, CefFrame frame, CefRequest request, boolean user_gesture, boolean is_redirect) {
                JCEFBrowserPanel aThis = JCEFBrowserPanel.this;
                if (aThis.browser.getIdentifier() != browser.getIdentifier() || !aThis.getOpenLinkExternal() || browser.getURL().equals(request.getURL()) || "about:blank".equals(browser.getURL()) || !StringUtils.isNotBlank((CharSequence)browser.getURL())) {
                    return false;
                }
                JCEFBrowserPanel.this.openInSystemBrowser(request.getURL());
                return true;
            }
        });
        this.browserUI = this.browser.getUIComponent();
        this.openLinkExternal = false;
        this.setLayout(new BorderLayout());
        RescalingWrapperPanel wrapperPanel = new RescalingWrapperPanel(this.browser);
        this.add((Component)wrapperPanel, "Center");
    }

    public JCEFBrowserPanel() {
        this("about:blank", false);
    }

    @Override
    public String getHTML() {
        String[] html = new String[]{""};
        try {
            CountDownLatch finishedSignal = new CountDownLatch(1);
            this.browser.getSource(source -> {
                html[0] = source;
                finishedSignal.countDown();
            });
            finishedSignal.await();
        }
        catch (InterruptedException ex) {
            log.error("Could not get HTML from JCEF Browser Panel.", (Throwable)ex);
        }
        return html[0];
    }

    @Override
    public void setHTML(String html) {
        try {
            if (this.staticContentFile == null) {
                this.staticContentFile = File.createTempFile("jcef-static-site", ".html");
                this.staticContentFile.deleteOnExit();
            }
            Files.writeString(this.staticContentFile.toPath(), (CharSequence)html, new OpenOption[0]);
            this.browser.loadURL(this.staticContentFile.toURI().toString());
        }
        catch (IOException e) {
            log.error("Could not navigate to file with static content.");
        }
    }

    @Override
    public boolean getOpenLinkExternal() {
        return this.openLinkExternal;
    }

    @Override
    public void setOpenLinkExternal(boolean openLinkExternal) {
        this.openLinkExternal = openLinkExternal;
    }

    @Override
    public void navigate(String strURL) {
        this.browser.loadURL(strURL);
    }

    @Override
    public String getURL() {
        String url = this.browser.getURL();
        if (url.startsWith("file://")) {
            return "";
        }
        return url;
    }

    @Override
    public void refresh() {
        this.browser.reload();
    }

    @Override
    public boolean isLoading() {
        return this.browser.isLoading();
    }

    @Override
    public void dispose() {
        if (this.browser == null) {
            return;
        }
        this.browser.setCloseAllowed();
        this.browser.getClient().dispose();
    }

    @Override
    public void execJS(String jscript) {
        this.browser.executeJavaScript(jscript, this.browser.getURL(), 0);
    }

    @Override
    public String execJSWithReturn(String jscript) {
        try {
            return this.jsResponseListener.executeAndWait(this, jscript, 60000L);
        }
        catch (InterruptedException ex) {
            throw new IllegalStateException("JavaScript didn't answer in time.", ex);
        }
    }

    @Override
    public void execJSWithReturn(String jscript, Consumer<String> successHandler, Consumer<String> errorHandler) {
        this.jsResponseListener.execute(this, jscript, successHandler, errorHandler);
    }

    @Override
    public void addQueryListener(QueryListener listener) {
        this.queryRouter.addListener(listener);
    }

    @Override
    public void removeQueryListener(QueryListener listener) {
        this.queryRouter.removeListener(listener);
    }

    @Override
    public Collection<QueryListener> getQueryListeners() {
        return this.queryRouter.getListeners();
    }

    public void openInSystemBrowser(String url) {
        log.debug("Open Link in system browser: {}", (Object)url);
        BrowserSupport.openBrowser(url);
    }

    @Override
    public void setVisible(boolean aFlag) {
        super.setVisible(aFlag);
        if (!aFlag) {
            this.setSize(0, 0);
        }
    }

    public void createImmediately() {
        this.browser.createImmediately();
    }
}

