/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.browser.jcef;

import de.riwagis.browser.BrowserFrame;
import de.riwagis.browser.BrowserQueryable;
import de.riwagis.browser.JSResponseListener;
import de.riwagis.browser.QueryListener;
import de.riwagis.browser.QueryRouter;
import de.riwagis.browser.jcef.DelegatingQueuedBrowser;
import de.riwagis.browser.jcef.JCEFIntegration;
import de.riwagis.browser.jcef.JCEFWindowManager;
import de.riwagis.browser.jcef.RescalingWrapperPanel;
import de.riwagis.browser.jcef.handler.ContextMenuHandler;
import de.riwagis.browser.jcef.handler.DisplayHandler;
import de.riwagis.browser.jcef.handler.DownloadHandler;
import de.riwagis.browser.jcef.handler.KeyboardHandler;
import de.riwagis.browser.jcef.handler.LoadHandler;
import de.riwagis.browser.jcef.handler.MessageRouterHandler;
import de.riwagis.browser.jcef.handler.QueuedLifeSpanHandler;
import de.riwagis.browser.jcef.handler.RequestHandler;
import de.riwagis.util.i18n.I18N;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.Rectangle;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.function.Consumer;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileNameExtensionFilter;
import lombok.Generated;
import org.cef.CefClient;
import org.cef.browser.CefBrowser;
import org.cef.browser.CefMessageRouter;
import org.cef.handler.CefContextMenuHandler;
import org.cef.handler.CefDisplayHandler;
import org.cef.handler.CefDownloadHandler;
import org.cef.handler.CefKeyboardHandler;
import org.cef.handler.CefLifeSpanHandler;
import org.cef.handler.CefLoadHandler;
import org.cef.handler.CefMessageRouterHandler;
import org.cef.handler.CefRequestHandler;
import org.cef.misc.CefPdfPrintSettings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JCEFBrowserFrame
extends JFrame
implements BrowserFrame,
BrowserQueryable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JCEFBrowserFrame.class);
    private final CefClient client;
    private final CefBrowser browser;
    private final Component browserUI;
    private final JSplitPane splitPane;
    private JToolBar toolBar;
    private JFileChooser pdfSaveFileChooser;
    private CefBrowser devTools;
    private JSResponseListener jsResponseListener = new JSResponseListener();
    private QueryRouter queryRouter = new QueryRouter(this);
    private boolean isClosed = false;
    private static final int DIN_A4_WIDTH_MM = 210;
    private static final int DIN_A4_HEIGHT_MM = 297;

    public JCEFBrowserFrame() {
        this("about:blank", false);
    }

    public JCEFBrowserFrame(String url, boolean isTransparent) {
        super(JCEFBrowserFrame.getParentGC());
        this.browser = JCEFIntegration.getInstance().createBrowser(url, isTransparent, c -> {
            CefMessageRouter msgRouter = CefMessageRouter.create();
            msgRouter.addHandler((CefMessageRouterHandler)new MessageRouterHandler(this.queryRouter), true);
            this.queryRouter.addListener(this.jsResponseListener);
            c.addMessageRouter(msgRouter);
        });
        this.browserUI = this.browser.getUIComponent();
        this.devTools = null;
        this.client = this.browser.getClient();
        this.client.addLifeSpanHandler((CefLifeSpanHandler)new QueuedLifeSpanHandler((DelegatingQueuedBrowser)this.browser, () -> {
            this.isClosed = true;
        }));
        this.client.addDisplayHandler((CefDisplayHandler)new DisplayHandler(this));
        KeyboardHandler keyboardHandler = new KeyboardHandler(this.browser, cb -> SwingUtilities.invokeLater(this::toggleDevTools));
        this.client.addKeyboardHandler((CefKeyboardHandler)keyboardHandler);
        this.client.addContextMenuHandler((CefContextMenuHandler)new ContextMenuHandler(keyboardHandler::isShiftDownAndReset));
        this.client.addLoadHandler((CefLoadHandler)new LoadHandler(this));
        this.client.addDownloadHandler((CefDownloadHandler)new DownloadHandler(() -> this));
        this.client.addRequestHandler((CefRequestHandler)new RequestHandler(this));
        RescalingWrapperPanel wrapperPanel = new RescalingWrapperPanel(this.browser);
        this.splitPane = new JSplitPane(1, wrapperPanel, null);
        this.splitPane.setDividerSize(0);
        this.splitPane.setDividerLocation(0.75);
        this.splitPane.setResizeWeight(0.75);
        this.splitPane.setBorder(BorderFactory.createEmptyBorder());
        this.setAlwaysOnTop(true);
        this.add((Component)this.splitPane, "Center");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                log.debug("Received window closed. Trying to close browser.");
                if (JCEFBrowserFrame.this.browser == null) {
                    log.info("Disposing directly as there is no browser");
                    JCEFBrowserFrame.this.dispose();
                    return;
                }
                boolean forceClose = JCEFBrowserFrame.this.isClosed;
                if (forceClose) {
                    JCEFBrowserFrame.this.browser.setCloseAllowed();
                }
                log.info("Invoking browser close (forced: {})", (Object)forceClose);
                JCEFBrowserFrame.this.browser.close(forceClose);
                if (forceClose) {
                    log.info("Finally invoking dispose");
                    JCEFBrowserFrame.this.dispose();
                }
            }
        });
        this.setSize(640, 480);
        this.centreOnScreen();
        this.setDefaultCloseOperation(0);
    }

    @Override
    public void addQueryListener(QueryListener listener) {
        this.queryRouter.addListener(listener);
    }

    @Override
    public void removeQueryListener(QueryListener listener) {
        this.queryRouter.removeListener(listener);
    }

    @Override
    public Collection<QueryListener> getQueryListeners() {
        return this.queryRouter.getListeners();
    }

    @Override
    public void setVisible(boolean bolVisible) {
        super.setVisible(bolVisible);
    }

    @Override
    public void setPosSize(int left, int top, int width, int height) {
        this.setLocation(left, top);
        this.setSize(width, height);
    }

    @Override
    public void showToolbar() {
        if (this.toolBar == null) {
            this.createPdfFileChooser();
            I18N i18n = JCEFIntegration.getInstance().getI18n();
            JButton printButton = new JButton(i18n.get("jcef.frame.print"));
            printButton.addActionListener(e -> this.browser.print());
            JButton printToPdfButton = new JButton(i18n.get("jcef.frame.print-pdf"));
            printToPdfButton.addActionListener(e -> this.pdfSaveFileChooser.showSaveDialog(this.browserUI));
            this.toolBar = new JToolBar();
            this.toolBar.add(printButton);
            this.toolBar.add(printToPdfButton);
            this.toolBar.setFloatable(false);
            this.toolBar.setRollover(true);
            this.add((Component)this.toolBar, "North");
            this.repack();
        }
    }

    private void repack() {
        Dimension size = this.getSize();
        this.pack();
        this.setSize(size);
    }

    @Override
    public void centreOnScreen() {
        this.setLocationRelativeTo(this.getParentFrame());
    }

    public void setLocationRelativeToScreen(int x, int y) {
        GraphicsConfiguration parentGC = JCEFBrowserFrame.getParentGC();
        if (parentGC == null) {
            super.setLocation(x, y);
            return;
        }
        Rectangle bounds = parentGC.getBounds();
        super.setLocation(bounds.x + x, bounds.y + y);
    }

    @Override
    public void setLocation(int x, int y) {
        super.setLocation(x, y);
    }

    @Override
    public void setSize(int intWidth, int intHeight) {
        super.setSize(intWidth, intHeight);
    }

    @Override
    public void requestFocus() {
        if ((this.getExtendedState() & 1) != 0) {
            this.setExtendedState(this.getExtendedState() & 0x7FFFFFFE);
        }
        this.browserUI.requestFocus();
    }

    @Override
    public void setTitle(String strTitle) {
        super.setTitle(strTitle);
    }

    @Override
    public void execJS(String jscript) {
        this.browser.executeJavaScript(jscript, this.browser.getURL(), 0);
    }

    @Override
    public String execJSWithReturn(String jscript) {
        try {
            return this.jsResponseListener.executeAndWait(this, jscript, 60000L);
        }
        catch (InterruptedException ex) {
            throw new IllegalStateException("JavaScript didn't answer in time.", ex);
        }
    }

    @Override
    public void execJSWithReturn(String jscript, Consumer<String> successHandler, Consumer<String> errorHandler) {
        this.jsResponseListener.execute(this, jscript, successHandler, errorHandler);
    }

    @Override
    public boolean isLoading() {
        return this.browser.isLoading();
    }

    @Override
    public void navigate(String strURL) {
        this.browser.loadURL(strURL);
    }

    @Override
    public String getURL() {
        return this.browser.getURL();
    }

    @Override
    public void refresh() {
        this.browser.reload();
    }

    @Override
    public void dispose() {
        this.browser.getClient().dispose();
        super.dispose();
    }

    private void toggleDevTools() {
        if (this.splitPane.getDividerSize() == 0) {
            if (this.devTools == null) {
                this.devTools = this.browser.getDevTools();
                RescalingWrapperPanel wrapperPanel = new RescalingWrapperPanel(this.devTools);
                this.splitPane.setRightComponent(wrapperPanel);
            }
            this.splitPane.setDividerLocation(0.75);
            this.splitPane.getRightComponent().setVisible(true);
            this.splitPane.setDividerSize(5);
        } else {
            this.splitPane.setDividerSize(0);
            this.splitPane.getRightComponent().setVisible(false);
        }
    }

    private void createPdfFileChooser() {
        if (this.pdfSaveFileChooser != null) {
            return;
        }
        final I18N i18n = JCEFIntegration.getInstance().getI18n();
        this.pdfSaveFileChooser = new JFileChooser(){

            @Override
            public void approveSelection() {
                File f = this.getSelectedFile();
                if (f.exists() && this.getDialogType() == 1) {
                    int result = JOptionPane.showConfirmDialog(this, i18n.get("jcef.frame.overwrite-file"), i18n.get("jcef.frame.file-exists"), 0);
                    switch (result) {
                        case 0: {
                            super.approveSelection();
                            return;
                        }
                        case -1: 
                        case 1: {
                            return;
                        }
                    }
                }
                super.approveSelection();
            }
        };
        FileNameExtensionFilter pdfFilter = new FileNameExtensionFilter("PDF", "pdf");
        this.pdfSaveFileChooser.addChoosableFileFilter(pdfFilter);
        this.pdfSaveFileChooser.setFileFilter(pdfFilter);
        this.pdfSaveFileChooser.addActionListener(action -> {
            if (action.getActionCommand().equals("ApproveSelection")) {
                CefPdfPrintSettings settings = new CefPdfPrintSettings();
                settings.paper_width = Math.round(8.267716535433072);
                settings.paper_height = Math.round(11.692913385826772);
                String absolutePath = this.ensureFileEnding(this.pdfSaveFileChooser.getSelectedFile().getAbsolutePath(), ".pdf");
                this.browser.printToPDF(absolutePath, settings, (path, ok) -> {
                    if (ok) {
                        try {
                            Desktop.getDesktop().open(new File(path));
                        }
                        catch (IOException ex) {
                            log.error("Opening PDF failed!", (Throwable)ex);
                            SwingUtilities.invokeLater(() -> JOptionPane.showMessageDialog(this.browserUI, i18n.get("jcef.frame.open-pdf-failed"), i18n.get("jcef.frame.title-error"), 0));
                        }
                    } else {
                        log.error("PDF Export failed!");
                        SwingUtilities.invokeLater(() -> JOptionPane.showMessageDialog(this.browserUI, i18n.get("jcef.frame.print-pdf-failed"), i18n.get("jcef.frame.title-error"), 0));
                    }
                });
            }
        });
    }

    private String ensureFileEnding(String filePath, String sending) {
        if (!filePath.toLowerCase().endsWith(sending)) {
            return filePath + sending;
        }
        return filePath;
    }

    public boolean isBrowserOfWindow(CefBrowser other) {
        return this.browser.getIdentifier() == other.getIdentifier();
    }

    public void createImmediately() {
        this.browser.createImmediately();
    }

    private Frame getParentFrame() {
        Frame parentFrame = JCEFWindowManager.getInstance().getFallbackParentFrame();
        if (parentFrame == null) {
            return null;
        }
        return parentFrame;
    }

    private static GraphicsConfiguration getParentGC() {
        Frame parentFrame = JCEFWindowManager.getInstance().getFallbackParentFrame();
        if (parentFrame == null) {
            return null;
        }
        return parentFrame.getGraphicsConfiguration();
    }
}

