/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.browser.jcef;

import java.awt.Component;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.util.LinkedList;
import java.util.Queue;
import java.util.Vector;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Semaphore;
import javax.swing.SwingUtilities;
import lombok.Generated;
import org.cef.CefClient;
import org.cef.browser.CefBrowser;
import org.cef.browser.CefDevToolsClient;
import org.cef.browser.CefFrame;
import org.cef.callback.CefPdfPrintCallback;
import org.cef.callback.CefRunFileDialogCallback;
import org.cef.callback.CefStringVisitor;
import org.cef.handler.CefDialogHandler;
import org.cef.handler.CefRenderHandler;
import org.cef.handler.CefWindowHandler;
import org.cef.misc.CefPdfPrintSettings;
import org.cef.network.CefRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DelegatingQueuedBrowser
implements CefBrowser {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DelegatingQueuedBrowser.class);
    private final CefBrowser delegate;
    private final Queue<Runnable> eventQueue;
    private boolean browserInitialized;
    private final Semaphore queueSemaphore;

    public DelegatingQueuedBrowser(CefBrowser delegate) {
        this.delegate = delegate;
        this.eventQueue = new LinkedList<Runnable>();
        this.browserInitialized = false;
        this.queueSemaphore = new Semaphore(1);
    }

    public void loadURL(String url) {
        this.runOrQueueAction(() -> this.delegate.loadURL(url));
    }

    public void loadRequest(CefRequest request) {
        this.runOrQueueAction(() -> this.delegate.loadRequest(request));
    }

    public void executeJavaScript(String code, String url, int line) {
        this.runOrQueueAction(() -> this.delegate.executeJavaScript(code, url, line));
    }

    public void reload() {
        this.runOrQueueAction(() -> this.delegate.reload());
    }

    public void setZoomLevel(double zoomLevel) {
        this.runOrQueueAction(() -> this.delegate.setZoomLevel(zoomLevel));
    }

    private void runOrQueueAction(Runnable runnable) {
        try {
            this.queueSemaphore.acquire();
            if (this.browserInitialized) {
                runnable.run();
            } else {
                this.eventQueue.add(runnable);
            }
            this.queueSemaphore.release();
        }
        catch (InterruptedException ex) {
            log.error("Could not sync JCEF Browser Event Queue", (Throwable)ex);
        }
    }

    public void runQueuedOperations() {
        try {
            this.queueSemaphore.acquire();
            this.browserInitialized = true;
            SwingUtilities.invokeLater(() -> this.eventQueue.forEach(Runnable::run));
            this.queueSemaphore.release();
        }
        catch (InterruptedException ex) {
            log.error("Could not sync JCEF Browser Event Queue", (Throwable)ex);
        }
    }

    public void createImmediately() {
        this.delegate.createImmediately();
    }

    public Component getUIComponent() {
        return this.delegate.getUIComponent();
    }

    public CefClient getClient() {
        return this.delegate.getClient();
    }

    public CefRenderHandler getRenderHandler() {
        return this.delegate.getRenderHandler();
    }

    public CefWindowHandler getWindowHandler() {
        return this.delegate.getWindowHandler();
    }

    public boolean canGoBack() {
        return this.delegate.canGoBack();
    }

    public void goBack() {
        this.delegate.goBack();
    }

    public boolean canGoForward() {
        return this.delegate.canGoForward();
    }

    public void goForward() {
        this.delegate.goForward();
    }

    public boolean isLoading() {
        return this.delegate.isLoading();
    }

    public void reloadIgnoreCache() {
        this.delegate.reloadIgnoreCache();
    }

    public void stopLoad() {
        this.delegate.stopLoad();
    }

    public int getIdentifier() {
        return this.delegate.getIdentifier();
    }

    public CefFrame getMainFrame() {
        return this.delegate.getMainFrame();
    }

    public CefFrame getFocusedFrame() {
        return this.delegate.getFocusedFrame();
    }

    public Vector<String> getFrameIdentifiers() {
        return this.delegate.getFrameIdentifiers();
    }

    public Vector<String> getFrameNames() {
        return this.delegate.getFrameNames();
    }

    public int getFrameCount() {
        return this.delegate.getFrameCount();
    }

    public boolean isPopup() {
        return this.delegate.isPopup();
    }

    public boolean hasDocument() {
        return this.delegate.hasDocument();
    }

    public void viewSource() {
        this.delegate.viewSource();
    }

    public void getSource(CefStringVisitor csv) {
        this.delegate.getSource(csv);
    }

    public void getText(CefStringVisitor csv) {
        this.delegate.getText(csv);
    }

    public String getURL() {
        return this.delegate.getURL();
    }

    public void close(boolean bln) {
        this.delegate.close(bln);
    }

    public void setCloseAllowed() {
        this.delegate.setCloseAllowed();
    }

    public boolean doClose() {
        return this.delegate.doClose();
    }

    public void onBeforeClose() {
        this.delegate.onBeforeClose();
    }

    public void setFocus(boolean bln) {
        this.delegate.setFocus(bln);
    }

    public void setWindowVisibility(boolean bln) {
        this.delegate.setWindowVisibility(bln);
    }

    public double getZoomLevel() {
        return this.delegate.getZoomLevel();
    }

    public void runFileDialog(CefDialogHandler.FileDialogMode fdm, String string, String string1, Vector<String> vector, int i, CefRunFileDialogCallback crfdc) {
        this.delegate.runFileDialog(fdm, string, string1, vector, i, crfdc);
    }

    public void startDownload(String string) {
        this.delegate.startDownload(string);
    }

    public void print() {
        this.delegate.print();
    }

    public void printToPDF(String string, CefPdfPrintSettings cpps, CefPdfPrintCallback cppc) {
        this.delegate.printToPDF(string, cpps, cppc);
    }

    public void find(String string, boolean bln, boolean bln1, boolean bln2) {
        this.delegate.find(string, bln, bln1, bln2);
    }

    public void stopFinding(boolean bln) {
        this.delegate.stopFinding(bln);
    }

    public CefBrowser getDevTools() {
        return this.delegate.getDevTools();
    }

    public CefBrowser getDevTools(Point point) {
        return this.delegate.getDevTools(point);
    }

    public void replaceMisspelling(String string) {
        this.delegate.replaceMisspelling(string);
    }

    public CompletableFuture<BufferedImage> createScreenshot(boolean bln) {
        return this.delegate.createScreenshot(bln);
    }

    CefBrowser getDelegate() {
        return this.delegate;
    }

    public CefFrame getFrameByIdentifier(String string) {
        return this.delegate.getFrameByIdentifier(string);
    }

    public CefFrame getFrameByName(String string) {
        return this.delegate.getFrameByName(string);
    }

    public CefDevToolsClient getDevToolsClient() {
        return this.delegate.getDevToolsClient();
    }

    public void setWindowlessFrameRate(int i) {
        this.delegate.setWindowlessFrameRate(i);
    }

    public CompletableFuture<Integer> getWindowlessFrameRate() {
        return this.delegate.getWindowlessFrameRate();
    }
}

