/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.browser;

import de.riwagis.browser.BrowserFrame;
import de.riwagis.browser.BrowserFrameFactory;
import de.riwagis.browser.BrowserPanel;
import de.riwagis.browser.OpenWindowConfiguration;
import de.riwagis.browser.WindowManagerProvider;
import de.riwagis.browser.WindowManagerSettings;
import de.riwagis.browser.jcef.JCEFWindowManagerProvider;
import de.riwagis.browser.jxbrowser.JxWindowManagerProvider;
import de.riwagis.browser.webview.WVWindowManagerProvider;
import de.riwagis.browser.xulrunner.XulWindowManagerProvider;
import de.riwagis.util.exception.SystemException;
import java.awt.Frame;
import java.awt.Image;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class WindowManager<T extends BrowserFrame> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WindowManager.class);
    private static WindowManager INSTANCE;
    private URI forwardProxy = null;
    private String webgisPath = null;
    protected final Map<String, T> mapWindows = new HashMap<String, T>();
    protected final ReadWriteLock lock = new ReentrantReadWriteLock();
    private Frame fallbackParentFrame;
    private final BrowserFrameFactory<T> bfFactory;
    private T invisibleBrowser = null;
    private Optional<List<? extends Image>> windowIcons = Optional.empty();
    private static final List<WindowManagerProvider> PROVIDERS;

    protected WindowManager(BrowserFrameFactory<T> bfFactory) {
        this.bfFactory = bfFactory;
    }

    public static void startup(WindowManagerSettings settings) {
        if (INSTANCE != null) {
            throw new IllegalStateException("Window manager was already initialized");
        }
        log.debug("Trying to find good browser provider");
        INSTANCE = PROVIDERS.stream().filter(settings.getProviderFilter()).filter(WindowManagerProvider::isAvailable).findFirst().map(provider -> provider.create(settings)).orElseThrow(() -> new IllegalStateException("No browser implementation found"));
        log.info("Using window manager {}", INSTANCE.getClass());
    }

    public static WindowManager getInstance() {
        if (INSTANCE == null) {
            WindowManager.startup(new WindowManagerSettings());
        }
        return INSTANCE;
    }

    protected void navigateInvisibleBrowser(String url) {
        this.getInvisibleBrowser().navigate(url);
    }

    public abstract void closeWindow(String var1) throws SystemException;

    public void closeAll() throws SystemException {
        ArrayList<String> lstWindows = new ArrayList<String>();
        try {
            this.lock.readLock().lock();
            lstWindows.addAll(this.mapWindows.keySet());
        }
        finally {
            this.lock.readLock().unlock();
        }
        for (Object e : lstWindows) {
            this.closeWindow(e.toString());
        }
    }

    @Deprecated
    public static void closeAllWindows() throws SystemException {
        WindowManager winMngr = WindowManager.getInstance();
        winMngr.closeAll();
    }

    public BrowserFrame getWindow(String strName) {
        try {
            this.lock.readLock().lock();
            if (this.mapWindows.containsKey(strName)) {
                BrowserFrame browserFrame = (BrowserFrame)this.mapWindows.get(strName);
                return browserFrame;
            }
            BrowserFrame browserFrame = null;
            return browserFrame;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public void setForwardProxy(URI forwardProxy) {
        Objects.requireNonNull(forwardProxy, "Forward proxy is not initialized for browser.");
        this.forwardProxy = forwardProxy;
    }

    public URI getForwardProxy() {
        Objects.requireNonNull(this.forwardProxy, "Forward proxy is not initialized for browser.");
        return this.forwardProxy;
    }

    @Deprecated
    public String getBasicURL() {
        return this.getWebgisForwardProxy().toString();
    }

    public URI getWebgisForwardProxy() {
        return this.getForwardProxy().resolve(this.getWebgisPath());
    }

    public void setWebgisPath(String webgisPath) {
        Objects.requireNonNull(webgisPath, "Webgis path is not initialized for browser.");
        if (!((String)webgisPath).endsWith("/")) {
            webgisPath = (String)webgisPath + "/";
        }
        this.webgisPath = webgisPath;
    }

    public String getWebgisPath() {
        Objects.requireNonNull(this.webgisPath, "Webgis path is not initialized for browser.");
        return this.webgisPath;
    }

    public boolean isWindowRegistered(String strName) {
        this.lock.readLock().lock();
        try {
            boolean bl = this.mapWindows.containsKey(strName);
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean registerWindow(T brDlg, String strName) {
        this.lock.writeLock().lock();
        try {
            if (this.mapWindows.containsKey(strName)) {
                boolean bl = false;
                return bl;
            }
            this.mapWindows.put(strName, brDlg);
        }
        finally {
            this.lock.writeLock().unlock();
        }
        this.addWindowListeners(brDlg, strName);
        return true;
    }

    public BrowserFrame removeWindow(String windowName) {
        try {
            this.lock.writeLock().lock();
            if (this.mapWindows.containsKey(windowName)) {
                BrowserFrame browserFrame = (BrowserFrame)this.mapWindows.remove(windowName);
                return browserFrame;
            }
            BrowserFrame browserFrame = null;
            return browserFrame;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Deprecated
    public synchronized BrowserFrame openWindow(String webgisRelativeURL, String strName, int intWidth, int intHeight) throws SystemException {
        return this.openWindow(webgisRelativeURL, strName, intWidth, intHeight, -1, -1, false);
    }

    @Deprecated
    public BrowserFrame openWindow(String webgisRelativeURL, String strName, int intWidth, int intHeight, int intLeft, int intTop, boolean bolShowToolbar) throws SystemException {
        OpenWindowConfiguration.Builder builder = this.window().webgisAddress(webgisRelativeURL).name(strName).size(intWidth, intHeight).location(intTop, intTop);
        if (bolShowToolbar) {
            builder.showToolbar();
        }
        return builder.open();
    }

    public abstract BrowserFrame openWindow(OpenWindowConfiguration var1);

    public OpenWindowConfiguration.Builder window() {
        return new OpenWindowConfiguration.Builder(this);
    }

    public abstract BrowserPanel createBrowserPanel();

    public abstract void callServer(String var1);

    public abstract void callServer(String var1, Map<String, String> var2, Runnable var3);

    protected abstract void addWindowListeners(T var1, String var2);

    public abstract void navigateAndFocusBrowserFrame(T var1, String var2);

    protected void closeWindowInternal(String strName) {
        try {
            this.lock.writeLock().lock();
            if (this.mapWindows.containsKey(strName)) {
                BrowserFrame brDlgInternal = (BrowserFrame)this.mapWindows.get(strName);
                this.mapWindows.remove(strName);
                if (brDlgInternal != null) {
                    brDlgInternal.dispose();
                }
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    protected T openWindowInternal(String strName) {
        Object tmpBrowserFrame;
        if (StringUtils.isBlank((CharSequence)strName)) {
            tmpBrowserFrame = this.bfFactory.createBrowserFrame();
        } else {
            this.lock.writeLock().lock();
            try {
                if (this.mapWindows.containsKey(strName)) {
                    tmpBrowserFrame = (BrowserFrame)this.mapWindows.get(strName);
                } else {
                    tmpBrowserFrame = this.bfFactory.createBrowserFrame();
                    this.mapWindows.put(strName, tmpBrowserFrame);
                }
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }
        return tmpBrowserFrame;
    }

    protected void createInvisibleBrowser(String strURL) {
        this.getInvisibleBrowser().navigate(this.getWebgisForwardProxy().resolve(strURL).toString());
    }

    protected T getInvisibleBrowser() {
        if (this.invisibleBrowser == null) {
            this.invisibleBrowser = this.bfFactory.createBrowserFrame();
        }
        return this.invisibleBrowser;
    }

    protected Optional<List<? extends Image>> getWindowIcons() {
        return this.windowIcons;
    }

    public void setWindowIcons(List<? extends Image> windowIcons) {
        this.windowIcons = Optional.of(windowIcons);
    }

    public Frame getFallbackParentFrame() {
        return this.fallbackParentFrame;
    }

    public void setFallbackParentFrame(Frame fallbackParentFrame) {
        this.fallbackParentFrame = fallbackParentFrame;
    }

    public void shutdown() {
    }

    static {
        PROVIDERS = List.of(new JCEFWindowManagerProvider(), new JxWindowManagerProvider(), new XulWindowManagerProvider(), new WVWindowManagerProvider());
    }
}

