/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.browser;

import de.riwagis.browser.BrowserQueryable;
import de.riwagis.browser.QueryListener;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;

public class QueryRouter {
    private final LinkedHashSet<QueryListener> listeners;
    private final BrowserQueryable browser;

    public QueryRouter(BrowserQueryable browser) {
        this.browser = browser;
        this.listeners = new LinkedHashSet();
    }

    public boolean dispatch(String request, QueryListener.ResponseCallback callback) {
        for (QueryListener listener : this.listeners) {
            boolean handled;
            if (!listener.canHandle(request) || !(handled = listener.handle(this.browser, request, callback))) continue;
            return true;
        }
        return false;
    }

    public Collection<QueryListener> getListeners() {
        return Collections.unmodifiableCollection(this.listeners);
    }

    public void addListener(QueryListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(QueryListener listener) {
        this.listeners.remove(listener);
    }
}

