/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.browser;

import de.riwagis.browser.BrowserFrame;
import de.riwagis.browser.NonEncodingURI;
import de.riwagis.browser.WindowManager;
import java.awt.Dimension;
import java.awt.Point;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenWindowConfiguration {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(OpenWindowConfiguration.class);
    private final Point location;
    private final Dimension size;
    private final String name;
    private final NonEncodingURI address;
    private final boolean showToolbar;

    public OpenWindowConfiguration(Point location, Dimension size, String name, NonEncodingURI address, boolean showToolbar) {
        this.location = location;
        this.size = size;
        this.name = name;
        this.address = address;
        this.showToolbar = showToolbar;
    }

    public Point getLocation() {
        return this.location;
    }

    public Dimension getSize() {
        return this.size;
    }

    public String getName() {
        return this.name;
    }

    public NonEncodingURI getAddress() {
        return this.address;
    }

    public boolean isShowToolbar() {
        return this.showToolbar;
    }

    public static class Builder {
        private static final Dimension DEFAULT_SIZE = new Dimension(500, 500);
        private Point location;
        private Dimension size = DEFAULT_SIZE;
        private String name;
        private NonEncodingURI address;
        private boolean showToolbar = false;
        private final WindowManager<?> manager;

        public Builder(WindowManager<?> manager) {
            this.manager = manager;
        }

        public Builder location(int x, int y) {
            this.location = new Point(x, y);
            return this;
        }

        public Builder size(int width, int height) {
            this.size = new Dimension(width, height);
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder webgisAddress(String partialWebgisAddress) {
            this.address = new NonEncodingURI(this.manager.getForwardProxy()).resolve(this.manager.getWebgisPath()).resolve(partialWebgisAddress);
            return this;
        }

        public Builder proxyAddress(String partiaProxyAddress) {
            this.address = new NonEncodingURI(this.manager.getForwardProxy()).resolve(partiaProxyAddress);
            return this;
        }

        public Builder absoluteAddress(String absoluteAddress) {
            this.address = new NonEncodingURI(absoluteAddress);
            return this;
        }

        public Builder showToolbar() {
            this.showToolbar = true;
            return this;
        }

        OpenWindowConfiguration build() {
            return new OpenWindowConfiguration(this.location, this.size, this.name, this.address, this.showToolbar);
        }

        public BrowserFrame open() {
            return this.manager.openWindow(this.build());
        }

        public BrowserFrame focusOrOpen() {
            BrowserFrame window = this.manager.getWindow(this.name);
            if (window == null) {
                return this.manager.openWindow(this.build());
            }
            window.requestFocus();
            return window;
        }
    }
}

