/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.browser;

import java.net.URI;
import java.util.Objects;

public class NonEncodingURI {
    private String uri;

    public NonEncodingURI(String uri) {
        this.uri = uri;
    }

    public NonEncodingURI(URI uri) {
        this.uri = uri.toString();
    }

    public NonEncodingURI resolve(String part) {
        Objects.requireNonNull(part, "URI parts cannot be null.");
        boolean partStartsWithSlash = part.startsWith("/");
        boolean baseEndsWithSlash = this.uri.endsWith("/");
        if (baseEndsWithSlash && partStartsWithSlash) {
            part = part.substring(1);
        } else if (!baseEndsWithSlash && !partStartsWithSlash) {
            this.uri = this.uri + "/";
        }
        this.uri = this.uri + part;
        return this;
    }

    public int hashCode() {
        int hash = 7;
        hash = 89 * hash + Objects.hashCode(this.uri);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NonEncodingURI other = (NonEncodingURI)obj;
        return Objects.equals(this.uri, other.uri);
    }

    public String toString() {
        return this.uri;
    }
}

