/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.browser;

import de.riwagis.browser.BrowserQueryable;
import de.riwagis.browser.BrowserScriptable;
import de.riwagis.browser.QueryListener;
import de.riwagis.browser.QueryResponse;
import de.riwagis.browser.util.Resources;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.apache.commons.text.StringEscapeUtils;

public class JSResponseListener
implements QueryListener {
    private static final String QUERY_TEMPLATE = Resources.load(JSResponseListener.class, "callWithReturnTemplate.js");
    private static final String QUERY_IDENTIFIER = JSResponseListener.class.getSimpleName();
    private static final AtomicInteger QUERY_COUNTER = new AtomicInteger();
    private static final Map<String, QueryResponse> ACTIVES_QUERIES = new ConcurrentHashMap<String, QueryResponse>();

    public String executeAndWait(BrowserScriptable browser, String jsCall, long maximumMsWait) throws InterruptedException {
        CountDownLatch latch = new CountDownLatch(1);
        AtomicReference syncAction = new AtomicReference();
        this.execute(browser, jsCall, response -> {
            syncAction.set(() -> response);
            latch.countDown();
        }, error -> {
            syncAction.set(() -> {
                throw new IllegalStateException("JS Query has thrown an error: " + error);
            });
            latch.countDown();
        });
        latch.await(maximumMsWait, TimeUnit.MILLISECONDS);
        Supplier resultSupplier = (Supplier)syncAction.get();
        return (String)resultSupplier.get();
    }

    public void execute(BrowserScriptable browser, String jsCall, Consumer<String> successHandler, Consumer<String> errorHandler) {
        String queryId = Integer.toString(QUERY_COUNTER.incrementAndGet());
        QueryResponse handle = new QueryResponse(queryId, (type, response) -> {
            switch (type) {
                case SUCCESS: {
                    successHandler.accept((String)response);
                    return;
                }
                case ERROR: {
                    errorHandler.accept((String)response);
                    return;
                }
            }
            throw new IllegalStateException("Unknown query response type");
        });
        if (ACTIVES_QUERIES.containsKey(queryId)) {
            throw new IllegalStateException("Duplicate response handle: " + queryId);
        }
        ACTIVES_QUERIES.put(queryId, handle);
        String call = String.format(QUERY_TEMPLATE, queryId, StringEscapeUtils.escapeEcmaScript((String)jsCall));
        browser.execJS(call);
    }

    @Override
    public boolean canHandle(String request) {
        return request != null && request.startsWith(QUERY_IDENTIFIER);
    }

    @Override
    public boolean handle(BrowserQueryable browser, String request, QueryListener.ResponseCallback callback) {
        String[] parameters = request.split(",", 4);
        if (parameters.length != 4) {
            throw new IllegalStateException("query response is malformed");
        }
        String handle = parameters[1];
        String type = parameters[2];
        String response = parameters[3];
        QueryResponse javaScriptResponse = ACTIVES_QUERIES.remove(handle);
        if (javaScriptResponse == null) {
            String errorMessage = "response id '" + handle + "' is unknown";
            callback.failure(1, errorMessage);
            throw new IllegalStateException(errorMessage);
        }
        QueryResponse.Type mappedType = QueryResponse.Type.valueOf(type);
        javaScriptResponse.invoke(mappedType, response);
        callback.success("OK");
        return true;
    }
}

