/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.transform;

import java.io.IOException;
import java.util.logging.Logger;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.data.transform.Transformer;
import org.geotools.feature.FeatureIterator;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.util.logging.Logging;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.filter.expression.Expression;

class TransformFeatureIteratorWrapper
implements SimpleFeatureIterator {
    static final Logger LOGGER = Logging.getLogger(TransformFeatureIteratorWrapper.class);
    private SimpleFeatureBuilder fb;
    private FeatureIterator<SimpleFeature> wrapped;
    private Transformer transformer;
    private SimpleFeatureType target;

    public TransformFeatureIteratorWrapper(FeatureIterator<SimpleFeature> wrapped, Transformer transformer) throws IOException {
        this.transformer = transformer;
        this.target = transformer.getSchema();
        this.wrapped = wrapped;
        this.fb = new SimpleFeatureBuilder(this.target);
    }

    @Override
    public boolean hasNext() {
        return this.wrapped.hasNext();
    }

    @Override
    public SimpleFeature next() {
        SimpleFeature f = this.wrapped.next();
        for (AttributeDescriptor ad : this.target.getAttributeDescriptors()) {
            Expression ex = this.transformer.getExpression(ad.getLocalName());
            if (ex != null) {
                Object value = ex.evaluate((Object)f, ad.getType().getBinding());
                this.fb.add(value);
                continue;
            }
            this.fb.add(null);
        }
        this.fb.featureUserData(f);
        return this.fb.buildFeature(this.transformer.transformFid(f));
    }

    @Override
    public void close() {
        if (this.wrapped != null) {
            this.wrapped.close();
        }
        this.wrapped = null;
    }
}

