/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.util.rendering.index;

import de.riwagis.util.rendering.index.AbstractNode;
import de.riwagis.util.rendering.index.AbstractRectSTRtree;
import de.riwagis.util.rendering.index.Boundable;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.locationtech.jts.util.Assert;

public class RectSTRtree
extends AbstractRectSTRtree {
    private Comparator<Boundable> xComparator = new Comparator<Boundable>(){

        @Override
        public int compare(Boundable o1, Boundable o2) {
            return RectSTRtree.this.compareDoubles(RectSTRtree.this.centreX((Rectangle2D)o1.getBounds()), RectSTRtree.this.centreX((Rectangle2D)o2.getBounds()));
        }
    };
    private Comparator<Boundable> yComparator = new Comparator<Boundable>(){

        @Override
        public int compare(Boundable o1, Boundable o2) {
            return RectSTRtree.this.compareDoubles(RectSTRtree.this.centreY((Rectangle2D)o1.getBounds()), RectSTRtree.this.centreY((Rectangle2D)o2.getBounds()));
        }
    };
    private AbstractRectSTRtree.IntersectsOp intersectsOp = new AbstractRectSTRtree.IntersectsOp(){

        @Override
        public boolean intersects(Object aBounds, Object bBounds) {
            return ((Rectangle2D)aBounds).intersects((Rectangle2D)bBounds);
        }
    };

    public static final List<Boundable>[] buildSliceListArray(int sliceCount) {
        return new List[sliceCount];
    }

    private double centreX(Rectangle2D e) {
        return this.avg(e.getMinX(), e.getMaxX());
    }

    private double avg(double a, double b) {
        return (a + b) / 2.0;
    }

    private double centreY(Rectangle2D e) {
        return this.avg(e.getMinY(), e.getMaxY());
    }

    @Override
    protected List<Boundable> createParentBoundables(List<Boundable> childBoundables, int newLevel) {
        Assert.isTrue((!childBoundables.isEmpty() ? 1 : 0) != 0);
        int minLeafCount = (int)Math.ceil((double)childBoundables.size() / (double)this.getNodeCapacity());
        ArrayList<Boundable> sortedChildBoundables = new ArrayList<Boundable>(childBoundables);
        Collections.sort(sortedChildBoundables, this.xComparator);
        List<Boundable>[] verticalSlices = this.verticalSlices(sortedChildBoundables, (int)Math.ceil(Math.sqrt(minLeafCount)));
        return this.createParentBoundablesFromVerticalSlices(verticalSlices, newLevel);
    }

    private List<Boundable> createParentBoundablesFromVerticalSlices(List<Boundable>[] verticalSlices, int newLevel) {
        Assert.isTrue((verticalSlices.length > 0 ? 1 : 0) != 0);
        ArrayList<Boundable> parentBoundables = new ArrayList<Boundable>();
        for (int i = 0; i < verticalSlices.length; ++i) {
            parentBoundables.addAll(this.createParentBoundablesFromVerticalSlice(verticalSlices[i], newLevel));
        }
        return parentBoundables;
    }

    protected List<Boundable> createParentBoundablesFromVerticalSlice(List<Boundable> childBoundables, int newLevel) {
        return super.createParentBoundables(childBoundables, newLevel);
    }

    protected List<Boundable>[] verticalSlices(List<Boundable> childBoundables, int sliceCount) {
        int sliceCapacity = (int)Math.ceil((double)childBoundables.size() / (double)sliceCount);
        List<Boundable>[] slices = RectSTRtree.buildSliceListArray(sliceCount);
        Iterator<Boundable> i = childBoundables.iterator();
        for (int j = 0; j < sliceCount; ++j) {
            slices[j] = new ArrayList<Boundable>();
            for (int boundablesAddedToSlice = 0; i.hasNext() && boundablesAddedToSlice < sliceCapacity; ++boundablesAddedToSlice) {
                Boundable childBoundable = i.next();
                slices[j].add(childBoundable);
            }
        }
        return slices;
    }

    public RectSTRtree() {
        this(10);
    }

    public RectSTRtree(int nodeCapacity) {
        super(nodeCapacity);
    }

    @Override
    protected AbstractNode createNode(int level) {
        return new AbstractNode(level){

            @Override
            protected Object computeBounds() {
                Rectangle2D bounds = null;
                for (Boundable childBoundable : this.getChildBoundables()) {
                    if (bounds == null) {
                        bounds = ((Rectangle2D)childBoundable.getBounds()).getBounds2D();
                        continue;
                    }
                    bounds.add((Rectangle2D)childBoundable.getBounds());
                }
                return bounds;
            }
        };
    }

    @Override
    protected AbstractRectSTRtree.IntersectsOp getIntersectsOp() {
        return this.intersectsOp;
    }

    public void insert(Rectangle2D itemEnv, Object item) {
        if (Double.isNaN(itemEnv.getWidth()) || Double.isNaN(itemEnv.getHeight())) {
            Assert.shouldNeverReachHere((String)"invalid number in RectSTRtree rectangle");
        }
        super.insert(itemEnv, item);
    }

    public List<Object> query(Rectangle2D searchEnv) {
        return super.query(searchEnv);
    }

    public boolean remove(Rectangle2D itemEnv, Object item) {
        return super.remove(itemEnv, item);
    }

    @Override
    public int size() {
        return super.size();
    }

    @Override
    public int depth() {
        return super.depth();
    }

    @Override
    protected Comparator<Boundable> getComparator() {
        return this.yComparator;
    }
}

