/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.util.rendering.index;

import de.riwagis.util.rendering.index.AbstractNode;
import de.riwagis.util.rendering.index.Boundable;
import de.riwagis.util.rendering.index.ItemBoundable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.locationtech.jts.util.Assert;

public abstract class AbstractRectSTRtree {
    private AbstractNode root;
    private boolean built = false;
    private final List<Boundable> itemBoundables = new ArrayList<Boundable>();
    private final int nodeCapacity;

    public AbstractRectSTRtree(int nodeCapacity) {
        Assert.isTrue((nodeCapacity > 1 ? 1 : 0) != 0, (String)"Node capacity must be greater than 1");
        this.nodeCapacity = nodeCapacity;
    }

    public void build() {
        Assert.isTrue((!this.built ? 1 : 0) != 0);
        this.root = this.itemBoundables.isEmpty() ? this.createNode(0) : this.createHigherLevels(this.itemBoundables, -1);
        this.built = true;
    }

    protected abstract AbstractNode createNode(int var1);

    protected List<Boundable> createParentBoundables(List<Boundable> childBoundables, int newLevel) {
        Assert.isTrue((!childBoundables.isEmpty() ? 1 : 0) != 0);
        ArrayList<Boundable> parentBoundables = new ArrayList<Boundable>();
        parentBoundables.add(this.createNode(newLevel));
        ArrayList<Boundable> sortedChildBoundables = new ArrayList<Boundable>(childBoundables);
        Collections.sort(sortedChildBoundables, this.getComparator());
        for (Boundable childBoundable : sortedChildBoundables) {
            if (this.lastNode(parentBoundables).getChildBoundables().size() == this.getNodeCapacity()) {
                parentBoundables.add(this.createNode(newLevel));
            }
            this.lastNode(parentBoundables).addChildBoundable(childBoundable);
        }
        return parentBoundables;
    }

    protected AbstractNode lastNode(List<Boundable> nodes) {
        return (AbstractNode)nodes.get(nodes.size() - 1);
    }

    protected int compareDoubles(double a, double b) {
        return a > b ? 1 : (a < b ? -1 : 0);
    }

    private AbstractNode createHigherLevels(List<Boundable> boundablesOfALevel, int level) {
        Assert.isTrue((!boundablesOfALevel.isEmpty() ? 1 : 0) != 0);
        List<Boundable> parentBoundables = this.createParentBoundables(boundablesOfALevel, level + 1);
        if (parentBoundables.size() == 1) {
            return (AbstractNode)parentBoundables.get(0);
        }
        return this.createHigherLevels(parentBoundables, level + 1);
    }

    protected AbstractNode getRoot() {
        return this.root;
    }

    public int getNodeCapacity() {
        return this.nodeCapacity;
    }

    protected int size() {
        if (!this.built) {
            this.build();
        }
        if (this.itemBoundables.isEmpty()) {
            return 0;
        }
        return this.size(this.root);
    }

    protected int size(AbstractNode node) {
        int size = 0;
        for (Boundable childBoundable : node.getChildBoundables()) {
            if (childBoundable instanceof AbstractNode) {
                size += this.size((AbstractNode)childBoundable);
                continue;
            }
            if (!(childBoundable instanceof ItemBoundable)) continue;
            ++size;
        }
        return size;
    }

    protected int depth() {
        if (!this.built) {
            this.build();
        }
        if (this.itemBoundables.isEmpty()) {
            return 0;
        }
        return this.depth(this.root);
    }

    protected int depth(AbstractNode node) {
        int maxChildDepth = 0;
        for (Boundable childBoundable : node.getChildBoundables()) {
            int childDepth;
            if (!(childBoundable instanceof AbstractNode) || (childDepth = this.depth((AbstractNode)childBoundable)) <= maxChildDepth) continue;
            maxChildDepth = childDepth;
        }
        return maxChildDepth + 1;
    }

    protected void insert(Object bounds, Object item) {
        Assert.isTrue((!this.built ? 1 : 0) != 0, (String)"Cannot insert items into an STR packed R-tree after it has been built.");
        this.itemBoundables.add(new ItemBoundable(bounds, item));
    }

    protected List<Object> query(Object searchBounds) {
        if (!this.built) {
            this.build();
        }
        ArrayList<Object> matches = new ArrayList<Object>();
        if (this.itemBoundables.isEmpty()) {
            Assert.isTrue((this.root.getBounds() == null ? 1 : 0) != 0);
            return matches;
        }
        if (this.getIntersectsOp().intersects(this.root.getBounds(), searchBounds)) {
            this.query(searchBounds, this.root, matches);
        }
        return matches;
    }

    protected abstract IntersectsOp getIntersectsOp();

    private void query(Object searchBounds, AbstractNode node, Collection<Object> matches) {
        for (Boundable childBoundable : node.getChildBoundables()) {
            if (!this.getIntersectsOp().intersects(childBoundable.getBounds(), searchBounds)) continue;
            if (childBoundable instanceof AbstractNode) {
                this.query(searchBounds, (AbstractNode)childBoundable, matches);
                continue;
            }
            if (childBoundable instanceof ItemBoundable) {
                matches.add(((ItemBoundable)childBoundable).getItem());
                continue;
            }
            Assert.shouldNeverReachHere();
        }
    }

    protected boolean remove(Object searchBounds, Object item) {
        if (!this.built) {
            this.build();
        }
        if (this.itemBoundables.isEmpty()) {
            Assert.isTrue((this.root.getBounds() == null ? 1 : 0) != 0);
        }
        if (this.getIntersectsOp().intersects(this.root.getBounds(), searchBounds)) {
            return this.remove(searchBounds, this.root, item);
        }
        return false;
    }

    private boolean removeItem(AbstractNode node, Object item) {
        Boundable childToRemove = null;
        for (Boundable childBoundable : node.getChildBoundables()) {
            if (!(childBoundable instanceof ItemBoundable) || ((ItemBoundable)childBoundable).getItem() != item) continue;
            childToRemove = childBoundable;
        }
        if (childToRemove != null) {
            node.getChildBoundables().remove(childToRemove);
            return true;
        }
        return false;
    }

    private boolean remove(Object searchBounds, AbstractNode node, Object item) {
        boolean found = this.removeItem(node, item);
        if (found) {
            return true;
        }
        AbstractNode childToPrune = null;
        for (Boundable childBoundable : node.getChildBoundables()) {
            if (!this.getIntersectsOp().intersects(childBoundable.getBounds(), searchBounds) || !(childBoundable instanceof AbstractNode) || !(found = this.remove(searchBounds, (AbstractNode)childBoundable, item))) continue;
            childToPrune = (AbstractNode)childBoundable;
            break;
        }
        if (childToPrune != null && childToPrune.getChildBoundables().isEmpty()) {
            node.getChildBoundables().remove(childToPrune);
        }
        return found;
    }

    protected List<Boundable> boundablesAtLevel(int level) {
        ArrayList<Boundable> boundables = new ArrayList<Boundable>();
        this.boundablesAtLevel(level, this.root, boundables);
        return boundables;
    }

    private void boundablesAtLevel(int level, AbstractNode top, Collection<Boundable> boundables) {
        Assert.isTrue((level > -2 ? 1 : 0) != 0);
        if (top.getLevel() == level) {
            boundables.add(top);
            return;
        }
        for (Boundable boundable : top.getChildBoundables()) {
            if (boundable instanceof AbstractNode) {
                this.boundablesAtLevel(level, (AbstractNode)boundable, boundables);
                continue;
            }
            Assert.isTrue((boolean)(boundable instanceof ItemBoundable));
            if (level != -1) continue;
            boundables.add(boundable);
        }
    }

    protected abstract Comparator<Boundable> getComparator();

    protected static interface IntersectsOp {
        public boolean intersects(Object var1, Object var2);
    }
}

