/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.util.jts;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateXY;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.operation.linemerge.LineMerger;
import org.locationtech.jts.util.Assert;

public class JTSSupport {
    private static final GeometryFactory GEOMFACTORY = new GeometryFactory();

    public static LineString[] buildLineStringArray(Collection<?> c) {
        return c.toArray(new LineString[c.size()]);
    }

    public static Geometry createEmptyGeom(Class<?> geomClass) {
        Class innerGeomClass;
        Class clazz = innerGeomClass = geomClass == null ? Geometry.class : geomClass;
        if (innerGeomClass.equals(Point.class)) {
            return GEOMFACTORY.createPoint((Coordinate)null);
        }
        if (innerGeomClass.equals(MultiPoint.class)) {
            return GEOMFACTORY.createMultiPoint((Point[])null);
        }
        if (innerGeomClass.equals(LineString.class)) {
            return GEOMFACTORY.createLineString((Coordinate[])null);
        }
        if (innerGeomClass.equals(MultiLineString.class)) {
            return GEOMFACTORY.createMultiLineString((LineString[])null);
        }
        if (innerGeomClass.equals(Polygon.class)) {
            return GEOMFACTORY.createPolygon((LinearRing)null, (LinearRing[])null);
        }
        if (innerGeomClass.equals(MultiPolygon.class)) {
            return GEOMFACTORY.createMultiPolygon((Polygon[])null);
        }
        if (innerGeomClass.equals(GeometryCollection.class)) {
            return GEOMFACTORY.createGeometryCollection((Geometry[])null);
        }
        return GEOMFACTORY.createPoint((Coordinate)null);
    }

    public static void to2D(Geometry geom) {
        for (Coordinate coord : geom.getCoordinates()) {
            JTSSupport.to2D(coord);
        }
    }

    public static void to3D(Geometry geom) {
        for (Coordinate coord : geom.getCoordinates()) {
            JTSSupport.to3D(coord);
        }
    }

    public static void to3D(Coordinate coord) {
        if (!(coord instanceof CoordinateXY) && Double.isNaN(coord.getZ())) {
            coord.setZ(0.0);
        }
    }

    public static void to2D(Coordinate coord) {
        if (!(coord instanceof CoordinateXY)) {
            coord.setZ(Double.NaN);
        }
    }

    public static Geometry extractLines(Geometry geom, boolean bolExtractHolesInPolygons) {
        if (geom instanceof MultiLineString || geom instanceof LineString) {
            return geom;
        }
        if (geom instanceof Point || geom instanceof MultiPoint) {
            return null;
        }
        if (geom instanceof Polygon) {
            Polygon p = (Polygon)geom;
            LineString extRing = p.getFactory().createLineString(p.getExteriorRing().getCoordinates());
            if (bolExtractHolesInPolygons) {
                int intRingCount = p.getNumInteriorRing();
                if (intRingCount == 0) {
                    return extRing;
                }
                ArrayList<LineString> lstLines = new ArrayList<LineString>();
                lstLines.add(extRing);
                for (int i = 0; i < intRingCount; ++i) {
                    lstLines.add(p.getFactory().createLineString(p.getInteriorRingN(i).getCoordinates()));
                }
                LineString[] arrLines = lstLines.toArray(new LineString[lstLines.size()]);
                return geom.getFactory().createMultiLineString(arrLines);
            }
            return extRing;
        }
        if (geom instanceof GeometryCollection) {
            GeometryCollection gcol = (GeometryCollection)geom;
            int intGeomCount = gcol.getNumGeometries();
            ArrayList<LineString> lstLines = new ArrayList<LineString>();
            for (int i = 0; i < intGeomCount; ++i) {
                Geometry g = gcol.getGeometryN(i);
                if ((g = JTSSupport.extractLines(g, bolExtractHolesInPolygons)) == null) continue;
                if (g instanceof LineString) {
                    lstLines.add((LineString)g);
                    continue;
                }
                MultiLineString ml = (MultiLineString)g;
                for (int j = 0; j < ml.getNumGeometries(); ++j) {
                    lstLines.add((LineString)ml.getGeometryN(j));
                }
            }
            if (lstLines.isEmpty()) {
                return null;
            }
            if (lstLines.size() == 1) {
                return (Geometry)lstLines.get(0);
            }
            LineString[] arrLines = lstLines.toArray(new LineString[lstLines.size()]);
            return geom.getFactory().createMultiLineString(arrLines);
        }
        Assert.shouldNeverReachHere();
        return null;
    }

    public static Geometry extractPolygons(Geometry geom) {
        if (geom instanceof Polygon || geom instanceof MultiPolygon) {
            return geom;
        }
        if (geom instanceof GeometryCollection) {
            ArrayList<Polygon> internalGeoms = new ArrayList<Polygon>();
            for (int i = 0; i < geom.getNumGeometries(); ++i) {
                Geometry geomInternal = geom.getGeometryN(i);
                if (geomInternal instanceof Polygon) {
                    internalGeoms.add((Polygon)geomInternal);
                    continue;
                }
                if (!(geomInternal instanceof MultiPolygon)) continue;
                for (int pi = 0; pi < geomInternal.getNumGeometries(); ++pi) {
                    internalGeoms.add((Polygon)geomInternal.getGeometryN(pi));
                }
            }
            if (internalGeoms.size() == 1) {
                return (Geometry)internalGeoms.get(0);
            }
            if (internalGeoms.size() > 1) {
                return geom.getFactory().createMultiPolygon(internalGeoms.toArray(new Polygon[internalGeoms.size()]));
            }
            return null;
        }
        return null;
    }

    public static Geometry mergeGeom(Geometry[] arrGeom) {
        if (arrGeom.length == 0) {
            return null;
        }
        Geometry newGeom = arrGeom[0];
        for (Geometry currentGeometry : arrGeom) {
            newGeom = JTSSupport.mergeGeom(newGeom, currentGeometry);
        }
        return newGeom;
    }

    public static boolean contains(Geometry exterior, Geometry interior) {
        Geometry[] arrGI;
        Geometry[] arrGE = JTSSupport.getGeometries(exterior);
        for (Geometry gi : arrGI = JTSSupport.getGeometries(interior)) {
            boolean bolContains = false;
            for (Geometry ge : arrGE) {
                if (!ge.contains(gi)) continue;
                bolContains = true;
                break;
            }
            if (bolContains) continue;
            return false;
        }
        return true;
    }

    public static boolean intersects(Geometry g1, Geometry g2) {
        Geometry[] arrG2;
        Geometry[] arrG1 = JTSSupport.getGeometries(g1);
        for (Geometry gi : arrG2 = JTSSupport.getGeometries(g2)) {
            for (Geometry ge : arrG1) {
                if (!ge.intersects(gi)) continue;
                return true;
            }
        }
        return false;
    }

    public static Geometry mergeGeom(Geometry geom1, Geometry geom2) {
        Geometry newGeom = null;
        if (geom1 == null || geom1.isEmpty()) {
            return geom2;
        }
        if (geom2 == null || geom2.isEmpty()) {
            return geom1;
        }
        if (JTSSupport.contains(geom1, geom2)) {
            Geometry[] arrGeom1 = JTSSupport.getGeometries(geom1);
            Geometry[] arrGeom2 = JTSSupport.getGeometries(geom2);
            ArrayList<Geometry> lstNewGeoms = new ArrayList<Geometry>();
            Geometry[] geometryArray = arrGeom1;
            int n = geometryArray.length;
            for (int i = 0; i < n; ++i) {
                Geometry g1;
                newGeom = g1 = geometryArray[i];
                for (Geometry g2 : arrGeom2) {
                    if (!(g2 instanceof Polygon) || !g1.contains(g2) || g1.equalsTopo(g2)) continue;
                    newGeom = newGeom.difference(g2);
                }
                lstNewGeoms.add(newGeom);
            }
            for (Geometry g2 : arrGeom2) {
                if (g2 instanceof Polygon) continue;
                lstNewGeoms.add(g2);
            }
            return geom1.getFactory().buildGeometry(lstNewGeoms);
        }
        if (JTSSupport.intersects(geom1, geom2)) {
            Geometry[] arrGeom1 = JTSSupport.getGeometries(geom1);
            Geometry[] arrGeom2 = JTSSupport.getGeometries(geom2);
            ArrayList<Geometry> lstOtherGeom = new ArrayList<Geometry>();
            ArrayList<Polygon> lstPolygons = new ArrayList<Polygon>();
            ArrayList<LineString> lstLineStrings = new ArrayList<LineString>();
            for (Geometry g1 : arrGeom1) {
                if (g1.isValid() && g1 instanceof Polygon) {
                    lstPolygons.add((Polygon)g1);
                    continue;
                }
                if (g1.isValid() && g1 instanceof LineString) {
                    lstLineStrings.add((LineString)g1);
                    continue;
                }
                lstOtherGeom.add(g1);
            }
            for (Geometry g2 : arrGeom2) {
                if (g2.isValid() && g2 instanceof Polygon) {
                    lstPolygons.add((Polygon)g2);
                    continue;
                }
                if (g2.isValid() && g2 instanceof LineString) {
                    lstLineStrings.add((LineString)g2);
                    continue;
                }
                lstOtherGeom.add(g2);
            }
            GeometryCollection geomPoly = geom1.getFactory().createGeometryCollection(lstPolygons.toArray(new Geometry[lstPolygons.size()]));
            geomPoly = geomPoly.union();
            Geometry[] arrGeomPoly = JTSSupport.getGeometries((Geometry)geomPoly);
            lstOtherGeom.addAll(Arrays.asList(arrGeomPoly));
            LineMerger lm = new LineMerger();
            lm.add(lstLineStrings);
            lstOtherGeom.addAll(lm.getMergedLineStrings());
            Geometry mergedGeom = geom1.getFactory().buildGeometry(lstOtherGeom);
            return mergedGeom;
        }
        if ((geom1 instanceof Polygon || geom1 instanceof MultiPolygon) && (geom2 instanceof Polygon || geom2 instanceof MultiPolygon)) {
            Polygon[] arrPoly = (Polygon[])JTSSupport.getGeometries(geom1, geom2, Polygon.class);
            newGeom = geom1.getFactory().createGeometryCollection((Geometry[])arrPoly).buffer(0.0);
            return newGeom;
        }
        if ((geom1 instanceof LineString || geom1 instanceof MultiLineString) && (geom2 instanceof LineString || geom2 instanceof MultiLineString)) {
            LineString[] arrLine = (LineString[])JTSSupport.getGeometries(geom1, geom2, LineString.class);
            LineMerger lm = new LineMerger();
            for (int i = 0; i < arrLine.length; ++i) {
                lm.add((Geometry)arrLine[i]);
            }
            arrLine = JTSSupport.buildLineStringArray(lm.getMergedLineStrings());
            if (arrLine.length > 1) {
                newGeom = geom1.getFactory().createMultiLineString(arrLine);
            } else {
                if (arrLine.length == 1) {
                    return arrLine[0];
                }
                Assert.shouldNeverReachHere((String)"Error noding linestrings.");
            }
            return newGeom;
        }
        if ((geom1 instanceof Point || geom1 instanceof MultiPoint) && (geom2 instanceof Point || geom2 instanceof MultiPoint)) {
            Point[] arrPoint = (Point[])JTSSupport.getGeometries(geom1, geom2, Point.class);
            newGeom = geom1.getFactory().createMultiPoint(arrPoint);
            return newGeom;
        }
        newGeom = geom1.getFactory().createGeometryCollection(JTSSupport.getGeometries(geom1, geom2, Geometry.class));
        return newGeom;
    }

    public static Geometry[] getGeometries(Geometry geom) {
        if (geom instanceof GeometryCollection) {
            GeometryCollection gcol = (GeometryCollection)geom;
            ArrayList<Geometry> lstGeom = new ArrayList<Geometry>();
            for (int i = 0; i < gcol.getNumGeometries(); ++i) {
                Geometry tmpGeom = gcol.getGeometryN(i);
                Geometry[] arrGeom = JTSSupport.getGeometries(tmpGeom);
                lstGeom.addAll(Arrays.asList(arrGeom));
            }
            return lstGeom.toArray(new Geometry[lstGeom.size()]);
        }
        return new Geometry[]{geom};
    }

    private static Geometry[] getGeometries(Geometry geom1, Geometry geom2, Class<?> clazz) {
        int i;
        ArrayList<Geometry> lstGeom = new ArrayList<Geometry>();
        if (geom1 != null) {
            if (geom1 instanceof GeometryCollection) {
                for (i = 0; i < geom1.getNumGeometries(); ++i) {
                    lstGeom.add(geom1.getGeometryN(i));
                }
            } else {
                lstGeom.add(geom1);
            }
        }
        if (geom2 != null) {
            if (geom2 instanceof GeometryCollection) {
                for (i = 0; i < geom2.getNumGeometries(); ++i) {
                    lstGeom.add(geom2.getGeometryN(i));
                }
            } else {
                lstGeom.add(geom2);
            }
        }
        if (clazz.equals(Point.class)) {
            return (Geometry[])lstGeom.toArray(new Point[lstGeom.size()]);
        }
        if (clazz.equals(LineString.class)) {
            return (Geometry[])lstGeom.toArray(new LineString[lstGeom.size()]);
        }
        if (clazz.equals(Polygon.class)) {
            return (Geometry[])lstGeom.toArray(new Polygon[lstGeom.size()]);
        }
        if (clazz.equals(Geometry.class)) {
            return lstGeom.toArray(new Geometry[lstGeom.size()]);
        }
        Assert.shouldNeverReachHere();
        return null;
    }

    public static List<Geometry> splitGeometryCollections(Geometry geom) {
        ArrayList<Geometry> lstGeom = new ArrayList<Geometry>();
        if (geom.getClass().equals(GeometryCollection.class)) {
            Geometry[] arrGeom = JTSSupport.getGeometries(geom);
            ArrayList<Point> lstPoint = new ArrayList<Point>();
            ArrayList<LineString> lstLine = new ArrayList<LineString>();
            ArrayList<Polygon> lstPolygon = new ArrayList<Polygon>();
            for (Geometry g : arrGeom) {
                if (g instanceof Point) {
                    lstPoint.add((Point)g);
                }
                if (g instanceof LineString) {
                    lstLine.add((LineString)g);
                }
                if (!(g instanceof Polygon)) continue;
                lstPolygon.add((Polygon)g);
            }
            if (!lstPoint.isEmpty()) {
                if (lstPoint.size() == 1) {
                    lstGeom.addAll(lstPoint);
                } else {
                    lstGeom.add((Geometry)geom.getFactory().createMultiPoint(lstPoint.toArray(new Point[lstPoint.size()])));
                }
            }
            if (!lstLine.isEmpty()) {
                if (lstLine.size() == 1) {
                    lstGeom.addAll(lstLine);
                } else {
                    lstGeom.add((Geometry)geom.getFactory().createMultiLineString(lstLine.toArray(new LineString[lstLine.size()])));
                }
            }
            if (!lstPolygon.isEmpty()) {
                if (lstPolygon.size() == 1) {
                    lstGeom.addAll(lstPolygon);
                } else {
                    lstGeom.add((Geometry)geom.getFactory().createMultiPolygon(lstPolygon.toArray(new Polygon[lstPolygon.size()])));
                }
            }
        } else {
            lstGeom.add(geom);
        }
        return lstGeom;
    }

    public static Coordinate[] removeDuplicates(Coordinate[] arrCoord) {
        LinkedHashSet<Coordinate> set = new LinkedHashSet<Coordinate>();
        for (Coordinate coord : arrCoord) {
            if (set.contains(coord)) continue;
            set.add(coord);
        }
        return set.toArray(new Coordinate[set.size()]);
    }
}

