/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.util.jts;

import java.util.ArrayList;
import java.util.Collection;
import org.locationtech.jts.algorithm.Orientation;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.util.Assert;

public class CoordinateArraySupport {
    public static Coordinate[] toCoordinateArray(Collection<Coordinate> coordList) {
        return coordList.toArray(new Coordinate[coordList.size()]);
    }

    public static void reverse(Coordinate[] coord) {
        int last = coord.length - 1;
        int mid = last / 2;
        for (int i = 0; i <= mid; ++i) {
            Coordinate tmp = coord[i];
            coord[i] = coord[last - i];
            coord[last - i] = tmp;
        }
    }

    public static Geometry toLineOrPoint(Coordinate[] coords, GeometryFactory fact) {
        if (coords.length > 1) {
            return fact.createLineString(coords);
        }
        if (coords.length == 1) {
            return fact.createPoint(coords[0]);
        }
        return fact.createPoint((Coordinate)null);
    }

    public static boolean equals(Coordinate[] coord1, Coordinate[] coord2) {
        if (coord1 == coord2) {
            return true;
        }
        if (coord1 == null || coord2 == null) {
            return false;
        }
        if (coord1.length != coord2.length) {
            return false;
        }
        for (int i = 0; i < coord1.length; ++i) {
            if (coord1[i].equals((Object)coord2[i])) continue;
            return false;
        }
        return true;
    }

    public static Collection<Geometry> fromCoordinateArrays(Collection<Coordinate[]> coordArrays, GeometryFactory fact) {
        ArrayList<Geometry> geomList = new ArrayList<Geometry>();
        for (Coordinate[] coords : coordArrays) {
            Geometry geom = CoordinateArraySupport.toLineOrPoint(coords, fact);
            geomList.add(geom);
        }
        return geomList;
    }

    public static void addCoordinateArrays(Geometry g, boolean orientPolygons, Collection<Coordinate[]> coordArrayList) {
        if (g.getDimension() > 0) {
            if (g instanceof LineString) {
                coordArrayList.add(g.getCoordinates());
            } else if (g instanceof Polygon) {
                Polygon poly = (Polygon)g;
                Coordinate[] shell = poly.getExteriorRing().getCoordinates();
                if (orientPolygons) {
                    shell = CoordinateArraySupport.ensureOrientation(shell, -1);
                }
                coordArrayList.add(shell);
                for (int i = 0; i < poly.getNumInteriorRing(); ++i) {
                    Coordinate[] hole = poly.getInteriorRingN(i).getCoordinates();
                    if (orientPolygons) {
                        hole = CoordinateArraySupport.ensureOrientation(hole, 1);
                    }
                    coordArrayList.add(hole);
                }
            } else if (g instanceof GeometryCollection) {
                GeometryCollection gc = (GeometryCollection)g;
                for (int i = 0; i < gc.getNumGeometries(); ++i) {
                    CoordinateArraySupport.addCoordinateArrays(gc.getGeometryN(i), orientPolygons, coordArrayList);
                }
            } else {
                Assert.shouldNeverReachHere((String)String.format("Geometry of type %s not handled", g.getClass().getName()));
            }
        }
    }

    public static Coordinate[] ensureOrientation(Coordinate[] coord, int desiredOrientation) {
        int orientation;
        if (coord.length == 0) {
            return coord;
        }
        int n = orientation = Orientation.isCCW((Coordinate[])coord) ? 1 : -1;
        if (orientation != desiredOrientation) {
            Coordinate[] reverse = (Coordinate[])coord.clone();
            CoordinateArraySupport.reverse(reverse);
            return reverse;
        }
        return coord;
    }

    public static Collection<Coordinate[]> toCoordinateArrays(Geometry g, boolean orientPolygons) {
        ArrayList<Coordinate[]> coordArrayList = new ArrayList<Coordinate[]>();
        CoordinateArraySupport.addCoordinateArrays(g, orientPolygons, coordArrayList);
        return coordArrayList;
    }

    private CoordinateArraySupport() {
    }
}

