/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.util.construction;

import de.riwagis.util.construction.ConstSupport;
import java.util.ArrayList;
import java.util.List;
import org.locationtech.jts.algorithm.Orientation;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateArrays;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.geom.impl.CoordinateArraySequence;

public class MoveParallelSupport {
    private static void checkType(Geometry geom) throws IllegalArgumentException {
        if (!(geom instanceof LineString || geom instanceof Polygon || geom instanceof MultiLineString || geom instanceof MultiPolygon)) {
            throw new IllegalArgumentException("Geometry has invalid type. Only LineString,MultiLineString,Polygon,MultiPolygon are allowed.");
        }
    }

    private static LineString moveParallel(LineString line, double distance, boolean bolMoveRight) {
        Coordinate[] arrCoord = MoveParallelSupport.moveParallel(line.getCoordinateSequence(), distance, bolMoveRight, false);
        return line.getFactory().createLineString(arrCoord);
    }

    private static Polygon moveParallel(Polygon p, double distance, boolean bolMoveRight) {
        Polygon geomNew;
        Coordinate[] arrCoordExtRing = p.getExteriorRing().getCoordinates();
        boolean bolCCW = Orientation.isCCW((Coordinate[])arrCoordExtRing);
        arrCoordExtRing = MoveParallelSupport.moveParallel((CoordinateSequence)new CoordinateArraySequence(arrCoordExtRing), distance, bolMoveRight, true);
        ArrayList<LinearRing> lstIntRing = new ArrayList<LinearRing>();
        for (int i = 0; i < p.getNumInteriorRing(); ++i) {
            try {
                Coordinate[] arrCoordIntRing = p.getInteriorRingN(i).getCoordinates();
                boolean bolCCWInt = Orientation.isCCW((Coordinate[])arrCoordIntRing);
                if (bolCCW != bolCCWInt) {
                    CoordinateArrays.reverse((Coordinate[])arrCoordIntRing);
                }
                arrCoordIntRing = MoveParallelSupport.moveParallel((CoordinateSequence)new CoordinateArraySequence(arrCoordIntRing), distance, bolMoveRight, true);
                lstIntRing.add(p.getFactory().createLinearRing(arrCoordIntRing));
                continue;
            }
            catch (IllegalArgumentException e) {
                continue;
            }
            catch (ArithmeticException e) {
                // empty catch block
            }
        }
        try {
            geomNew = p.getFactory().createPolygon(p.getFactory().createLinearRing(arrCoordExtRing), lstIntRing.toArray(new LinearRing[0]));
            if (!geomNew.isValid()) {
                throw new IllegalArgumentException();
            }
        }
        catch (IllegalArgumentException e) {
            try {
                geomNew = p.getFactory().createPolygon(p.getFactory().createLinearRing(arrCoordExtRing), null);
                if (!geomNew.isValid()) {
                    throw new IllegalArgumentException();
                }
            }
            catch (IllegalArgumentException e1) {
                return null;
            }
        }
        return geomNew;
    }

    public static Geometry moveParallel(Geometry geom, double distance, Coordinate coord4Distance) throws IllegalArgumentException {
        MoveParallelSupport.checkType(geom);
        LineString geomNew = null;
        boolean bolMoveRight = MoveParallelSupport.moveRight(geom, distance, coord4Distance);
        if (geom instanceof LineString) {
            return MoveParallelSupport.moveParallel((LineString)geom, distance, bolMoveRight);
        }
        if (geom instanceof MultiLineString) {
            MultiLineString mly = (MultiLineString)geom;
            ArrayList<LineString> lstGeom = new ArrayList<LineString>();
            for (int i = 0; i < mly.getNumGeometries(); ++i) {
                LineString line = (LineString)mly.getGeometryN(i);
                geomNew = MoveParallelSupport.moveParallel(line, distance, bolMoveRight);
                lstGeom.add(geomNew);
            }
            return geom.getFactory().buildGeometry(lstGeom);
        }
        if (geom instanceof Polygon) {
            return MoveParallelSupport.moveParallel((LineString)((Polygon)geom).getExteriorRing(), distance, bolMoveRight);
        }
        return geomNew;
    }

    public static Coordinate[] moveParallel(CoordinateSequence coordSeq, double distance, boolean bolRight, boolean bolRing) {
        ArrayList<Coordinate[]> lstLine = new ArrayList<Coordinate[]>();
        for (int i = 0; i < coordSeq.size() - 1; ++i) {
            double ori = ConstSupport.getOrientation(coordSeq.getCoordinate(i), coordSeq.getCoordinate(i + 1), 2);
            ori = bolRight ? (ori -= 1.5707963267948966) : (ori += 1.5707963267948966);
            Coordinate[] arrCoord = new Coordinate[]{ConstSupport.getPolarCoord(coordSeq.getCoordinate(i), distance, ori), ConstSupport.getPolarCoord(coordSeq.getCoordinate(i + 1), distance, ori)};
            if (arrCoord[0].equals2D(arrCoord[1])) continue;
            lstLine.add(arrCoord);
        }
        ArrayList<CrdListCandidate> lstCand = new ArrayList<CrdListCandidate>();
        ArrayList<Coordinate> lstCoord = new ArrayList<Coordinate>();
        lstCoord.add(((Coordinate[])lstLine.get(0))[0]);
        Coordinate crdDirection = ((Coordinate[])lstLine.get(0))[1];
        lstCand.add(new CrdListCandidate(lstCoord, crdDirection, 0));
        for (int i = 1; i < lstLine.size(); ++i) {
            ArrayList<Object> lstCoordTmp;
            Coordinate[] arrCoord = (Coordinate[])lstLine.get(i);
            Coordinate crdSection = null;
            CrdListCandidate crdCand = null;
            for (int j = i - 1; j >= 0 && (crdSection = (crdCand = (CrdListCandidate)lstCand.get(j)).getSectionInDirection(arrCoord[0], arrCoord[1])) == null; --j) {
            }
            if (crdSection == null) {
                lstCoordTmp = new ArrayList();
                Coordinate[] arrCoordStart = (Coordinate[])lstLine.get(0);
                crdSection = ConstSupport.getSection(arrCoordStart[0], arrCoordStart[1], arrCoord[0], arrCoord[1]);
                double l = ConstSupport.getLength(arrCoordStart[0], arrCoordStart[1]);
                double riwi = ConstSupport.getOrientation(arrCoordStart[1], arrCoordStart[0], 2);
                lstCoordTmp.add(ConstSupport.getPolarCoord(crdSection, l, riwi));
                lstCoordTmp.add(crdSection);
                if (MoveParallelSupport.sameDirection(arrCoord[0], arrCoord[1], crdSection, arrCoord[1])) {
                    crdDirection = arrCoord[1];
                } else {
                    l = ConstSupport.getLength(arrCoord[0], arrCoord[1]);
                    riwi = ConstSupport.getOrientation(arrCoord[0], arrCoord[1], 2);
                    crdDirection = ConstSupport.getPolarCoord(crdSection, l, riwi);
                }
                lstCand.add(new CrdListCandidate(lstCoordTmp, crdDirection, i));
                continue;
            }
            lstCoordTmp = new ArrayList<Coordinate>(crdCand.getLstCoord());
            lstCoordTmp.add(crdSection);
            double dist = ConstSupport.getLength(arrCoord[0], arrCoord[1]);
            double riwi = ConstSupport.getOrientation(arrCoord[0], arrCoord[1], 2);
            double riwi2 = ConstSupport.getOrientation(crdSection, arrCoord[1], 2);
            crdDirection = Math.abs(riwi - riwi2) < 0.007853981633974483 ? arrCoord[1] : ConstSupport.getPolarCoord(crdSection, dist, riwi);
            lstCand.add(new CrdListCandidate(lstCoordTmp, crdDirection, i));
        }
        CrdListCandidate lastCand = (CrdListCandidate)lstCand.get(lstCand.size() - 1);
        List<Coordinate> lstCoordTmp = new ArrayList<Coordinate>(lastCand.getLstCoord());
        lstCoordTmp.add(crdDirection);
        if (bolRing) {
            lstCoordTmp = MoveParallelSupport.getRing(lstCoordTmp);
        }
        return lstCoordTmp.toArray(new Coordinate[0]);
    }

    private static boolean sameDirection(Coordinate coord, Coordinate coord1, Coordinate coord2) {
        double dxSection = coord1.x - coord.x;
        double dySection = coord1.y - coord.y;
        double dx = coord2.x - coord.x;
        double dy = coord2.y - coord.y;
        return dx > 0.0 == dxSection > 0.0 && dy > 0.0 == dySection > 0.0;
    }

    private static boolean sameDirection(Coordinate coord1, Coordinate coord2, Coordinate coord3, Coordinate coord4) {
        double dx1 = coord2.x - coord1.x;
        double dy1 = coord2.y - coord1.y;
        double dx2 = coord4.x - coord3.x;
        double dy2 = coord4.y - coord3.y;
        return dx1 > 0.0 == dx2 > 0.0 && dy1 > 0.0 == dy2 > 0.0;
    }

    private static boolean isInside(Coordinate coord1, Coordinate coord2, Coordinate coordinside) {
        if (!MoveParallelSupport.sameDirection(coord1, coord2, coordinside)) {
            return false;
        }
        double dxSection = Math.abs(coordinside.x - coord1.x);
        double dySection = Math.abs(coordinside.y - coord1.y);
        double dx = Math.abs(coord2.x - coord1.x);
        double dy = Math.abs(coord2.y - coord1.y);
        return dx > dxSection && dy > dySection;
    }

    private static Coordinate intersectInDirection(Coordinate coord1, Coordinate coord2, Coordinate coord3, Coordinate coord4) {
        Coordinate coordIntersection;
        if (MoveParallelSupport.isParallel(coord1, coord2, coord3, coord4)) {
            double d_ignore;
            Coordinate crdOrtho = ConstSupport.getOrthoSection(coord1, coord2, coord3);
            double d = ConstSupport.getLength(crdOrtho, coord3);
            if (d < (d_ignore = ConstSupport.getLength(coord1, coord2) / 1000.0)) {
                return coord2;
            }
            return null;
        }
        try {
            coordIntersection = ConstSupport.getSection(coord1, coord2, coord3, coord4);
        }
        catch (ArithmeticException e) {
            return null;
        }
        if (MoveParallelSupport.sameDirection(coord1, coord2, coordIntersection)) {
            return coordIntersection;
        }
        return null;
    }

    private static List<Coordinate> getRing(List<Coordinate> lstCoord) {
        int i;
        ArrayList<Coordinate> lstResult = new ArrayList<Coordinate>();
        if (lstCoord.size() < 4) {
            return lstResult;
        }
        if (lstCoord.get(0).equals2D(lstCoord.get(lstCoord.size() - 1))) {
            lstResult.addAll(lstCoord);
            return lstResult;
        }
        int startindex = -1;
        int endindex = -1;
        Coordinate coordRing = null;
        for (i = 1; i < lstCoord.size(); ++i) {
            Coordinate coord1 = lstCoord.get(i - 1);
            Coordinate coord2 = lstCoord.get(i);
            for (int j = lstCoord.size() - 1; i + 1 < j; --j) {
                Coordinate coord3 = lstCoord.get(j - 1);
                Coordinate coord4 = lstCoord.get(j);
                try {
                    Coordinate coordSection = ConstSupport.getSection(coord1, coord2, coord3, coord4);
                    if (!MoveParallelSupport.isInside(coord1, coord2, coordSection) || !MoveParallelSupport.isInside(coord3, coord4, coordSection)) continue;
                    coordRing = coordSection;
                    startindex = i;
                    endindex = j;
                    break;
                }
                catch (ArithmeticException arithmeticException) {
                    // empty catch block
                }
            }
            if (coordRing != null) break;
        }
        if (coordRing != null) {
            lstResult.add(coordRing);
            for (i = startindex; i < endindex; ++i) {
                lstResult.add(lstCoord.get(i));
            }
            lstResult.add((Coordinate)coordRing.clone());
            return lstResult;
        }
        Coordinate coord1 = lstCoord.get(1);
        Coordinate coord2 = lstCoord.get(0);
        Coordinate coord3 = lstCoord.get(lstCoord.size() - 2);
        Coordinate coord4 = lstCoord.get(lstCoord.size() - 1);
        try {
            Coordinate coordSection = ConstSupport.getSection(coord1, coord2, coord3, coord4);
            if (MoveParallelSupport.sameDirection(coord1, coord2, coordSection) && MoveParallelSupport.sameDirection(coord3, coord4, coordSection)) {
                lstResult.addAll(lstCoord);
                lstResult.set(0, coordSection);
                lstResult.set(lstCoord.size() - 1, (Coordinate)coordSection.clone());
            } else if (lstCoord.size() > 4 && MoveParallelSupport.sameDirection(coord1 = lstCoord.get(2), coord2 = lstCoord.get(1), coordSection) && MoveParallelSupport.sameDirection(coord3, coord4, coordSection)) {
                lstResult.addAll(lstCoord);
                lstResult.set(0, coordSection);
                lstResult.set(lstCoord.size() - 1, (Coordinate)coordSection.clone());
            }
        }
        catch (ArithmeticException arithmeticException) {
            // empty catch block
        }
        return lstResult;
    }

    private static boolean isParallel(Coordinate coord1, Coordinate coord2, Coordinate coord3, Coordinate coord4) {
        double ori1 = ConstSupport.getOrientation(coord1, coord2, 2);
        double ori2 = ConstSupport.getOrientation(coord3, coord4, 2);
        ori1 = ConstSupport.getPositiveOrientation(ori1, 2);
        ori2 = ConstSupport.getPositiveOrientation(ori2, 2);
        if (ori1 > Math.PI) {
            ori1 -= Math.PI;
        }
        if (ori2 > Math.PI) {
            ori2 -= Math.PI;
        }
        return Math.abs(ori1 - ori2) < Math.PI / 360;
    }

    private static Coordinate intersectInSideRecursive(List<Coordinate> lstCoord, Coordinate coord1, Coordinate coord2) {
        for (int i = 1; i < lstCoord.size() - 1; ++i) {
            Coordinate coordSection;
            try {
                coordSection = ConstSupport.getSection(lstCoord.get(i - 1), lstCoord.get(i), coord1, coord2);
            }
            catch (ArithmeticException ae) {
                continue;
            }
            if (coordSection == null || !MoveParallelSupport.isInside(lstCoord.get(i - 1), lstCoord.get(i), coordSection) || !MoveParallelSupport.isInside(coord1, coord2, coordSection)) continue;
            return coordSection;
        }
        return null;
    }

    public static boolean moveRight(Geometry geom, double distance, Coordinate coord4Distance) throws IllegalArgumentException {
        double oriTest;
        MoveParallelSupport.checkType(geom);
        Coordinate coord1 = null;
        Coordinate coord2 = null;
        double ldiff = Double.MAX_VALUE;
        Coordinate[] arrGeomCoord = geom.getCoordinates();
        for (int i = 1; i < arrGeomCoord.length; ++i) {
            double l2;
            Coordinate coord1Tmp = arrGeomCoord[i - 1];
            Coordinate coord2Tmp = arrGeomCoord[i];
            double l1 = ConstSupport.getLength(coord1Tmp, coord2Tmp);
            double ldifftmp = Math.abs(l1 - (l2 = ConstSupport.getLength(coord1Tmp, coord4Distance) + ConstSupport.getLength(coord2Tmp, coord4Distance)));
            if (!(ldifftmp < ldiff)) continue;
            coord1 = coord1Tmp;
            coord2 = coord2Tmp;
            ldiff = ldifftmp;
        }
        Coordinate coordSection = ConstSupport.getOrthoSection(coord1, coord2, coord4Distance);
        double ori1 = ConstSupport.getPositiveOrientation(ConstSupport.getOrientation(coord1, coord2, 2), 2);
        double ori2 = ConstSupport.getPositiveOrientation(ConstSupport.getOrientation(coordSection, coord4Distance, 2), 2);
        return !(Math.abs(ori2 - (oriTest = ConstSupport.getPositiveOrientation(ori1 + 1.5707963267948966, 2))) < Math.PI / 360);
    }

    private MoveParallelSupport() {
    }

    private static class CrdListCandidate {
        private List<Coordinate> lstCoord = null;
        private Coordinate crdDirection = null;
        private int index = -1;

        CrdListCandidate(List<Coordinate> lstCoord, Coordinate crdDirection, int index) {
            this.lstCoord = lstCoord;
            this.crdDirection = crdDirection;
            this.index = index;
        }

        public Coordinate getCrdDirection() {
            return this.crdDirection;
        }

        public int getIndex() {
            return this.index;
        }

        public List<Coordinate> getLstCoord() {
            return this.lstCoord;
        }

        public Coordinate getSectionInDirection(Coordinate coord1, Coordinate coord2) {
            if (this.crdDirection.equals2D(coord1)) {
                return coord1;
            }
            Coordinate crdSection = MoveParallelSupport.intersectInDirection(this.lstCoord.get(this.lstCoord.size() - 1), this.crdDirection, coord1, coord2);
            if (crdSection != null && MoveParallelSupport.intersectInSideRecursive(this.lstCoord, this.lstCoord.get(this.lstCoord.size() - 1), crdSection) != null) {
                crdSection = null;
            }
            return crdSection;
        }
    }
}

