/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.util.construction;

import java.awt.geom.Point2D;
import java.util.List;
import org.locationtech.jts.geom.Coordinate;

public class ConstSupport {
    public static final int ANGLE_DEGREE = 0;
    public static final int ANGLE_GON = 1;
    public static final int ANGLE_RAD = 2;

    private ConstSupport() {
    }

    public static double getOrientation(Coordinate coord1, Coordinate coord2, int intAngleUnit) {
        double dblOri;
        double dx = coord2.x - coord1.x;
        double dy = coord2.y - coord1.y;
        if (dy == 0.0) {
            if (dx == 0.0) {
                return 0.0;
            }
            dblOri = dx > 0.0 ? 4.71238898038469 : 1.5707963267948966;
        } else {
            dblOri = Math.atan(-dx / dy);
            if (dy < 0.0) {
                dblOri += Math.PI;
            }
        }
        if (dblOri < 0.0) {
            dblOri += Math.PI * 2;
        }
        if (dblOri > Math.PI * 2) {
            dblOri -= Math.PI * 2;
        }
        switch (intAngleUnit) {
            case 0: {
                return dblOri * 180.0 / Math.PI;
            }
            case 1: {
                dblOri = Math.PI * 2 - dblOri;
                return dblOri * 200.0 / Math.PI;
            }
        }
        return dblOri;
    }

    public static double getPositiveOrientation(double dblOri, int intAngleUnit) {
        double newOrientation;
        double maxAngle = Math.PI * 2;
        switch (intAngleUnit) {
            case 0: {
                maxAngle = 360.0;
                break;
            }
            case 1: {
                maxAngle = 400.0;
            }
        }
        for (newOrientation = dblOri; newOrientation <= 0.0; newOrientation += maxAngle) {
        }
        while (newOrientation > maxAngle) {
            newOrientation -= maxAngle;
        }
        return newOrientation;
    }

    public static double getOrientation(Point2D coord1, Point2D coord2, int intAngleUnit) {
        double dblOri;
        double dx = coord2.getX() - coord1.getX();
        double dy = coord2.getY() - coord1.getY();
        if (dy == 0.0) {
            if (dx == 0.0) {
                return 0.0;
            }
            dblOri = dx > 0.0 ? 4.71238898038469 : 1.5707963267948966;
        } else {
            dblOri = Math.atan(-dx / dy);
            if (dy < 0.0) {
                dblOri += Math.PI;
            }
        }
        if (dblOri < 0.0) {
            dblOri += Math.PI * 2;
        }
        if (dblOri > Math.PI * 2) {
            dblOri -= Math.PI * 2;
        }
        switch (intAngleUnit) {
            case 0: {
                return dblOri * 180.0 / Math.PI;
            }
            case 1: {
                dblOri = Math.PI * 2 - dblOri;
                return dblOri * 200.0 / Math.PI;
            }
        }
        return dblOri;
    }

    public static Coordinate getPolarCoord(Coordinate coord, double dist, double dblAngleInRad) {
        double x = coord.x - dist * Math.sin(dblAngleInRad);
        double y = coord.y + dist * Math.cos(dblAngleInRad);
        return new Coordinate(x, y, coord.getZ());
    }

    public static Point2D getPolarPoint2D(Point2D coord, double dist, double dblAngleInRad) {
        double x = coord.getX() + dist * Math.sin(dblAngleInRad);
        double y = coord.getY() - dist * Math.cos(dblAngleInRad);
        return new Point2D.Double(x, y);
    }

    public static double getLength(Point2D coord1, Point2D coord2) {
        double dx = coord2.getX() - coord1.getX();
        double dy = coord2.getY() - coord1.getY();
        return Math.sqrt(dx * dx + dy * dy);
    }

    public static double getLength(Coordinate coord1, Coordinate coord2) {
        double dx = coord2.x - coord1.x;
        double dy = coord2.y - coord1.y;
        return Math.sqrt(dx * dx + dy * dy);
    }

    public static double getLength(List<Coordinate> coordinates) {
        double distance = 0.0;
        for (int i = 1; i < coordinates.size(); ++i) {
            distance += coordinates.get(i - 1).distance(coordinates.get(i));
        }
        return distance;
    }

    public static Coordinate getSection(Coordinate c1Start, Coordinate c1End, Coordinate c2Start, Coordinate c2End) {
        double dy;
        double dx2;
        double dx1;
        double ori1 = ConstSupport.getOrientation(c1Start, c1End, 2);
        double tant1 = 0.0;
        boolean bolInfinity1 = false;
        if (ori1 != 1.5707963267948966 && ori1 != 4.71238898038469) {
            if (ori1 % Math.PI == 0.0) {
                bolInfinity1 = true;
            } else {
                tant1 = -1.0 / Math.tan(ori1);
            }
        }
        double ori2 = ConstSupport.getOrientation(c2Start, c2End, 2);
        double tant2 = 0.0;
        boolean bolInfinity2 = false;
        if (ori2 != 1.5707963267948966 && ori2 != 4.71238898038469) {
            if (ori2 % Math.PI == 0.0) {
                bolInfinity2 = true;
            } else {
                tant2 = -1.0 / Math.tan(ori2);
            }
        }
        double dblX = 0.0;
        double dblY = 0.0;
        if (bolInfinity1) {
            dx1 = c2End.x - c2Start.x;
            dx2 = c1Start.x - c2Start.x;
            dy = c2End.y - c2Start.y;
            dblX = c1Start.x;
            dblY = c2Start.y + dx2 / dx1 * dy;
        }
        if (bolInfinity2) {
            dx1 = c1End.x - c1Start.x;
            dx2 = c2Start.x - c1Start.x;
            dy = c1End.y - c1Start.y;
            dblX = c2Start.x;
            dblY = c1Start.y + dx2 / dx1 * dy;
        }
        if (!bolInfinity1 && !bolInfinity2) {
            dblX = (c1Start.y - c2Start.y + c2Start.x * tant2 - c1Start.x * tant1) / (tant2 - tant1);
            dblY = c1Start.y + tant1 * (dblX - c1Start.x);
        }
        if (Double.isInfinite(dblX) || Double.isNaN(dblX) || Double.isInfinite(dblY) || Double.isNaN(dblY)) {
            throw new ArithmeticException("invalid section");
        }
        return new Coordinate(dblX, dblY, c1Start.getZ());
    }

    public static Point2D getSection(Point2D c1Start, Point2D c1End, Point2D c2Start, Point2D c2End) {
        double dy;
        double dx2;
        double dx1;
        double ori1 = ConstSupport.getOrientation(c1Start, c1End, 2);
        double tant1 = 0.0;
        boolean bolInfinity1 = false;
        if (ori1 != 1.5707963267948966 && ori1 != 4.71238898038469) {
            if (ori1 % Math.PI == 0.0) {
                bolInfinity1 = true;
            } else {
                tant1 = -1.0 / Math.tan(ori1);
            }
        }
        double ori2 = ConstSupport.getOrientation(c2Start, c2End, 2);
        double tant2 = 0.0;
        boolean bolInfinity2 = false;
        if (ori2 != 1.5707963267948966 && ori2 != 4.71238898038469) {
            if (ori2 % Math.PI == 0.0) {
                bolInfinity2 = true;
            } else {
                tant2 = -1.0 / Math.tan(ori2);
            }
        }
        double dblX = 0.0;
        double dblY = 0.0;
        if (bolInfinity1) {
            dx1 = c2End.getX() - c2Start.getX();
            dx2 = c1Start.getX() - c2Start.getX();
            dy = c2End.getY() - c2Start.getY();
            dblX = c1Start.getX();
            dblY = c2Start.getY() + dx2 / dx1 * dy;
        }
        if (bolInfinity2) {
            dx1 = c1End.getX() - c1Start.getX();
            dx2 = c2Start.getX() - c1Start.getX();
            dy = c1End.getY() - c1Start.getY();
            dblX = c2Start.getX();
            dblY = c1Start.getY() + dx2 / dx1 * dy;
        }
        if (!bolInfinity1 && !bolInfinity2) {
            dblX = (c1Start.getY() - c2Start.getY() + c2Start.getX() * tant2 - c1Start.getX() * tant1) / (tant2 - tant1);
            dblY = c1Start.getY() + tant1 * (dblX - c1Start.getX());
        }
        if (Double.isInfinite(dblX) || Double.isNaN(dblX) || Double.isInfinite(dblY) || Double.isNaN(dblY)) {
            throw new ArithmeticException("invalid section");
        }
        return new Point2D.Double(dblX, dblY);
    }

    public static Coordinate getOrthoSection(Coordinate c1Start, Coordinate c1End, Coordinate cOrtho) {
        double dblY;
        double dblX;
        double ori1 = ConstSupport.getOrientation(c1Start, c1End, 2);
        double tant1 = 0.0;
        boolean bolInfinity1 = false;
        if (ori1 != 1.5707963267948966 && ori1 != 4.71238898038469) {
            if (ori1 % Math.PI == 0.0) {
                bolInfinity1 = true;
            } else {
                tant1 = -1.0 / Math.tan(ori1);
            }
        }
        if (bolInfinity1) {
            dblX = c1Start.x;
            dblY = cOrtho.y;
        } else {
            double t1 = Math.atan(tant1);
            double tant2 = -1.0 * Math.tan(1.5707963267948966 - t1);
            dblX = (c1Start.y - cOrtho.y + cOrtho.x * tant2 - c1Start.x * tant1) / (tant2 - tant1);
            dblY = c1Start.y + tant1 * (dblX - c1Start.x);
        }
        return new Coordinate(dblX, dblY, c1Start.getZ());
    }

    public static Point2D getOrthoSection(Point2D c1Start, Point2D c1End, Point2D cOrtho) {
        double dblY;
        double dblX;
        double ori1 = ConstSupport.getOrientation(c1Start, c1End, 2);
        double tant1 = 0.0;
        boolean bolInfinity1 = false;
        if (ori1 != 1.5707963267948966 && ori1 != 4.71238898038469) {
            if (ori1 % Math.PI == 0.0) {
                bolInfinity1 = true;
            } else {
                tant1 = -1.0 / Math.tan(ori1);
            }
        }
        if (bolInfinity1) {
            dblX = c1Start.getX();
            dblY = cOrtho.getY();
        } else {
            double t1 = Math.atan(tant1);
            double tant2 = -1.0 * Math.tan(1.5707963267948966 - t1);
            dblX = (c1Start.getY() - cOrtho.getY() + cOrtho.getX() * tant2 - c1Start.getX() * tant1) / (tant2 - tant1);
            dblY = c1Start.getY() + tant1 * (dblX - c1Start.getX());
        }
        return new Point2D.Double(dblX, dblY);
    }

    public static Coordinate getOrthoCoord(Coordinate c1Start, Coordinate c1End, double dblLine, double dblOrtho) {
        double dblDeltaOri;
        double newDblOrtho = -dblOrtho;
        double dblOri = ConstSupport.getOrientation(c1Start, c1End, 2);
        if (dblLine == 0.0) {
            dblDeltaOri = -1.5707963267948966;
            if (newDblOrtho > 0.0) {
                dblDeltaOri *= -1.0;
            }
        } else {
            dblDeltaOri = Math.atan(newDblOrtho / dblLine);
        }
        if (dblLine < 0.0) {
            dblDeltaOri += Math.PI;
        }
        double dblDist = Math.sqrt(dblLine * dblLine + newDblOrtho * newDblOrtho);
        double dblOriNew = dblOri + dblDeltaOri;
        return ConstSupport.getPolarCoord(c1Start, dblDist, dblOriNew);
    }

    public static Point2D getOrthoPoint2D(Point2D c1Start, Point2D c1End, double dblLine, double dblOrtho) {
        double dblDeltaOri;
        double newDblOrtho = -dblOrtho;
        double dblOri = ConstSupport.getOrientation(c1Start, c1End, 2);
        if (dblLine == 0.0) {
            dblDeltaOri = -1.5707963267948966;
            if (newDblOrtho > 0.0) {
                dblDeltaOri *= -1.0;
            }
        } else {
            dblDeltaOri = Math.atan(newDblOrtho / dblLine);
        }
        if (dblLine < 0.0) {
            dblDeltaOri += Math.PI;
        }
        double dblDist = Math.sqrt(dblLine * dblLine + newDblOrtho * newDblOrtho);
        double dblOriNew = dblOri + dblDeltaOri;
        return ConstSupport.getPolarPoint2D(c1Start, dblDist, dblOriNew);
    }

    public static Coordinate getArcSection(Coordinate c1Center, Coordinate c2Center, double dblR1, double dblR2, boolean bolRight) {
        double dy;
        double dx;
        double d;
        double vz = 1.0;
        if (bolRight) {
            vz = -1.0;
        }
        if ((d = Math.sqrt((dx = c2Center.x - c1Center.x) * dx + (dy = c2Center.y - c1Center.y) * dy)) > dblR1 + dblR2) {
            return null;
        }
        double p = (d * d + dblR1 * dblR1 - dblR2 * dblR2) / (2.0 * d);
        double h = vz * Math.sqrt(dblR1 * dblR1 - p * p);
        double a = dx / d;
        double o = dy / d;
        double dblXNew = c1Center.x + a * p - o * h;
        double dblYNew = c1Center.y + o * p + a * h;
        return new Coordinate(dblXNew, dblYNew, c1Center.getZ());
    }

    public static Point2D getArcSection(Point2D c1Center, Point2D c2Center, double dblR1, double dblR2, boolean bolRight) {
        double dy;
        double dx;
        double d;
        double vz = 1.0;
        if (bolRight) {
            vz = -1.0;
        }
        if ((d = Math.sqrt((dx = c2Center.getX() - c1Center.getX()) * dx + (dy = c2Center.getY() - c1Center.getY()) * dy)) > dblR1 + dblR2) {
            return null;
        }
        double p = (d * d + dblR1 * dblR1 - dblR2 * dblR2) / (2.0 * d);
        double h = vz * Math.sqrt(dblR1 * dblR1 - p * p);
        double a = dx / d;
        double o = dy / d;
        double dblXNew = c1Center.getX() + a * p - o * h;
        double dblYNew = c1Center.getY() + o * p + a * h;
        return new Point2D.Double(dblXNew, dblYNew);
    }

    public static Coordinate getTransformedCoordinate(Coordinate coord, Coordinate centerCoord, double dblRotationInRad, double dx, double dy) {
        double[][] arrMatrix = new double[2][2];
        arrMatrix[0][0] = Math.cos(dblRotationInRad);
        arrMatrix[0][1] = -Math.sin(dblRotationInRad);
        arrMatrix[1][0] = Math.sin(dblRotationInRad);
        arrMatrix[1][1] = Math.cos(dblRotationInRad);
        double[] arrXY = new double[]{coord.x - centerCoord.x, coord.y - centerCoord.y};
        double[] arrResult = new double[]{0.0, 0.0};
        for (int j = 0; j < arrMatrix.length; ++j) {
            for (int k = 0; k < arrMatrix[j].length; ++k) {
                int n = j;
                arrResult[n] = arrResult[n] + arrMatrix[j][k] * arrXY[k];
            }
        }
        double dblXNew = arrResult[0] + centerCoord.x + dx;
        double dblYNew = arrResult[1] + centerCoord.y + dy;
        return new Coordinate(dblXNew, dblYNew, coord.getZ());
    }

    public static Point2D getTransformedPoint2D(Point2D coord, Point2D centerCoord, double dblRotationInRad, double dx, double dy) throws Exception {
        double[][] arrMatrix = new double[2][2];
        arrMatrix[0][0] = Math.cos(dblRotationInRad);
        arrMatrix[0][1] = Math.sin(dblRotationInRad);
        arrMatrix[1][0] = -Math.sin(dblRotationInRad);
        arrMatrix[1][1] = Math.cos(dblRotationInRad);
        double[] arrXY = new double[]{coord.getX() - centerCoord.getX(), coord.getY() - centerCoord.getY()};
        double[] arrResult = new double[]{0.0, 0.0};
        for (int j = 0; j < arrMatrix.length; ++j) {
            for (int k = 0; k < arrMatrix[j].length; ++k) {
                int n = j;
                arrResult[n] = arrResult[n] + arrMatrix[j][k] * arrXY[k];
            }
        }
        double dblXNew = arrResult[0] + centerCoord.getX() + dx;
        double dblYNew = arrResult[1] + centerCoord.getY() + dy;
        return new Point2D.Double(dblXNew, dblYNew);
    }
}

