/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.util.construction;

import de.riwagis.util.construction.ConstSupport;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateList;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.util.Assert;

public class Arc {
    private final Coordinate center;
    private final Coordinate start;
    private final Coordinate middle;
    private final Coordinate end;
    private final double radius;
    private double tolerance = 0.01;

    public Arc(Coordinate center, Coordinate start, double angle) {
        this.center = center;
        this.start = start;
        this.radius = ConstSupport.getLength(center, start);
        double tstart = ConstSupport.getOrientation(center, start, 2);
        double tmiddle = tstart + angle / 2.0;
        this.middle = ConstSupport.getPolarCoord(start, this.radius, tmiddle);
        if (angle == Math.PI * 2) {
            this.end = new Coordinate(start);
        } else {
            double tend = tstart + angle;
            this.end = ConstSupport.getPolarCoord(start, this.radius, tend);
        }
    }

    public Arc(Coordinate start, Coordinate middle, Coordinate end) {
        this.start = start;
        this.middle = middle;
        this.end = end;
        double A = middle.x - start.x;
        double B = middle.y - start.y;
        double C = end.x - start.x;
        double D = end.y - start.y;
        double E = A * (start.x + middle.x) + B * (start.y + middle.y);
        double F = C * (start.x + end.x) + D * (start.y + end.y);
        double G = 2.0 * (A * (end.y - middle.y) - B * (end.x - middle.x));
        if (G != 0.0) {
            double px = (D * E - B * F) / G;
            double py = (A * F - C * E) / G;
            this.center = new Coordinate(px, py);
            this.radius = Math.sqrt((start.x - px) * (start.x - px) + (start.y - py) * (start.y - py));
        } else {
            this.radius = Double.MAX_VALUE;
            this.center = null;
        }
    }

    public void setTolerance(double tolerance) {
        this.tolerance = tolerance;
    }

    public Coordinate getCenter() {
        return new Coordinate(this.center);
    }

    public double getRadius() {
        return this.radius;
    }

    public Polygon getPolygon() {
        CoordinateList polyCoords;
        if (this.center == null) {
            Assert.shouldNeverReachHere((String)"No polygon possible as the 3 arc points are on one line.");
        }
        if ((polyCoords = this.getArcPoints()).getCoordinate(0).equals2D(polyCoords.getCoordinate(polyCoords.size() - 1))) {
            return new GeometryFactory().createPolygon(new GeometryFactory().createLinearRing(polyCoords.toCoordinateArray()), null);
        }
        polyCoords.add(0, (Object)this.center);
        polyCoords.add(this.center);
        return new GeometryFactory().createPolygon(new GeometryFactory().createLinearRing(polyCoords.toCoordinateArray()), null);
    }

    public LineString getLineString() {
        CoordinateList coordinates = this.getArcPoints();
        return new GeometryFactory().createLineString(coordinates.toCoordinateArray());
    }

    public CoordinateList getCoordinates() {
        return this.getArcPoints();
    }

    protected CoordinateList getArcPoints() {
        double dt2;
        CoordinateList clist = new CoordinateList();
        double a = Math.max(Math.abs(4.0 * Math.asin(Math.sqrt(this.tolerance / (2.0 * this.radius)))), 0.05);
        double tStart = ConstSupport.getOrientation(this.center, this.start, 2);
        double tMiddle = ConstSupport.getOrientation(this.center, this.middle, 2);
        double tEnd = ConstSupport.getOrientation(this.center, this.end, 2);
        tStart = ConstSupport.getPositiveOrientation(tStart, 2);
        tMiddle = ConstSupport.getPositiveOrientation(tMiddle, 2);
        tEnd = ConstSupport.getPositiveOrientation(tEnd, 2);
        boolean bolPosArc = true;
        double dt1 = tMiddle - tStart;
        if (dt1 < 0.0) {
            dt1 = Math.PI * 2 + dt1;
        }
        if ((dt2 = tEnd - tStart) < 0.0) {
            dt2 = Math.PI * 2 + dt2;
        }
        if (dt1 > dt2) {
            bolPosArc = false;
            dt2 = Math.PI * 2 - dt2;
        }
        double aRest = Math.abs(dt2 % a);
        clist.add(this.start);
        if (bolPosArc) {
            double tdiff = tStart + aRest / 2.0;
            for (double sum = aRest / 2.0; sum < dt2; sum += a) {
                clist.add(ConstSupport.getPolarCoord(this.center, this.radius, tdiff));
                tdiff += a;
            }
        } else {
            double tdiff = tStart - aRest / 2.0;
            for (double sum = aRest / 2.0; sum < dt2; sum += a) {
                clist.add(ConstSupport.getPolarCoord(this.center, this.radius, tdiff));
                tdiff -= a;
            }
        }
        clist.add(this.end, false);
        return clist;
    }
}

