/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.util.construction;

public enum AngleUnit {
    GRAD(180.0),
    GON(200.0),
    RAD(Math.PI);

    private final double halfCircleValue;

    private AngleUnit(double halfCircleValue) {
        this.halfCircleValue = halfCircleValue;
    }

    public final double getHalfCircleValue() {
        return this.halfCircleValue;
    }

    public final double to(double angle, AngleUnit to) {
        if (to == this) {
            return angle;
        }
        return angle / this.halfCircleValue * to.getHalfCircleValue();
    }

    public static final double convert(double angle, AngleUnit srcUnit, AngleUnit dstUnit) {
        return srcUnit.to(angle, dstUnit);
    }
}

