/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.webutil.log4j;

import jakarta.servlet.ServletContextEvent;
import jakarta.servlet.ServletContextListener;
import java.io.File;
import java.util.logging.Level;
import java.util.logging.LogManager;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.core.LifeCycle;
import org.apache.logging.log4j.core.LoggerContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.bridge.SLF4JBridgeHandler;

public class Log4jConfigListener
implements ServletContextListener {
    private static final Logger LOG = LoggerFactory.getLogger(Log4jConfigListener.class);
    private boolean jul2log4jActive = false;

    public void contextDestroyed(ServletContextEvent event) {
        LOG.info("shutdown logging");
        try {
            ((LifeCycle)org.apache.logging.log4j.LogManager.getContext()).stop();
            if (this.jul2log4jActive) {
                LogManager.getLogManager().reset();
                SLF4JBridgeHandler.removeHandlersForRootLogger();
            }
        }
        catch (Throwable cnf) {
            System.err.println(String.format("error shutting down logging: %s", cnf.getMessage()));
            cnf.printStackTrace(System.err);
        }
    }

    public void contextInitialized(ServletContextEvent event) {
        try {
            LogManager.getLogManager().reset();
            SLF4JBridgeHandler.removeHandlersForRootLogger();
            SLF4JBridgeHandler.install();
            java.util.logging.Logger.getLogger("global").setLevel(Level.FINEST);
            this.jul2log4jActive = true;
        }
        catch (Throwable cnf) {
            System.err.println(String.format("error initializing bridge from JUL to SLF4J: %s", cnf.getMessage()));
            cnf.printStackTrace(System.err);
        }
        String log4jFile_jndi = Log4jConfigListener.readLog4JConfigFileJNDI();
        if (StringUtils.isNotBlank((CharSequence)log4jFile_jndi)) {
            File logConfigFile = new File(log4jFile_jndi);
            if (!logConfigFile.exists()) {
                String errmsg = String.format("!!! SEVERE CONFIGURATION ERROR !!!: Invalid 'log4j_config' parameter value '%s'. Web context will not startup.", logConfigFile);
                System.err.println(errmsg);
                throw new IllegalArgumentException(errmsg);
            }
            LoggerContext context = (LoggerContext)org.apache.logging.log4j.LogManager.getContext((boolean)false);
            context.setConfigLocation(logConfigFile.toURI());
            LOG.info(String.format("Logging initialized: '%s'", logConfigFile));
        } else {
            LOG.warn(String.format("Unknown log-config: '%s'", log4jFile_jndi));
        }
    }

    private static String readLog4JConfigFileJNDI() {
        String string;
        InitialContext initCtx = new InitialContext();
        try {
            string = ObjectUtils.toString((Object)initCtx.lookup("java:comp/env/log4j_config"));
        }
        catch (Throwable throwable) {
            try {
                initCtx.close();
                throw throwable;
            }
            catch (NamingException ex) {
                LOG.debug(String.format("unable to acquire log-configuration from jndi: %s", ex.getMessage()), (Throwable)ex);
                return null;
            }
        }
        initCtx.close();
        return string;
    }
}

