/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.webutil.http;

import jakarta.servlet.http.HttpServletRequest;

public enum UserAgent {
    USERAGENT_UNKNOWN,
    USERAGENT_MOZILLA,
    USERAGENT_WEBKIT;

    private static final String USER_AGENT = "User-Agent";
    private static final String DETECT_USERAGENT_JAVAFX = "JavaFX";
    private static final String DETECT_USERAGENT_CHROME = "Chrome";

    public static UserAgent detect(String userAgentString) {
        if (!userAgentString.contains(DETECT_USERAGENT_JAVAFX) && !userAgentString.contains(DETECT_USERAGENT_CHROME)) {
            return USERAGENT_MOZILLA;
        }
        if (userAgentString.contains(DETECT_USERAGENT_JAVAFX) || userAgentString.contains(DETECT_USERAGENT_CHROME)) {
            return USERAGENT_WEBKIT;
        }
        return USERAGENT_UNKNOWN;
    }

    public static UserAgent detect(HttpServletRequest request) {
        String userAgent = request.getHeader(USER_AGENT);
        return UserAgent.detect(userAgent);
    }

    public boolean isWebKitBrowser() {
        return this == USERAGENT_WEBKIT;
    }

    public boolean isMozillaBrowser() {
        return this == USERAGENT_MOZILLA;
    }
}

