/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.webutil.http;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;

public final class HttpSupport {
    private HttpSupport() {
    }

    public static String remoteAdress(HttpServletRequest request) {
        String remoteIp;
        String forwaredForIp = request.getHeader("X-Forwarded-For");
        if (forwaredForIp == null) {
            remoteIp = request.getRemoteAddr();
        } else {
            String[] ips = forwaredForIp.split(",");
            remoteIp = ips[0];
        }
        return remoteIp;
    }

    public static void addDefaultHeaders(HttpServletResponse response) {
        HttpSupport.addNoCacheHeaders(response);
        HttpSupport.addUtf8Headers(response);
    }

    public static void addNoCacheHeaders(HttpServletResponse response) {
        response.setHeader("Pragma", "no-cache");
        response.setHeader("Cache-Control", "no-cache");
        response.setHeader("Cache-Control", "no-store");
        response.setDateHeader("Expires", 0L);
    }

    public static void addUtf8Headers(HttpServletResponse response) {
        response.setContentType("text/html; charset=utf-8");
        response.setCharacterEncoding("utf-8");
    }
}

