/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.webgis.servlet.exception;

import jakarta.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class JSPExceptionLoggingUtil {
    public static final Logger JSPLOG = LoggerFactory.getLogger((String)"JSP");

    public static final void logJSPException(HttpServletRequest request, Throwable throwable) {
        if (throwable != null && !StringUtils.containsIgnoreCase((CharSequence)throwable.getClass().getName(), (CharSequence)"NoLoggingSystemException")) {
            String requestUriLog = ObjectUtils.toString((Object)request.getAttribute("jakarta.servlet.error.request_uri"), (String)"Unknown Request URI");
            String servletNameLog = ObjectUtils.toString((Object)request.getAttribute("jakarta.servlet.error.servlet_name"), (String)"Unknown Servlet");
            Integer statusCodeLog = (Integer)request.getAttribute("jakarta.servlet.error.status_code");
            MDC.put((String)"request_uri", (String)requestUriLog);
            MDC.put((String)"request_servletname", (String)servletNameLog);
            JSPLOG.error(String.format("error in servlet (name: %s, request URI: %s, statuscode: %s): %s", servletNameLog, requestUriLog, statusCodeLog, throwable.getMessage()), throwable);
            MDC.remove((String)"request_servletname");
            MDC.remove((String)"request_uri");
        }
    }

    private JSPExceptionLoggingUtil() {
    }
}

