/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.webgis.servlet.exception;

import de.riwagis.webgis.servlet.exception.ApplicationExceptionConstants;
import de.riwagis.webgis.servlet.exception.JSPExceptionLoggingUtil;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Scanner;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.commons.lang3.text.StrSubstitutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApplicationExceptionHandler
extends HttpServlet {
    private static final Logger LOG = LoggerFactory.getLogger(ApplicationExceptionHandler.class);
    public static final String DEFAULT_ERROR_PAGE_TEMPLATE = "/DefaultErrorPageTemplate.html";
    private String template;

    private static final String loadToString(InputStream is) throws IOException {
        try {
            String string = new Scanner(is, "UTF-8").useDelimiter("\\A").next();
            return string;
        }
        finally {
            is.close();
        }
    }

    public void init() throws ServletException {
        super.init();
        this.template = ApplicationExceptionConstants.HTML_TEMPLATE;
        try {
            String configuredTemplate = this.getServletConfig().getInitParameter("htmltemplate");
            this.template = StringUtils.isNotBlank((CharSequence)configuredTemplate) ? ApplicationExceptionHandler.loadToString(new FileInputStream(this.getServletContext().getRealPath(configuredTemplate))) : ApplicationExceptionHandler.loadToString(ApplicationExceptionHandler.class.getResourceAsStream(DEFAULT_ERROR_PAGE_TEMPLATE));
        }
        catch (Exception ex) {
            LOG.warn(String.format("unable to load resource '%s': %s", DEFAULT_ERROR_PAGE_TEMPLATE, ex.getMessage()), (Throwable)ex);
        }
    }

    public void processRequest(HttpServletRequest request, HttpServletResponse response) throws IOException {
        Throwable throwable = (Throwable)request.getAttribute("jakarta.servlet.error.exception");
        JSPExceptionLoggingUtil.logJSPException(request, throwable);
        if (!response.isCommitted()) {
            response.reset();
            Integer statusCode = (Integer)request.getAttribute("jakarta.servlet.error.status_code");
            String servletName = Objects.toString(request.getAttribute("jakarta.servlet.error.servlet_name"), "Unknown Servlet");
            String requestUri = Objects.toString(request.getAttribute("jakarta.servlet.error.request_uri"), "Unknown Request URI");
            String throwableClass = throwable != null ? throwable.getClass().getName() : "---";
            String throwableMessage = throwable != null ? throwable.getMessage() : "---";
            String throwableStacktrace = throwable != null ? ExceptionUtils.getStackTrace((Throwable)throwable) : "---";
            LinkedHashMap<String, String> valuesMap = new LinkedHashMap<String, String>();
            ApplicationExceptionHandler.addValue(valuesMap, "title", "Unexpected Error");
            ApplicationExceptionHandler.addValue(valuesMap, "requestUri", requestUri);
            ApplicationExceptionHandler.addValue(valuesMap, "statusCode", statusCode);
            ApplicationExceptionHandler.addValue(valuesMap, "throwableClass", throwableClass);
            ApplicationExceptionHandler.addValue(valuesMap, "throwableMessage", throwableMessage);
            ApplicationExceptionHandler.addValue(valuesMap, "throwableStacktrace", throwableStacktrace);
            ApplicationExceptionHandler.addValue(valuesMap, "servletName", servletName);
            ApplicationExceptionHandler.addValue(valuesMap, "contextPath", request.getContextPath());
            String pageContent = new StrSubstitutor(valuesMap).replace(this.template);
            response.setContentType("text/html");
            response.setStatus(500);
            PrintWriter out = response.getWriter();
            out.write(pageContent);
        }
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    public String getServletInfo() {
        return "Short description";
    }

    public static final void addValue(Map<String, String> valuesMap, String key, Object value) {
        String valueStr = Objects.toString(value, "");
        valuesMap.put(key, StringEscapeUtils.escapeHtml4((String)valueStr));
        valuesMap.put(key + ".raw", valueStr);
    }
}

