/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.webgis.filter;

import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NoCacheFilter
implements Filter {
    private static final Logger LOG = LoggerFactory.getLogger(NoCacheFilter.class);

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpreq;
        if (response instanceof HttpServletResponse && (httpreq = (HttpServletRequest)request).getRequestURI().toLowerCase().endsWith(".jsp")) {
            HttpServletResponse httpres = (HttpServletResponse)response;
            httpres.setHeader("Pragma", "no-cache");
            httpres.setHeader("Cache-Control", "no-cache");
            httpres.setHeader("Cache-Control", "no-store");
            httpres.setDateHeader("Expires", 0L);
        }
        chain.doFilter(request, response);
    }

    public void destroy() {
    }

    public void init(FilterConfig _filterConfig) {
        LOG.info(String.format("Filter '%s' initialized.", _filterConfig.getFilterName()));
        LOG.debug(String.format("Filterconfig: %s", _filterConfig));
    }
}

