/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.util.gui.units;

import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Toolkit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnitConversion {
    private static final Logger log = LoggerFactory.getLogger(UnitConversion.class);
    private static int defaultScreenResolution = -1;

    public static final int inchAsPixel(double in, Component component) {
        return UnitConversion.inchAsPixel(in, UnitConversion.getScreenResolution(component));
    }

    public static final int millimeterAsPixel(double mm, Component component) {
        return UnitConversion.millimeterAsPixel(mm, UnitConversion.getScreenResolution(component));
    }

    public static final int centimeterAsPixel(double cm, Component component) {
        return UnitConversion.centimeterAsPixel(cm, UnitConversion.getScreenResolution(component));
    }

    public static final int pointAsPixel(int pt, Component component) {
        return UnitConversion.pointAsPixel(pt, UnitConversion.getScreenResolution(component));
    }

    protected static final int inchAsPixel(double in, int dpi) {
        return (int)Math.round((double)dpi * in);
    }

    protected static final int millimeterAsPixel(double mm, int dpi) {
        return (int)Math.round((double)dpi * mm / 25.4);
    }

    protected static final int centimeterAsPixel(double cm, int dpi) {
        return (int)Math.round((double)dpi * cm * 10.0 / 25.4);
    }

    protected static final int pointAsPixel(int pt, double dpi) {
        return (int)Math.round(dpi * (double)pt / 72.0);
    }

    protected static final int dialogUnitXAsPixel(int dluX, double dialogBaseUnitsX) {
        return (int)Math.round((double)dluX * dialogBaseUnitsX / 4.0);
    }

    protected static final int dialogUnitYAsPixel(int dluY, double dialogBaseUnitsY) {
        return (int)Math.round((double)dluY * dialogBaseUnitsY / 8.0);
    }

    protected static final double computeAverageCharWidth(FontMetrics metrics, String testString) {
        double width = metrics.stringWidth(testString);
        double average = width / (double)testString.length();
        return average;
    }

    protected static final int getScreenResolution(Component c) {
        if (c == null) {
            return UnitConversion.getDefaultScreenResolution();
        }
        Toolkit toolkit = c.getToolkit();
        return toolkit != null ? UnitConversion.getScreenResolutionSafe(toolkit) : UnitConversion.getDefaultScreenResolution();
    }

    private static final int getDefaultScreenResolution() {
        if (defaultScreenResolution == -1) {
            defaultScreenResolution = UnitConversion.getScreenResolutionSafe();
        }
        return defaultScreenResolution;
    }

    public static final int getScreenResolutionSafe(Toolkit toolkit) {
        try {
            return toolkit.getScreenResolution();
        }
        catch (Throwable t) {
            log.warn(String.format("unable to determine resolution in DPI: '%s', using default: %f", t.getMessage(), 72.0));
            return 72;
        }
    }

    public static final int getScreenResolutionSafe() {
        return UnitConversion.getScreenResolutionSafe(Toolkit.getDefaultToolkit());
    }

    public static double calcDPIFactorFromScreen(double requestedDPI) {
        return (double)UnitConversion.getScreenResolutionSafe() / requestedDPI;
    }

    private UnitConversion() {
    }
}

