/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.util.gui.treetable;

import java.util.ArrayList;
import java.util.List;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.TreePath;

public class TreeTableNode
extends DefaultMutableTreeNode {
    private Object oUserData;
    private String toolTip;
    private final List<Object> vColumns = new ArrayList<Object>();
    private boolean bDnDSelected = false;
    private boolean bEditable = true;
    private JTree jTree;
    private DefaultTreeModel defTreeMod;

    public TreeTableNode() {
        this("");
    }

    public TreeTableNode(String text) {
        this(text, null);
    }

    public TreeTableNode(String text, Object data) {
        this.setText(text);
        this.setUserData(data);
    }

    public void setEditable(boolean yesno) {
        this.bEditable = yesno;
    }

    public boolean isEditable() {
        return this.bEditable;
    }

    public TreeTableNode duplicate() {
        TreeTableNode node = this.getNewInstance();
        this.copyTo(node);
        for (int i = 0; i < this.getChildCount(); ++i) {
            node.add(this.getChild(i).duplicate());
        }
        return node;
    }

    public void copyTo(TreeTableNode node) {
        node.toolTip = this.toolTip;
        node.setText(this.getText());
    }

    public final void setText(String text) {
        this.setUserObject(text);
    }

    public String getText() {
        return (String)this.getUserObject();
    }

    public final void setUserData(Object data) {
        this.oUserData = data;
    }

    public Object getUserData() {
        return this.oUserData;
    }

    public TreeTableNode addChild(TreeTableNode node) {
        return this.addChild(node, true);
    }

    public TreeTableNode addChild(TreeTableNode node, boolean select) {
        if (this.tree() != null) {
            this.model().insertNodeInto(node, this, this.getChildCount());
            if (select) {
                node.select();
            }
        } else {
            this.add(node);
        }
        return this;
    }

    public TreeTableNode removeChild(TreeTableNode node) {
        if (this.model() != null) {
            this.model().removeNodeFromParent(node);
        } else {
            this.remove(node);
        }
        return this;
    }

    public void insertChild(TreeTableNode node, int pos) {
        this.insertChild(node, pos, true);
    }

    public void insertChild(TreeTableNode node, int pos, boolean select) {
        if (this.tree() != null) {
            this.model().insertNodeInto(node, this, pos);
            if (select) {
                node.select();
            }
        } else {
            this.insert(node, pos);
        }
    }

    public void refresh() {
        this.model().nodeChanged(this);
    }

    public void refreshIcon() {
        this.model().nodeStructureChanged(this.getParent());
        this.select();
    }

    public void recalcChildren() {
        if (this.model() != null) {
            this.model().nodeStructureChanged(this);
        }
    }

    public void select() {
        JTree tree = this.tree();
        if (tree == null) {
            return;
        }
        TreePath p = new TreePath(this.getPath());
        tree.setSelectionPath(p);
        tree.scrollPathToVisible(p);
    }

    public void makeVisible() {
        TreePath p = new TreePath(this.getPath());
        this.tree().scrollPathToVisible(p);
    }

    public boolean isSelected() {
        JTree tree = this.tree();
        if (tree == null) {
            return false;
        }
        return this == (TreeTableNode)tree.getLastSelectedPathComponent();
    }

    public void expand(boolean yesno) {
        if (yesno) {
            this.tree().expandPath(new TreePath(this.getPath()));
        } else {
            this.tree().collapsePath(new TreePath(this.getPath()));
        }
    }

    public void expand(boolean yesno, int levels) {
        this.expand(yesno, levels, this);
    }

    private void expand(boolean yesno, int levels, TreeTableNode node) {
        node.expand(yesno);
        if (levels > 0) {
            for (int i = 0; i < node.getChildCount(); ++i) {
                this.expand(yesno, levels - 1, node.getChild(i));
            }
        }
    }

    public boolean isExpanded() {
        JTree tree = this.tree();
        if (tree == null) {
            return false;
        }
        return tree.isExpanded(new TreePath(this.getPath()));
    }

    public TreeTableNode getChild(int index) {
        return (TreeTableNode)this.getChildAt(index);
    }

    public void swapNodes(int i, int j) {
        if (i == j) {
            return;
        }
        if (i < 0 || i >= this.getChildCount()) {
            return;
        }
        if (j < 0 || j >= this.getChildCount()) {
            return;
        }
        TreeTableNode node1 = (TreeTableNode)this.getChildAt(i);
        TreeTableNode node2 = (TreeTableNode)this.getChildAt(j);
        this.children.setElementAt(node2, i);
        this.children.setElementAt(node1, j);
        int[] a = new int[]{i, j};
        if (this.model() != null) {
            this.model().nodesChanged(this, a);
        }
        node1.recalcChildren();
        node2.recalcChildren();
    }

    public void swapNodes(TreeTableNode iNode, TreeTableNode jNode) {
        int i = this.getIndex(iNode);
        int j = this.getIndex(jNode);
        this.swapNodes(i, j);
    }

    public void sortChildren() {
        boolean bChanged = true;
        while (bChanged) {
            bChanged = false;
            for (int i = 0; i < this.getChildCount() - 1; ++i) {
                TreeTableNode node1 = this.getChild(i);
                TreeTableNode node2 = this.getChild(i + 1);
                if (node1.getText().compareToIgnoreCase(node2.getText()) <= 0) continue;
                bChanged = true;
                this.children.setElementAt(node2, i);
                this.children.setElementAt(node1, i + 1);
            }
        }
        this.recalcChildren();
    }

    public void textChanged() {
    }

    public void nodeWillExpand(TreeExpansionEvent e) throws ExpandVetoException {
    }

    public void nodeWillCollapse(TreeExpansionEvent e) throws ExpandVetoException {
    }

    public void setToolTipText(String tip) {
        this.toolTip = tip;
    }

    public String getToolTipText() {
        return this.toolTip;
    }

    public void setTree(JTree tree) {
        this.jTree = tree;
        this.defTreeMod = tree == null ? null : (DefaultTreeModel)tree.getModel();
    }

    public JTree getTree() {
        return this.tree();
    }

    public void addColumn(Object o) {
        this.vColumns.add(o);
    }

    public void removeColumn(int index) {
        this.vColumns.remove(index);
    }

    public Object getColumnAt(int index) {
        return this.vColumns.get(index);
    }

    public void setColumnAt(Object obj, int index) {
        this.vColumns.set(index, obj);
    }

    protected TreeTableNode getNewInstance() {
        return new TreeTableNode();
    }

    private JTree tree() {
        return ((TreeTableNode)this.getRoot()).jTree;
    }

    private DefaultTreeModel model() {
        return ((TreeTableNode)this.getRoot()).defTreeMod;
    }

    void setDnDSelection(boolean yesno) {
        this.bDnDSelected = yesno;
    }

    boolean isDndSelected() {
        return this.bDnDSelected;
    }
}

