/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.util.gui.treetable;

import java.awt.Component;
import java.awt.Graphics;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.table.TableCellRenderer;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;

class TreeTableCellRenderer
extends JTree
implements TableCellRenderer {
    private int visibleRow;
    private JTable jTable;

    public TreeTableCellRenderer(TreeNode node) {
        super(node);
    }

    @Override
    public void updateUI() {
        super.updateUI();
        TreeCellRenderer tcr = this.getCellRenderer();
        if (tcr instanceof DefaultTreeCellRenderer) {
            DefaultTreeCellRenderer dtcr = (DefaultTreeCellRenderer)tcr;
            dtcr.setBorderSelectionColor(null);
            dtcr.setTextSelectionColor(UIManager.getColor("Table.selectionForeground"));
            dtcr.setBackgroundSelectionColor(UIManager.getColor("Table.selectionBackground"));
        }
    }

    @Override
    public void setBounds(int x, int y, int w, int h) {
        super.setBounds(x, 0, w, this.jTable.getHeight());
    }

    @Override
    public void paint(Graphics g) {
        g.translate(0, -this.visibleRow * this.getRowHeight());
        super.paint(g);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (isSelected) {
            this.setBackground(table.getSelectionBackground());
        } else {
            this.setBackground(table.getBackground());
        }
        this.visibleRow = row;
        return this;
    }

    public void setTable(JTable table) {
        this.jTable = table;
    }
}

