/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.util.gui.treetable;

import de.riwagis.util.Config;
import de.riwagis.util.gui.treetable.TreeTableCellEditor;
import de.riwagis.util.gui.treetable.TreeTableCellRenderer;
import de.riwagis.util.gui.treetable.TreeTableColumn;
import de.riwagis.util.gui.treetable.TreeTableEditor;
import de.riwagis.util.gui.treetable.TreeTableNode;
import de.riwagis.util.gui.treetable.TreeTableSelEvent;
import de.riwagis.util.gui.treetable.TreeTableSelListener;
import de.riwagis.util.i18n.I18N;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseListener;
import java.util.Enumeration;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.event.EventListenerList;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableModel;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TreeTable
extends JScrollPane
implements TableModel,
ListSelectionListener,
TreeModelListener,
TreeSelectionListener,
TreeExpansionListener {
    private static final Logger LOG = LoggerFactory.getLogger(TreeTable.class);
    private static I18N i18n = new I18N(Config.LOCALE, "de.riwagis.util.gui.i18n");
    private static final long serialVersionUID = -1366382898068584881L;
    private JTable jTable;
    private TreeTableCellRenderer jTree;
    private TreeTableCellEditor jTreeEditor;
    private DefaultTreeModel defTreeMod;
    private final DefaultTableColumnModel columnModel = new DefaultTableColumnModel();
    private final EventListenerList listList = new EventListenerList();
    private boolean bEditable = false;
    private final JPopupMenu pMenu = new JPopupMenu();

    public TreeTable() {
        this(false);
    }

    public TreeTable(boolean editable) {
        this.bEditable = editable;
        TreeTableNode rootNode = new TreeTableNode();
        this.defTreeMod = new DefaultTreeModel(rootNode);
        this.defTreeMod.addTreeModelListener(this);
        this.jTree = new TreeTableCellRenderer(rootNode);
        this.jTree.getSelectionModel().setSelectionMode(1);
        this.jTree.addTreeSelectionListener(this);
        this.jTree.addTreeExpansionListener(this);
        this.jTree.setShowsRootHandles(true);
        this.jTree.setRootVisible(false);
        this.jTree.setEditable(false);
        this.jTree.setModel(this.defTreeMod);
        this.jTree.putClientProperty("JTree.lineStyle", "Angled");
        ToolTipManager.sharedInstance().registerComponent(this.jTree);
        this.jTree.setRowHeight(18);
        this.jTable = new JTable(this, this.columnModel);
        this.jTable.setSelectionMode(0);
        this.jTable.setRowHeight(this.jTree.getRowHeight());
        this.jTable.setTableHeader(new JTableHeader(this.columnModel));
        this.setViewportView(this.jTable);
        ListSelectionModel lsm = this.jTable.getSelectionModel();
        lsm.addListSelectionListener(this);
        LookAndFeel.installColorsAndFont(this.jTable, "Tree.background", "Tree.foreground", "Tree.font");
        this.jTree.setTable(this.jTable);
        this.jTreeEditor = new TreeTableCellEditor();
        this.jTreeEditor.setTree(this.jTree);
        JMenuItem menuItem = new JMenuItem(i18n.get("common.copy"));
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    StringSelection stringSelection = new StringSelection(TreeTable.this.jTable.getValueAt(TreeTable.this.jTable.getSelectedRow(), TreeTable.this.jTable.getSelectedColumn()).toString());
                    Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                    clipboard.setContents(stringSelection, new ClipboardOwner(){

                        @Override
                        public void lostOwnership(Clipboard aClipboard, Transferable aContents) {
                        }
                    });
                }
                catch (Exception exp) {
                    LOG.warn(String.format("error: %s", exp.getMessage()), (Throwable)exp);
                }
            }
        });
        this.pMenu.add(menuItem);
        this.jTable.setComponentPopupMenu(this.pMenu);
    }

    public TreeTableColumn addHeader(String label, int width) {
        return this.addHeader(label, width, true);
    }

    public TreeTableColumn addHeader(String label, int width, boolean editable) {
        int modelIndex = this.columnModel.getColumnCount();
        TreeTableColumn ftc = new TreeTableColumn(label, width);
        ftc.setEditable(editable);
        ftc.setModelIndex(modelIndex);
        this.columnModel.addColumn(ftc);
        if (modelIndex == 0) {
            this.jTree.setEditable(editable);
            ftc.setCellRenderer(this.jTree);
            ftc.setCellEditor(this.jTreeEditor);
        }
        return ftc;
    }

    public TreeTableColumn addHeader(String label, int width, JButton button) {
        TreeTableColumn ftc = this.addHeader(label, width, true);
        ftc.setCellEditor(new TreeTableEditor(button));
        return ftc;
    }

    public void addPopupMenuItem(JMenuItem menuItem) {
        this.pMenu.add(menuItem);
    }

    public void addPopupMenuSeparator() {
        this.pMenu.addSeparator();
    }

    public void setRootNode(TreeTableNode root) {
        TreeTableNode oldRoot = this.getRootNode();
        if (oldRoot != null) {
            oldRoot.setTree(null);
        }
        root.setTree(this.jTree);
        this.defTreeMod.setRoot(root);
        this.updateTable();
    }

    public TreeTableNode getRootNode() {
        return (TreeTableNode)this.defTreeMod.getRoot();
    }

    public void setRootVisible(boolean yesno) {
        this.jTree.setRootVisible(yesno);
    }

    public void expandAll(boolean expand) {
        TreeNode root = (TreeNode)this.jTree.getModel().getRoot();
        this.expandAll(new TreePath(root), expand);
    }

    private void expandAll(TreePath parent, boolean expand) {
        TreeNode node = (TreeNode)parent.getLastPathComponent();
        if (node.getChildCount() >= 0) {
            Enumeration<? extends TreeNode> e = node.children();
            while (e.hasMoreElements()) {
                TreeNode n = e.nextElement();
                TreePath path = parent.pathByAddingChild(n);
                this.expandAll(path, expand);
            }
        }
        if (expand) {
            this.jTree.expandPath(parent);
        } else {
            this.jTree.collapsePath(parent);
        }
    }

    public TreeTableNode getSelectedNode() {
        return (TreeTableNode)this.jTree.getLastSelectedPathComponent();
    }

    public void clearSelection() {
        this.jTree.clearSelection();
    }

    public void setTreeCellRenderer(TreeCellRenderer tcr) {
        this.jTree.setCellRenderer(tcr);
    }

    public void setEditable(boolean yesno) {
        this.bEditable = yesno;
    }

    public void addSelectionListener(TreeTableSelListener l) {
        this.listList.add(TreeTableSelListener.class, l);
    }

    public void removeSelectionListener(TreeTableSelListener l) {
        this.listList.remove(TreeTableSelListener.class, l);
    }

    public void fireNodeSelected(TreeTableNode node) {
        Object[] listeners = this.listList.getListenerList();
        TreeTableSelEvent e = new TreeTableSelEvent(this, node);
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != TreeTableSelListener.class) continue;
            ((TreeTableSelListener)listeners[i + 1]).nodeSelected(e);
        }
    }

    public void fireTableCellUpdated(int row, int column) {
        TableModelEvent e = new TableModelEvent(this, row, row, column);
        Object[] listeners = this.listList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != TableModelListener.class) continue;
            ((TableModelListener)listeners[i + 1]).tableChanged(e);
        }
    }

    public TreeTableNode getNodeFromRow(int row) {
        return (TreeTableNode)this.jTree.getPathForRow(row).getLastPathComponent();
    }

    public void setRowHeight(int rowHeight) {
        this.jTable.setRowHeight(rowHeight);
        this.jTree.setRowHeight(this.jTable.getRowHeight());
    }

    @Override
    public void addTableModelListener(TableModelListener l) {
        this.listList.add(TableModelListener.class, l);
    }

    @Override
    public void removeTableModelListener(TableModelListener l) {
        this.listList.remove(TableModelListener.class, l);
    }

    @Override
    public Class<?> getColumnClass(int index) {
        if (index == 0) {
            return TreeTableNode.class;
        }
        TreeTableNode node = this.getRootNode();
        if (node == null) {
            return String.class;
        }
        return node.getColumnAt(index - 1).getClass();
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        if (col == 0) {
            return true;
        }
        if (!this.bEditable) {
            return false;
        }
        return ((TreeTableColumn)this.columnModel.getColumn(col)).isEditable();
    }

    @Override
    public int getColumnCount() {
        return this.columnModel.getColumnCount();
    }

    @Override
    public String getColumnName(int index) {
        return (String)this.columnModel.getColumn(index).getHeaderValue();
    }

    @Override
    public int getRowCount() {
        return this.jTree.getRowCount();
    }

    @Override
    public Object getValueAt(int row, int col) {
        TreeTableNode node = this.getNodeFromRow(row);
        if (col == 0) {
            return node.getText();
        }
        return node.getColumnAt(col - 1);
    }

    @Override
    public void setValueAt(Object v, int row, int col) {
        if (col == 0) {
            throw new IllegalArgumentException("Error, col is zero !");
        }
        this.getNodeFromRow(row).setColumnAt(v, col - 1);
        this.fireTableCellUpdated(row, col);
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        ListSelectionModel lsm = (ListSelectionModel)e.getSource();
        if (lsm.isSelectionEmpty()) {
            this.jTree.clearSelection();
            this.fireNodeSelected(null);
        } else {
            TreeTableNode node = this.getNodeFromRow(lsm.getMinSelectionIndex());
            node.select();
            this.fireNodeSelected(node);
        }
    }

    @Override
    public void treeNodesChanged(TreeModelEvent e) {
        TreeTableNode node = (TreeTableNode)e.getTreePath().getLastPathComponent();
        int[] indexes = e.getChildIndices();
        if (indexes != null) {
            node = node.getChild(indexes[0]);
        }
        node.textChanged();
        this.delayedFireTableDataChanged();
    }

    @Override
    public void treeNodesInserted(TreeModelEvent e) {
        this.delayedFireTableDataChanged();
    }

    @Override
    public void treeNodesRemoved(TreeModelEvent e) {
        this.delayedFireTableDataChanged();
    }

    @Override
    public void treeStructureChanged(TreeModelEvent e) {
        this.delayedFireTableDataChanged();
    }

    private void delayedFireTableDataChanged() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TreeTable.this.updateTable();
            }
        });
    }

    public void addTableMouseListener(MouseListener l) {
        this.jTable.addMouseListener(l);
    }

    public void removeTableMouseListener(MouseListener l) {
        this.jTable.removeMouseListener(l);
    }

    @Override
    public void treeExpanded(TreeExpansionEvent event) {
        this.updateTable();
    }

    @Override
    public void treeCollapsed(TreeExpansionEvent event) {
        this.updateTable();
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        TreeTableNode node = (TreeTableNode)this.jTree.getLastSelectedPathComponent();
        this.fireNodeSelected(node);
        if (node != null) {
            int row = this.jTree.getRowForPath(new TreePath(node));
            if (row != -1) {
                this.jTable.setRowSelectionInterval(row, row);
            }
        } else {
            this.jTable.clearSelection();
        }
    }

    private void updateTable() {
        this.jTable.revalidate();
        this.jTable.repaint();
    }

    public JTable getTable() {
        return this.jTable;
    }
}

