/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.util.gui.toast;

import de.riwagis.util.gui.toast.ToastColorModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.RoundRectangle2D;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.Timer;
import javax.swing.border.EmptyBorder;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.WordUtils;

public class ToastMessage
extends JFrame {
    private final float MAX_OPACITY = 0.9f;
    private final float OPACITY_INCREMENT = 0.05f;
    private final int FADE_REFRESH_RATE = 20;
    private final int WINDOW_RADIUS = 15;
    private final int DISTANCE_FROM_PARENT_BOTTOM = 100;
    private final JLabel label;

    private ToastMessage(JFrame owner, String toastText) {
        this.setTitle("Transparent Toast");
        BorderLayout layout = new BorderLayout(5, 5);
        this.setLayout(layout);
        this.setDefaultCloseOperation(3);
        this.setUndecorated(true);
        this.setFocusableWindowState(false);
        String newLine = "<br>";
        if (!StringUtils.startsWithIgnoreCase((CharSequence)toastText, (CharSequence)"<html>")) {
            toastText = "<html>" + ((String)toastText).replace("\n", "<br>").replace("\r", "") + "</html>";
        }
        toastText = WordUtils.wrap((String)toastText, (int)150, (String)newLine, (boolean)true);
        this.label = new JLabel((String)toastText);
        this.label.setOpaque(false);
        EmptyBorder margin = new EmptyBorder(10, 10, 10, 10);
        this.label.setBorder(margin);
        this.add((Component)this.label, "Center");
        this.pack();
        Dimension messageDim = this.getSize();
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        double xstart = 0.0;
        double ystart = 0.0;
        if (owner != null) {
            dimension = owner.getSize();
            xstart = owner.getLocation().getX();
            ystart = owner.getLocation().getY();
        }
        int x = (int)(xstart + dimension.getWidth() / 2.0 - messageDim.getWidth() / 2.0);
        int y = (int)(ystart + dimension.getHeight() - Math.max(100.0, messageDim.getHeight() + 50.0));
        this.setLocation(new Point(x, y));
        this.setShape(new RoundRectangle2D.Double(0.0, 0.0, this.getWidth(), this.getHeight(), 15.0, 15.0));
    }

    private void fadeIn() {
        this.setOpacity(0.0f);
        this.setVisible(true);
        final Timer timer = new Timer(20, null);
        timer.setRepeats(true);
        timer.addActionListener(new ActionListener(){
            private float opacity = 0.0f;

            @Override
            public void actionPerformed(ActionEvent e) {
                this.opacity += 0.05f;
                ToastMessage.this.setOpacity(Math.min(this.opacity, 0.9f));
                if (this.opacity >= 0.9f) {
                    timer.stop();
                }
            }
        });
        timer.start();
    }

    private void fadeOut() {
        final Timer timer = new Timer(20, null);
        timer.setRepeats(true);
        timer.addActionListener(new ActionListener(){
            private float opacity = 0.9f;

            @Override
            public void actionPerformed(ActionEvent e) {
                this.opacity -= 0.05f;
                ToastMessage.this.setOpacity(Math.max(this.opacity, 0.0f));
                if (this.opacity <= 0.0f) {
                    timer.stop();
                    ToastMessage.this.setVisible(false);
                    ToastMessage.this.dispose();
                }
            }
        });
        this.setOpacity(0.9f);
        timer.start();
    }

    public static void makeToast(JFrame owner, String toastText, int durationSec, ToastColorModel colorModel) {
        new Thread(() -> {
            try {
                ToastMessage toastFrame = new ToastMessage(owner, toastText);
                toastFrame.label.setForeground(colorModel.getTextColor());
                toastFrame.getContentPane().setBackground(colorModel.getBackgroundColor());
                toastFrame.fadeIn();
                Thread.sleep(durationSec * 1000);
                toastFrame.fadeOut();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }).start();
    }

    public static void main(String[] args) {
        final JFrame frame = new JFrame("Cloud Tester");
        frame.setDefaultCloseOperation(3);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(0));
        JButton toastButton = new JButton("show toast");
        jPanel.add(toastButton);
        toastButton.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ToastMessage.makeToast(frame, "A toast with a very long text with linebreak\nnext line with some additional text asdfasdfasdf asdfasdfasdf asdfasdfasdf asdfasdfasdf asdfasdfasdf asdfasdfasdf asdfasdfasdf asdfasdfasdf asdfasdfasdf asdfasdfasdf asdfasdfasdf!", 3, ToastColorModel.ERROR_DARK);
                ToastMessage.makeToast(null, "<html>a toast with a very long text with linebreak<br>next line with some additional text asdfasdfasdf asdfasdfasdf asdfasdfasdf asdfasdfasdf asdfasdfasdf asdfasdfasdf asdfasdfasdf asdfasdfasdf asdfasdfasdf asdfasdfasdf asdfasdfasdf!</html>", 3, ToastColorModel.ERROR_DARK);
            }
        });
        frame.add(jPanel);
        frame.setSize(800, 600);
        frame.setVisible(true);
    }
}

