/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.util.gui.test;

import de.riwagis.util.gui.GUISupport;
import de.riwagis.util.gui.test.FileFilterConst;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GUISupportTest
extends JPanel {
    private static final Logger LOG = LoggerFactory.getLogger(GUISupportTest.class);
    private JButton bntCenterWindow;
    private JButton btnCancel;
    private JButton btnClose;
    private JButton btnOK;
    private JButton btnOpenInputBox;
    private JButton btnSelectDirectory;
    private JButton btnSelectDirectory1;
    private JTextField edtInput;
    private JPanel jPanel1;
    private JLabel lblCenterWindow;
    private JLabel lblDefaultButtons;
    private JLabel lblInput;
    private JLabel lblOpenChooseDirectory;
    private JLabel lblOpenChooseDirectory1;
    private JLabel lblOpenInputBox;
    private JPanel pnlButtons;
    private JPanel pnlInput;

    public GUISupportTest() {
        this.initComponents();
        GUISupport.setDefaultButton(this.btnOK, 10);
        GUISupport.setDefaultButton(this.btnCancel, 27);
    }

    private void initComponents() {
        this.pnlInput = new JPanel();
        this.lblInput = new JLabel();
        this.edtInput = new JTextField();
        this.lblCenterWindow = new JLabel();
        this.bntCenterWindow = new JButton();
        this.lblOpenInputBox = new JLabel();
        this.btnOpenInputBox = new JButton();
        this.lblOpenChooseDirectory = new JLabel();
        this.btnSelectDirectory = new JButton();
        this.lblOpenChooseDirectory1 = new JLabel();
        this.btnSelectDirectory1 = new JButton();
        this.jPanel1 = new JPanel();
        this.lblDefaultButtons = new JLabel();
        this.pnlButtons = new JPanel();
        this.btnOK = new JButton();
        this.btnCancel = new JButton();
        this.btnClose = new JButton();
        this.setLayout(new GridBagLayout());
        this.pnlInput.setBorder(BorderFactory.createTitledBorder("Eingabe"));
        this.pnlInput.setMinimumSize(new Dimension(400, 400));
        this.pnlInput.setLayout(new GridBagLayout());
        this.lblInput.setLabelFor(this.edtInput);
        this.lblInput.setText("Bitte irgendwas eingeben:");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 5, 3, 6);
        this.pnlInput.add((Component)this.lblInput, gridBagConstraints);
        this.edtInput.setText("irgendwas halt...");
        this.edtInput.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                GUISupportTest.this.edtInputMouseClicked(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 5, 3, 5);
        this.pnlInput.add((Component)this.edtInput, gridBagConstraints);
        this.lblCenterWindow.setText("Dialog zentrieren:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 5, 3, 6);
        this.pnlInput.add((Component)this.lblCenterWindow, gridBagConstraints);
        this.bntCenterWindow.setText("Dialog zentrieren");
        this.bntCenterWindow.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GUISupportTest.this.bntCenterWindowActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 5, 3, 5);
        this.pnlInput.add((Component)this.bntCenterWindow, gridBagConstraints);
        this.lblOpenInputBox.setText("Eingabe in Fenster:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 5, 3, 6);
        this.pnlInput.add((Component)this.lblOpenInputBox, gridBagConstraints);
        this.btnOpenInputBox.setText("Inputfenster");
        this.btnOpenInputBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GUISupportTest.this.btnOpenInputBoxActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 5, 3, 5);
        this.pnlInput.add((Component)this.btnOpenInputBox, gridBagConstraints);
        this.lblOpenChooseDirectory.setText("Verzeichnis w\u00e4hlen:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 5, 3, 6);
        this.pnlInput.add((Component)this.lblOpenChooseDirectory, gridBagConstraints);
        this.btnSelectDirectory.setText("Verzeichnis w\u00e4hlen");
        this.btnSelectDirectory.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GUISupportTest.this.btnSelectDirectoryActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 5, 3, 5);
        this.pnlInput.add((Component)this.btnSelectDirectory, gridBagConstraints);
        this.lblOpenChooseDirectory1.setText("Datei zum speichern:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 5, 3, 6);
        this.pnlInput.add((Component)this.lblOpenChooseDirectory1, gridBagConstraints);
        this.btnSelectDirectory1.setText("Datei speichern");
        this.btnSelectDirectory1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GUISupportTest.this.btnSelectDirectory1ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 5, 3, 5);
        this.pnlInput.add((Component)this.btnSelectDirectory1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(6, 6, 6, 6);
        this.add((Component)this.pnlInput, gridBagConstraints);
        this.jPanel1.setBorder(BorderFactory.createEtchedBorder());
        this.jPanel1.setLayout(new GridBagLayout());
        this.lblDefaultButtons.setText("Diese Buttons sind als Default belegt. ESC f\u00fchrt Cancel auf, ENTER f\u00fchrt OK aus.");
        this.lblDefaultButtons.setHorizontalTextPosition(4);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 3, 2, 3);
        this.jPanel1.add((Component)this.lblDefaultButtons, gridBagConstraints);
        this.pnlButtons.setLayout(new GridBagLayout());
        this.btnOK.setText("OK");
        this.btnOK.setMaximumSize(null);
        this.btnOK.setMinimumSize(null);
        this.btnOK.setPreferredSize(null);
        this.btnOK.setSelected(true);
        this.btnOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GUISupportTest.this.btnOKActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pnlButtons.add((Component)this.btnOK, gridBagConstraints);
        this.btnCancel.setText("Cancel");
        this.btnCancel.setMaximumSize(null);
        this.btnCancel.setMinimumSize(null);
        this.btnCancel.setPreferredSize(null);
        this.btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GUISupportTest.this.btnCancelActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pnlButtons.add((Component)this.btnCancel, gridBagConstraints);
        this.btnClose.setText("Close");
        this.btnClose.setMaximumSize(null);
        this.btnClose.setMinimumSize(null);
        this.btnClose.setPreferredSize(null);
        this.btnClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GUISupportTest.this.btnCloseActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 20, 3, 3);
        this.pnlButtons.add((Component)this.btnClose, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 6, 6, 6);
        this.jPanel1.add((Component)this.pnlButtons, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 6, 6, 6);
        this.add((Component)this.jPanel1, gridBagConstraints);
    }

    private void btnOKActionPerformed(ActionEvent evt) {
        JOptionPane.showMessageDialog(this, String.format("OK: %s", this.edtInput.getText()));
    }

    private void btnCancelActionPerformed(ActionEvent evt) {
        JOptionPane.showMessageDialog(this, String.format("CANCEL: %s", this.edtInput.getText()));
    }

    private void bntCenterWindowActionPerformed(ActionEvent evt) {
        GUISupport.centreOnScreen(GUISupport.findParentWindow(this));
    }

    private void btnCloseActionPerformed(ActionEvent evt) {
        JOptionPane.showMessageDialog(this, String.format("CLOSE: %s", this.edtInput.getText()));
        GUISupport.findParentWindow(this).setVisible(false);
    }

    private void btnOpenInputBoxActionPerformed(ActionEvent evt) {
        String input = GUISupport.inputbox((Component)this.btnOpenInputBox, String.format("Neuer Text ('%s')", this.edtInput.getText()), "Neue Eingabe", this.edtInput.getText());
        if (input != null) {
            this.edtInput.setText(input);
        } else if (GUISupport.yesnobox(this.btnOpenInputBox, "Eingabefeld l\u00f6schen?", "Abgebrochen")) {
            this.edtInput.setText(input);
        }
    }

    private void edtInputMouseClicked(MouseEvent evt) {
        if (evt.getButton() == 1 && evt.getClickCount() == 2) {
            GUISupport.msgbox(this.edtInput, String.format("Eingabe: '%s'", this.edtInput.getText()), "bisherige Eingabe");
        }
    }

    private void btnSelectDirectoryActionPerformed(ActionEvent evt) {
        File f;
        File initialPath = new File(this.edtInput.getText());
        if (!initialPath.isDirectory()) {
            initialPath = null;
        }
        if ((f = GUISupport.chooseDirectory(this, "Verzeichnis w\u00e4hlen", initialPath)) != null) {
            GUISupport.msgbox(this.edtInput, String.format("Eingabe: '%s'", f.getAbsolutePath()), "Verzeichnis");
            this.edtInput.setText(f.getAbsolutePath());
        } else {
            GUISupport.msgbox(this.edtInput, String.format("Verzeichnisdialog abgebrochen (Eingabe: '%s')", f), "Verzeichnis");
        }
        LOG.info(String.format("gew\u00e4hltes Verzeichnis: '%s'", f));
    }

    private void btnSelectDirectory1ActionPerformed(ActionEvent evt) {
        File prevFile = new File(this.edtInput.getText());
        List<FileFilter> extensions = Arrays.asList(FileFilterConst.FILTER_EXCEL, FileFilterConst.FILTER_WORD, FileFilterConst.FILTER_JPG, FileFilterConst.FILTER_PDF, FileFilterConst.FILTER_PNG, FileFilterConst.FILTER_TXT, FileFilterConst.FILTER_CSV);
        File f = GUISupport.saveFile((Component)this, "Datei speichern", extensions, prevFile, true);
        if (f != null) {
            GUISupport.msgbox(this.edtInput, String.format("Eingabe: '%s'", f.getAbsolutePath()), "Datei speichern");
            this.edtInput.setText(f.getAbsolutePath());
        } else {
            GUISupport.msgbox(this.edtInput, String.format("Datei speichern abgebrochen (Eingabe: '%s')", f), "Datei speichern");
        }
        LOG.info(String.format("gew\u00e4hlte Datei zum Speichern: '%s'", f));
    }

    public static final void main(String ... args) {
        JDialog dlg = new JDialog((Frame)null, true);
        try {
            GUISupportTest p = new GUISupportTest();
            dlg.add(p);
            dlg.pack();
            GUISupport.centreOnScreen(dlg);
            dlg.setVisible(true);
        }
        finally {
            dlg.dispose();
        }
    }
}

