/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.util.gui.test;

import de.riwagis.util.file.ResourceSupport;
import de.riwagis.util.gui.GUISupport;
import de.riwagis.util.gui.OSFile;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileSupportTestGUI
extends JPanel {
    private static final Logger LOG = LoggerFactory.getLogger(FileSupportTestGUI.class);
    private static final List<String> filenames = Arrays.asList("file    png.png", "file    jpg.jpg", "file    html.html", "file    text.txt");
    private final List<File> files = new ArrayList<File>();
    private final ListCellRenderer<File> myRenderer = new ListCellRenderer<File>(){
        private final DefaultListCellRenderer dflr = new DefaultListCellRenderer();

        @Override
        public Component getListCellRendererComponent(JList<? extends File> list, File value, int index, boolean isSelected, boolean cellHasFocus) {
            return this.dflr.getListCellRendererComponent(list, value.getName(), index, isSelected, cellHasFocus);
        }
    };
    private JButton btnClose;
    private JButton btnShowFile;
    private JComboBox cbxFilename;
    private JPanel jPanel1;
    private JLabel lblDefaultButtons;
    private JLabel lblInput;
    private JPanel pnlButtons;
    private JPanel pnlInput;

    public FileSupportTestGUI() throws IOException {
        this.initComponents();
        GUISupport.setDefaultButton(this.btnShowFile, 10);
        GUISupport.setDefaultButton(this.btnClose, 27);
        for (String currFile : filenames) {
            this.files.add(ResourceSupport.copyResourceFileToTempFile((String)String.format("%s/%s", "/de/riwagis/util/gui/test", currFile)));
        }
        this.cbxFilename.setRenderer(this.myRenderer);
        this.cbxFilename.setModel(new DefaultComboBoxModel<Object>(this.files.toArray()));
    }

    protected void finalize() throws Throwable {
        for (File currFile : this.files) {
            FileUtils.deleteQuietly((File)currFile);
        }
        super.finalize();
    }

    private void initComponents() {
        this.pnlInput = new JPanel();
        this.lblDefaultButtons = new JLabel();
        this.lblInput = new JLabel();
        this.cbxFilename = new JComboBox();
        this.btnShowFile = new JButton();
        this.jPanel1 = new JPanel();
        this.pnlButtons = new JPanel();
        this.btnClose = new JButton();
        this.setLayout(new GridBagLayout());
        this.pnlInput.setBorder(BorderFactory.createTitledBorder("Eingabe"));
        this.pnlInput.setMinimumSize(new Dimension(400, 400));
        this.pnlInput.setLayout(new GridBagLayout());
        this.lblDefaultButtons.setText("<html><body>W\u00e4hlen Sie hier eine Datei aus.<br>\nDie Datei wird anschliessend in dem vom Betriebssystem konfigurierten Anzeigeprogramm ge\u00f6ffnet.</body></html>");
        this.lblDefaultButtons.setHorizontalTextPosition(4);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 3, 2, 3);
        this.pnlInput.add((Component)this.lblDefaultButtons, gridBagConstraints);
        this.lblInput.setLabelFor(this.cbxFilename);
        this.lblInput.setText("Datei:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 5, 3, 6);
        this.pnlInput.add((Component)this.lblInput, gridBagConstraints);
        this.cbxFilename.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.cbxFilename.setRenderer(this.myRenderer);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.pnlInput.add((Component)this.cbxFilename, gridBagConstraints);
        this.btnShowFile.setText("Anzeigen");
        this.btnShowFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FileSupportTestGUI.this.btnShowFileActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 5, 3, 5);
        this.pnlInput.add((Component)this.btnShowFile, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(6, 6, 6, 6);
        this.add((Component)this.pnlInput, gridBagConstraints);
        this.jPanel1.setBorder(BorderFactory.createEtchedBorder());
        this.jPanel1.setLayout(new GridBagLayout());
        this.pnlButtons.setLayout(new GridBagLayout());
        this.btnClose.setText("Close");
        this.btnClose.setMaximumSize(null);
        this.btnClose.setMinimumSize(null);
        this.btnClose.setPreferredSize(null);
        this.btnClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FileSupportTestGUI.this.btnCloseActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 20, 3, 3);
        this.pnlButtons.add((Component)this.btnClose, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 6, 6, 6);
        this.jPanel1.add((Component)this.pnlButtons, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 6, 6, 6);
        this.add((Component)this.jPanel1, gridBagConstraints);
    }

    private void btnCloseActionPerformed(ActionEvent evt) {
        GUISupport.findParentWindow(this).setVisible(false);
    }

    private void btnShowFileActionPerformed(ActionEvent evt) {
        File fileToShow = (File)this.cbxFilename.getSelectedItem();
        LOG.info(String.format("gew\u00e4hlte Datei: '%s'", fileToShow));
        OSFile.showFile(fileToShow, true);
    }

    public static final void main(String ... args) throws IOException {
        JDialog dlg = new JDialog((Frame)null, true);
        try {
            FileSupportTestGUI p = new FileSupportTestGUI();
            dlg.add(p);
            dlg.pack();
            GUISupport.centreOnScreen(dlg);
            dlg.setVisible(true);
        }
        finally {
            dlg.dispose();
        }
    }
}

