/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.util.gui.models;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.AbstractListModel;

public class ListListModel<V>
extends AbstractListModel<V> {
    private final boolean bolSorted;
    private final Comparator<V> comp;
    private final List<V> lstData = new ArrayList<V>();

    public ListListModel() {
        this(false, null);
    }

    public ListListModel(boolean _bolSorted, Comparator<V> _comp) {
        this.bolSorted = _bolSorted;
        this.comp = _comp;
    }

    public ListListModel(List<V> _lstData) {
        this(_lstData, false, null);
    }

    public ListListModel(List<V> _lstData, boolean _bolSorted, Comparator<V> _comp) {
        this(_bolSorted, _comp);
        this.setList(_lstData);
    }

    @Override
    public V getElementAt(int index) {
        return this.lstData.get(index);
    }

    @Override
    public int getSize() {
        return this.lstData.size();
    }

    public final void setList(List<V> _lstData) {
        this.lstData.clear();
        this.lstData.addAll(_lstData);
        if (this.bolSorted) {
            Collections.sort(this.lstData, this.comp);
        }
        this.fireContentsChanged(this, 0, this.getSize());
    }

    public List<V> getList() {
        return Collections.unmodifiableList(new ArrayList<V>(this.lstData));
    }

    public void addListObject(V obj) {
        this.addListObject(obj, this.lstData.size());
    }

    public void addListObject(V obj, int index) {
        this.lstData.add(index, obj);
        if (this.bolSorted) {
            Collections.sort(this.lstData, this.comp);
            this.fireContentsChanged(this, 0, this.getSize());
        } else {
            this.fireIntervalAdded(this, index, index);
        }
    }

    public void replaceListObject(V oldObj, V newObj) {
        int index = this.lstData.indexOf(oldObj);
        if (index == -1) {
            return;
        }
        this.lstData.set(index, newObj);
        if (this.bolSorted) {
            Collections.sort(this.lstData, this.comp);
            this.fireContentsChanged(this, 0, this.getSize());
        } else {
            this.fireContentsChanged(this, index, index);
        }
    }

    public void removeListObject(V obj) {
        int index = this.lstData.indexOf(obj);
        if (index != -1) {
            this.lstData.remove(obj);
            this.fireIntervalRemoved(this, index, index);
        }
    }
}

