/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.util.gui.models;

import de.riwagis.util.Config;
import java.text.Collator;
import org.apache.commons.lang3.ObjectUtils;

public class KeyValue<K, V>
implements Comparable<KeyValue<K, V>> {
    private final K key;
    private final V value;
    private boolean bolShowKey = false;
    private boolean bolCompareByNumber = false;

    public KeyValue(K _key, V _value) {
        this.key = _key;
        this.value = _value;
    }

    public K getKey() {
        return this.key;
    }

    public V getValue() {
        return this.value;
    }

    public void setShowKey(boolean _bolShowKey) {
        this.bolShowKey = _bolShowKey;
    }

    public void setCompareByNumber(boolean _bolCompareByNumber) {
        this.bolCompareByNumber = _bolCompareByNumber;
    }

    public String toString() {
        if (!this.bolShowKey) {
            return ObjectUtils.toString(this.value);
        }
        return ObjectUtils.toString(this.value) + " (" + ObjectUtils.toString(this.key) + ")";
    }

    public boolean equals(Object obj) {
        KeyValue kv;
        if (this.key == null || this.value == null) {
            return false;
        }
        return obj instanceof KeyValue && this.key.equals((kv = (KeyValue)obj).getKey()) && this.value.equals(kv.getValue());
    }

    public int hashCode() {
        int hash = 5;
        hash = 83 * hash + (this.key != null ? this.key.hashCode() : 0);
        hash = 83 * hash + (this.value != null ? this.value.hashCode() : 0);
        return hash;
    }

    @Override
    public int compareTo(KeyValue<K, V> objValCompare) {
        Object objCompValue;
        if (this.bolCompareByNumber) {
            return this.compareToByNumber(objValCompare);
        }
        Object objValue = this.value;
        if (objValue == null) {
            objValue = "";
        }
        if ((objCompValue = objValCompare.getValue()) == null) {
            objCompValue = "";
        }
        Collator colCompare = Collator.getInstance(Config.LOCALE);
        if (objValue.getClass().equals(objCompValue.getClass()) && objValue instanceof Comparable) {
            if (objValue instanceof String) {
                return colCompare.compare(objValue.toString().toLowerCase(), objCompValue.toString().toLowerCase());
            }
            return ((Comparable)objValue).compareTo(objCompValue);
        }
        return colCompare.compare(objValue.toString().toLowerCase(), objCompValue.toString().toLowerCase());
    }

    private int compareToByNumber(KeyValue<K, V> objValCompare) {
        double dblCompValue;
        double dblValue;
        KeyValue<K, V> kvValCompare;
        Object objCompValue;
        Object objValue = this.value;
        if (objValue == null) {
            objValue = 0;
        }
        if ((objCompValue = (kvValCompare = objValCompare).getValue()) == null) {
            objCompValue = 0;
        }
        if ((dblValue = this.getDoubleValue(objValue)) > (dblCompValue = this.getDoubleValue(objCompValue))) {
            return 1;
        }
        if (dblValue < dblCompValue) {
            return -1;
        }
        return 0;
    }

    private double getDoubleValue(Object obj) {
        if (obj == null) {
            return 0.0;
        }
        if (obj instanceof Number) {
            return ((Number)obj).doubleValue();
        }
        String strObj = obj.toString();
        double dblNum = 0.0;
        for (int i = 0; i < strObj.length(); ++i) {
            String strNum = strObj.substring(0, strObj.length() - i);
            try {
                dblNum = Double.parseDouble(strNum);
                break;
            }
            catch (NumberFormatException numberFormatException) {
                continue;
            }
        }
        return dblNum;
    }
}

