/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.util.gui.highdpi;

import de.riwagis.util.gui.highdpi.DpiAwareImage;
import de.riwagis.util.gui.units.UnitConversion;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.util.Enumeration;
import java.util.Set;
import javax.swing.ImageIcon;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.plaf.FontUIResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HighDpiSupport {
    private static final Logger log = LoggerFactory.getLogger(HighDpiSupport.class);
    public static final double DISPLAY_FACTOR_NOT_SCALED = 1.0;
    private static boolean RESCALE_FIX_DONE = false;
    private static Set<String> FONT_SCALE_BLACKLIST = Set.of("CheckBoxMenuItem.acceleratorFont", "CheckBoxMenuItem.font", "ColorChooser.font", "FileChooser.listFont", "InternalFrame.titleFont", "Menu.acceleratorFont", "Menu.font", "MenuBar.font", "MenuItem.acceleratorFont", "MenuItem.font", "OptionPane.buttonFont", "OptionPane.font", "OptionPane.messageFont", "RadioButtonMenuItem.acceleratorFont", "RadioButtonMenuItem.font", "TextArea.font", "ToolBar.font", "ToolTip.font");

    public static void fixInitialFontSizesForWindowsLookAndFeel() {
        double displayScale = HighDpiSupport.getSystemScaleFactor();
        if (RESCALE_FIX_DONE || displayScale == 1.0 || !UIManager.getLookAndFeel().getClass().getName().equals(UIManager.getSystemLookAndFeelClassName())) {
            return;
        }
        UIDefaults lookAndFeelDefaults = UIManager.getDefaults();
        Enumeration keys = lookAndFeelDefaults.keys();
        while (keys.hasMoreElements()) {
            Object key = keys.nextElement();
            Object value = UIManager.get(key);
            if (!(value instanceof FontUIResource) || FONT_SCALE_BLACKLIST.contains(key)) continue;
            FontUIResource fr = (FontUIResource)value;
            FontUIResource scaledFont = new FontUIResource(fr.deriveFont(fr.getSize2D() * (float)displayScale));
            lookAndFeelDefaults.put(key, scaledFont);
        }
        RESCALE_FIX_DONE = true;
    }

    public static int scale(GraphicsConfiguration configuration, int size) {
        return (int)Math.round((double)size * HighDpiSupport.getDisplayScaleFactorForDevice(configuration));
    }

    public static float scale(GraphicsConfiguration configuration, float size) {
        return (float)((double)size * HighDpiSupport.getDisplayScaleFactorForDevice(configuration));
    }

    public static double getDisplayScaleFactorForRenderingContext(Graphics2D g) {
        return HighDpiSupport.getDisplayScaleFactorForDevice(g.getDeviceConfiguration());
    }

    public static double getDisplayScaleFactorForDevice(GraphicsConfiguration gc) {
        if (gc == null) {
            log.debug("Graphics Device not set up. Headless mode? DPI Scaling not possible. Using default of 100%");
            return 1.0;
        }
        return gc.getDefaultTransform().getScaleX();
    }

    @Deprecated
    public static double getSystemScaleFactor() {
        return UnitConversion.calcDPIFactorFromScreen(96.0);
    }

    public static ImageIcon resizeImage(ImageIcon icon, int width, int height) {
        Image image = icon.getImage();
        if (image instanceof DpiAwareImage) {
            return new ImageIcon(new DpiAwareImage((DpiAwareImage)image, width, height));
        }
        log.warn("Rescaling a rastered image reduces its quality");
        return new ImageIcon(image.getScaledInstance(width, height, 4));
    }

    private HighDpiSupport() {
    }
}

