/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.util.gui.highdpi;

import de.riwagis.util.gui.highdpi.HighDpiSupport;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import javax.swing.ImageIcon;

public class HighDpiCursorSupport {
    public static final int DEFAULT_CURSOR_SIZE = 32;
    public static final int CURSOR_32PIXEL_SIZE = HighDpiCursorSupport.getBestCursorSize(32);
    public static final double CURSOR_32PIXEL_FACTOR = (double)CURSOR_32PIXEL_SIZE / 32.0;
    public static final int I10 = HighDpiCursorSupport.getMouseSize32PixelScale(10);
    public static final int I12 = HighDpiCursorSupport.getMouseSize32PixelScale(12);

    public static ImageIcon createScaledImage(ImageIcon img) {
        if (CURSOR_32PIXEL_FACTOR == 1.0) {
            return img;
        }
        Image scaledImg = img.getImage().getScaledInstance(HighDpiCursorSupport.getScaledValue(img.getIconWidth(), CURSOR_32PIXEL_FACTOR), HighDpiCursorSupport.getScaledValue(img.getIconHeight(), CURSOR_32PIXEL_FACTOR), 4);
        return new ImageIcon(scaledImg);
    }

    private static int getScaledValue(int size, double factor) {
        return (int)Math.round((double)size * factor);
    }

    private static int getBestCursorSize(int originalSize) {
        int sizeScaled = HighDpiCursorSupport.getScaledValue(originalSize, HighDpiSupport.getSystemScaleFactor());
        Dimension defaultScaledSize = new Dimension(sizeScaled, sizeScaled);
        Dimension bestCursorSize = Toolkit.getDefaultToolkit().getBestCursorSize(defaultScaledSize.width, defaultScaledSize.height);
        if (bestCursorSize.width == 0) {
            return originalSize;
        }
        return bestCursorSize.width;
    }

    public static Point getMouseSize32HotSpot(int x, int y) {
        return new Point(HighDpiCursorSupport.getMouseSize32PixelScale(x), HighDpiCursorSupport.getMouseSize32PixelScale(y));
    }

    public static int getMouseSize32PixelScale(int srcVal) {
        return (int)Math.floor(CURSOR_32PIXEL_FACTOR * (double)srcVal);
    }

    private HighDpiCursorSupport() {
    }
}

