/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.util.gui.highdpi;

import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BaseMultiResolutionImage;
import java.awt.image.ImageObserver;
import java.awt.image.ImageProducer;
import java.awt.image.MultiResolutionImage;
import java.util.List;
import java.util.function.BiFunction;

public class DpiAwareImage
extends Image
implements MultiResolutionImage {
    private BaseMultiResolutionImage delegate;
    private Image lastScaledImage;
    private BiFunction<Integer, Integer, Image> renderer;
    private Image unscaledImage;

    public DpiAwareImage(DpiAwareImage image, int w, int h) {
        this(image.renderer, w, h);
    }

    public DpiAwareImage(BiFunction<Integer, Integer, Image> renderer, int w, int h) {
        this.renderer = renderer;
        this.lastScaledImage = this.unscaledImage = this.renderer.apply(w, h);
        this.delegate = new BaseMultiResolutionImage(this.unscaledImage, this.lastScaledImage);
    }

    private Image updateImage(int destImageWidth, int destImageHeight) {
        return this.renderer.apply(destImageWidth, destImageHeight);
    }

    @Override
    public int getWidth(ImageObserver observer) {
        return this.delegate.getWidth(observer);
    }

    @Override
    public int getHeight(ImageObserver observer) {
        return this.delegate.getHeight(observer);
    }

    @Override
    public ImageProducer getSource() {
        return this.delegate.getSource();
    }

    @Override
    public Graphics getGraphics() {
        return this.delegate.getGraphics();
    }

    @Override
    public Object getProperty(String name, ImageObserver observer) {
        return this.delegate.getProperty(name, observer);
    }

    @Override
    public Image getResolutionVariant(double destImageWidth, double destImageHeight) {
        if ((int)destImageWidth != this.lastScaledImage.getWidth(null) || (int)destImageHeight != this.lastScaledImage.getHeight(null)) {
            this.lastScaledImage = this.updateImage((int)destImageWidth, (int)destImageHeight);
            this.delegate = new BaseMultiResolutionImage(this.unscaledImage, this.lastScaledImage);
        }
        return this.delegate.getResolutionVariant(destImageWidth, destImageHeight);
    }

    @Override
    public List<Image> getResolutionVariants() {
        return this.delegate.getResolutionVariants();
    }
}

