/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.util.gui.filedrop;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.Reader;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.TooManyListenersException;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.border.Border;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileDrop {
    private static final Logger log = LoggerFactory.getLogger(FileDrop.class);
    private static final String ZERO_CHAR_STRING = Character.toString('\u0000');
    public static final FileFilter FILEFILTER_ANY = file -> file != null;
    private Border normalBorder;
    private DropTargetListener dropListener;
    private final Collection<Predicate<Collection<File>>> allowedPredicates = new LinkedHashSet<Predicate<Collection<File>>>();
    private FileFilter fileFilter = FILEFILTER_ANY;
    private static Boolean supportsDnD;
    private static Color defaultBorderColor;

    public FileDrop(Component c, Listener listener) {
        this(c, BorderFactory.createMatteBorder(2, 2, 2, 2, defaultBorderColor), true, listener);
    }

    public FileDrop(Component c, boolean recursive, Listener listener) {
        this(c, BorderFactory.createMatteBorder(2, 2, 2, 2, defaultBorderColor), recursive, listener);
    }

    public FileDrop(Component c, Border dragBorder, Listener listener) {
        this(c, dragBorder, false, listener);
    }

    public FileDrop(final Component c, final Border dragBorder, boolean recursive, final Listener listener) {
        if (FileDrop.supportsDnD()) {
            this.dropListener = new DropTargetListener(){

                @Override
                public void dragEnter(DropTargetDragEvent evt) {
                    log.trace("FileDrop: dragEnter event.");
                    if (FileDrop.this.isDragOk(evt)) {
                        if (c instanceof JComponent) {
                            JComponent jc = (JComponent)c;
                            FileDrop.this.normalBorder = jc.getBorder();
                            log.trace("FileDrop: normal border saved.");
                            jc.setBorder(dragBorder);
                            log.trace("FileDrop: drag border set.");
                        }
                        evt.acceptDrag(1);
                        log.trace("FileDrop: event accepted.");
                    } else {
                        evt.rejectDrag();
                        log.trace("FileDrop: event rejected.");
                    }
                }

                @Override
                public void dragOver(DropTargetDragEvent evt) {
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void drop(DropTargetDropEvent evt) {
                    log.trace("FileDrop: drop event.");
                    try {
                        Transferable tr = evt.getTransferable();
                        if (tr.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                            evt.acceptDrop(1);
                            log.trace("FileDrop: file list accepted.");
                            if (listener != null) {
                                Collection droppedFiles = (Collection)tr.getTransferData(DataFlavor.javaFileListFlavor);
                                Collection res = droppedFiles.stream().filter(FileDrop.this.fileFilter::accept).collect(Collectors.toSet());
                                listener.filesDropped(new Event(res, FileDrop.this));
                            }
                            evt.getDropTargetContext().dropComplete(true);
                            log.trace("FileDrop: drop complete.");
                        } else {
                            boolean handled = false;
                            for (DataFlavor flavor : tr.getTransferDataFlavors()) {
                                if (!flavor.isRepresentationClassReader()) continue;
                                evt.acceptDrop(1);
                                log.trace("FileDrop: reader accepted.");
                                if (listener != null) {
                                    Collection<File> droppedFiles = FileDrop.readDroppedFiles(flavor, tr);
                                    Collection res = droppedFiles.stream().filter(FileDrop.this.fileFilter::accept).collect(Collectors.toSet());
                                    listener.filesDropped(new Event(res, FileDrop.this));
                                }
                                evt.getDropTargetContext().dropComplete(true);
                                log.trace("FileDrop: drop complete.");
                                handled = true;
                                break;
                            }
                            if (!handled) {
                                log.trace("FileDrop: not a file list or reader - abort.");
                                evt.rejectDrop();
                            }
                        }
                    }
                    catch (IOException io) {
                        log.trace("FileDrop: IOException - abort:", (Throwable)io);
                        evt.rejectDrop();
                    }
                    catch (UnsupportedFlavorException ufe) {
                        log.trace("FileDrop: UnsupportedFlavorException - abort:", (Throwable)ufe);
                        evt.rejectDrop();
                    }
                    finally {
                        if (c instanceof JComponent) {
                            JComponent jc = (JComponent)c;
                            jc.setBorder(FileDrop.this.normalBorder);
                            log.trace("FileDrop: normal border restored.");
                        }
                    }
                }

                @Override
                public void dragExit(DropTargetEvent evt) {
                    log.info("FileDrop: dragExit event.");
                    if (c instanceof JComponent) {
                        JComponent jc = (JComponent)c;
                        jc.setBorder(FileDrop.this.normalBorder);
                        log.info("FileDrop: normal border restored.");
                    }
                }

                @Override
                public void dropActionChanged(DropTargetDragEvent evt) {
                    log.trace("FileDrop: dropActionChanged event.");
                    if (FileDrop.this.isDragOk(evt)) {
                        evt.acceptDrag(1);
                        log.trace("FileDrop: event accepted.");
                    } else {
                        evt.rejectDrag();
                        log.trace("FileDrop: event rejected.");
                    }
                }
            };
            this.makeDropTarget(c, recursive);
        } else {
            log.warn("FileDrop: Drag and drop is not supported with this JVM");
        }
    }

    private static boolean supportsDnD() {
        if (supportsDnD == null) {
            boolean support;
            try {
                Class<?> arbitraryDndClass = Class.forName("java.awt.dnd.DnDConstants");
                support = arbitraryDndClass != null;
            }
            catch (Exception e) {
                log.warn(String.format("no dnd support: %s", e.getMessage()), (Throwable)e);
                support = false;
            }
            supportsDnD = support;
        }
        return supportsDnD;
    }

    public void setFileFilter(FileFilter fileFilter) {
        this.fileFilter = fileFilter != null ? fileFilter : FILEFILTER_ANY;
    }

    public static Collection<File> readDroppedFiles(DataFlavor flavor, Transferable tr) throws IOException {
        Collection<File> droppedFiles;
        try (Reader reader = flavor.getReaderForText(tr);
             BufferedReader br = new BufferedReader(reader);){
            droppedFiles = FileDrop.createFileArray(br);
        }
        catch (UnsupportedFlavorException ex) {
            throw new IOException(String.format("unsupported flavor: %s: %s", flavor, ex.getMessage()), ex);
        }
        return droppedFiles;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Collection<File> createFileArray(BufferedReader bReader) {
        ArrayList<File> list = new ArrayList<File>();
        try {
            String line;
            while ((line = bReader.readLine()) != null) {
                try {
                    if (ZERO_CHAR_STRING.equals(line)) continue;
                    list.add(new File(new URI(line)));
                }
                catch (URISyntaxException ex) {
                    log.warn(String.format("Error with %s: %s", line, ex.getMessage()), (Throwable)ex);
                }
            }
            return list;
        }
        catch (IOException ex) {
            log.error(String.format("FileDrop: IOException (%s)", ex.getMessage()), (Throwable)ex);
        }
        return list;
    }

    private void makeDropTarget(Component c, boolean recursive) {
        DropTarget dt = new DropTarget();
        try {
            dt.addDropTargetListener(this.dropListener);
        }
        catch (TooManyListenersException e) {
            log.error("FileDrop: Drop will not work due to previous error. Do you have another listener attached?", (Throwable)e);
        }
        c.addHierarchyListener(evt -> {
            log.info("FileDrop: Hierarchy changed.");
            Container parent = c.getParent();
            if (parent == null) {
                c.setDropTarget(null);
                log.info("FileDrop: Drop target cleared from component.");
            } else {
                DropTarget dropTarget = new DropTarget(c, this.dropListener);
                log.info(String.format("FileDrop: Drop target %s added to component.", dropTarget));
            }
        });
        if (c.getParent() != null) {
            DropTarget dropTarget = new DropTarget(c, this.dropListener);
            log.info(String.format("FileDrop: Drop target %s added to component.", dropTarget));
        }
        if (recursive && c instanceof Container) {
            Container cont = (Container)c;
            for (Component comp : cont.getComponents()) {
                this.makeDropTarget(comp, recursive);
            }
        }
    }

    public void removeAllowedPredicate(Predicate<Collection<File>> predicate) {
        this.allowedPredicates.remove(predicate);
    }

    public void addAllowedPredicate(Predicate<Collection<File>> predicate) {
        if (predicate == null) {
            throw new NullPointerException("predicate must not be null");
        }
        this.allowedPredicates.add(predicate);
    }

    public static Predicate<Collection<File>> buildFileFilterPredicate(FileFilter ff) {
        return FileDrop.buildFileFilterPredicate(ff, false);
    }

    public static Predicate<Collection<File>> buildFileFilterPredicate(FileFilter ff, boolean acceptIfSomeAreValid) {
        return t -> {
            if (t == null || t.isEmpty()) {
                return false;
            }
            if (ff != null) {
                int matchingFiles = 0;
                for (File currFile : t) {
                    if (!ff.accept(currFile)) continue;
                    ++matchingFiles;
                }
                return acceptIfSomeAreValid ? matchingFiles > 0 : matchingFiles == t.size();
            }
            return true;
        };
    }

    private boolean isDragOk(DropTargetDragEvent evt) {
        boolean ok = false;
        for (DataFlavor curFlavor : evt.getCurrentDataFlavors()) {
            Transferable tr = evt.getTransferable();
            if (!curFlavor.equals(DataFlavor.javaFileListFlavor) && !curFlavor.isRepresentationClassReader()) continue;
            try {
                List droppedFiles = (List)tr.getTransferData(DataFlavor.javaFileListFlavor);
                ok = FileDrop.buildFileFilterPredicate(this.fileFilter, true).test(droppedFiles);
                for (Predicate<Collection<File>> currPredicate : this.allowedPredicates) {
                    if (currPredicate.test(droppedFiles)) continue;
                    ok = false;
                }
            }
            catch (UnsupportedFlavorException | IOException ex) {
                log.warn(String.format("error parsing transferable: %s", ex.getMessage()), (Throwable)ex);
                ok = false;
            }
        }
        FileDrop.logFlavours(evt);
        return ok;
    }

    private static void logFlavours(DropTargetDragEvent evt) {
        if (log.isDebugEnabled()) {
            DataFlavor[] flavors = evt.getCurrentDataFlavors();
            if (flavors.length == 0) {
                log.debug("FileDrop: no data flavors.");
            }
            for (DataFlavor flavor : flavors) {
                log.debug(flavor.toString());
            }
        }
    }

    public static boolean remove(Component c) {
        return FileDrop.remove(c, true);
    }

    public static boolean remove(Component c, boolean recursive) {
        if (FileDrop.supportsDnD()) {
            log.info("FileDrop: Removing drag-and-drop hooks.");
            c.setDropTarget(null);
            if (recursive && c instanceof Container) {
                for (Component comp : ((Container)c).getComponents()) {
                    FileDrop.remove(comp, recursive);
                }
                return true;
            }
            return false;
        }
        return false;
    }

    static {
        defaultBorderColor = new Color(0.0f, 0.0f, 1.0f, 0.25f);
    }

    public static interface Listener {
        public void filesDropped(Event var1);
    }

    public static class TransferableObject
    implements Transferable {
        public static final String MIME_TYPE = "application/x-net.iharder.dnd.TransferableObject";
        public static final DataFlavor DATA_FLAVOR = new DataFlavor(TransferableObject.class, "application/x-net.iharder.dnd.TransferableObject");
        private Fetcher fetcher;
        private Object data;
        private DataFlavor customFlavor;

        public TransferableObject(Object data) {
            this.data = data;
            this.customFlavor = new DataFlavor(data.getClass(), MIME_TYPE);
        }

        public TransferableObject(Fetcher fetcher) {
            this.fetcher = fetcher;
        }

        public TransferableObject(Class<?> dataClass, Fetcher fetcher) {
            this.fetcher = fetcher;
            this.customFlavor = new DataFlavor(dataClass, MIME_TYPE);
        }

        public DataFlavor getCustomDataFlavor() {
            return this.customFlavor;
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            if (this.customFlavor != null) {
                return new DataFlavor[]{this.customFlavor, DATA_FLAVOR, DataFlavor.stringFlavor};
            }
            return new DataFlavor[]{DATA_FLAVOR, DataFlavor.stringFlavor};
        }

        @Override
        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
            if (flavor.equals(DATA_FLAVOR)) {
                return this.fetcher == null ? this.data : this.fetcher.getObject();
            }
            if (flavor.equals(DataFlavor.stringFlavor)) {
                return this.fetcher == null ? this.data.toString() : this.fetcher.getObject().toString();
            }
            throw new UnsupportedFlavorException(flavor);
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor flavor) {
            if (flavor.equals(DATA_FLAVOR)) {
                return true;
            }
            return flavor.equals(DataFlavor.stringFlavor);
        }

        public static interface Fetcher {
            public Object getObject();
        }
    }

    public static class Event
    extends EventObject {
        private Collection<File> files;

        public Event(Collection<File> files, FileDrop source) {
            super(source);
            this.files = files;
        }

        public Collection<File> getFiles() {
            return this.files;
        }
    }
}

