/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.util.gui.dialogs;

import de.riwagis.util.Config;
import de.riwagis.util.gui.GUISupport;
import de.riwagis.util.gui.models.ListListModel;
import de.riwagis.util.i18n.I18N;
import de.riwagis.util.jdbc.JDBCDBMetaInterface;
import de.riwagis.util.jdbc.SavedJDBCDBConnectionEntry;
import de.riwagis.util.jdbc.SimpleJDBCDBMeta;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.InputMethodEvent;
import java.awt.event.InputMethodListener;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LookupJDBCDBMetaDialog
extends JDialog {
    private static final Logger LOG = LoggerFactory.getLogger(LookupJDBCDBMetaDialog.class);
    private static I18N i18n = new I18N(Config.LOCALE, "de.riwagis.util.gui.i18n");
    private final ListListModel<SavedJDBCDBConnectionEntry> m = new ListListModel(SavedJDBCDBConnectionEntry.emptyList(), true, null);
    private SavedJDBCDBConnectionEntry lastSelectedValue = null;
    private SavedJDBCDBConnectionEntry editEntry = null;
    private int modalResult = 0;
    private JButton btnApply;
    private JButton btnCancel;
    private JButton btnCancelDialog;
    private JButton btnDelete;
    private JButton btnEdit;
    private JButton btnNew;
    private JButton btnOk;
    private JComboBox<String> cmbDriver;
    private JComboBox<String> cmbURL;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JScrollPane jScrollPane1;
    private JSplitPane jSplitPane1;
    private JLabel lblConnectionName;
    private JLabel lblDriver;
    private JLabel lblHeader;
    private JLabel lblPwd;
    private JLabel lblServicename;
    private JLabel lblURL;
    private JLabel lblUser;
    private JList<SavedJDBCDBConnectionEntry> lstSavedDBMeta;
    private JTextField txtConnectionName;
    private JPasswordField txtPwd;
    private JTextField txtServicename;
    private JTextField txtUser;

    private LookupJDBCDBMetaDialog(Window _parent, boolean _modal) {
        super(_parent);
        this.setModal(_modal);
        this.initComponents();
        this.updateControls();
    }

    public int getModalResult() {
        return this.modalResult;
    }

    protected boolean askCloseAllowed() {
        boolean closeAllowed = true;
        if (this.editEntry != null) {
            int action = JOptionPane.showConfirmDialog(this, i18n.fmt("LookupJDBCDBMetaDialog.entryChangeRequest", new Object[]{this.txtConnectionName.getText()}), i18n.get("de.riwagis.LookupJDBCDBMetaDialog.entryChangeTitle"), 1, 3);
            if (action == 0) {
                this.m.replaceListObject(this.editEntry, this.getSavedJDBCDBConnectionEntry());
            }
            closeAllowed = action != 2;
        }
        return closeAllowed;
    }

    private void initComponents() {
        this.jSplitPane1 = new JSplitPane();
        this.jPanel4 = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.lstSavedDBMeta = new JList();
        this.jPanel3 = new JPanel();
        this.lblHeader = new JLabel();
        this.lblConnectionName = new JLabel();
        this.txtConnectionName = new JTextField();
        this.lblDriver = new JLabel();
        this.cmbDriver = new JComboBox();
        this.lblURL = new JLabel();
        this.cmbURL = new JComboBox();
        this.lblUser = new JLabel();
        this.txtUser = new JTextField();
        this.lblPwd = new JLabel();
        this.txtPwd = new JPasswordField();
        this.lblServicename = new JLabel();
        this.txtServicename = new JTextField();
        this.jPanel1 = new JPanel();
        this.jPanel5 = new JPanel();
        this.btnApply = new JButton();
        this.btnEdit = new JButton();
        this.btnDelete = new JButton();
        this.btnNew = new JButton();
        this.btnCancel = new JButton();
        this.jPanel2 = new JPanel();
        this.btnOk = new JButton();
        this.btnCancelDialog = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("Gespeicherte Datenbankverbindungen");
        this.getContentPane().setLayout(new GridBagLayout());
        this.jSplitPane1.setAutoscrolls(true);
        this.jPanel4.setMinimumSize(new Dimension(200, 50));
        this.jPanel4.setPreferredSize(new Dimension(200, 132));
        this.jPanel4.setLayout(new GridBagLayout());
        this.lstSavedDBMeta.setModel(this.m);
        this.lstSavedDBMeta.setSelectionMode(0);
        this.lstSavedDBMeta.setCellRenderer(SavedJDBCDBConnectionEntry.DEFAULT_LISTRENDERER);
        this.lstSavedDBMeta.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                LookupJDBCDBMetaDialog.this.lstSavedDBMetaValueChanged(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.lstSavedDBMeta);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel4.add((Component)this.jScrollPane1, gridBagConstraints);
        this.jSplitPane1.setLeftComponent(this.jPanel4);
        this.jPanel3.setMinimumSize(new Dimension(400, 300));
        this.jPanel3.setPreferredSize(new Dimension(400, 300));
        this.jPanel3.setLayout(new GridBagLayout());
        this.lblHeader.setFont(this.lblHeader.getFont().deriveFont(this.lblHeader.getFont().getStyle() | 1, this.lblHeader.getFont().getSize() + 1));
        this.lblHeader.setText("Datenbankverbindung");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel3.add((Component)this.lblHeader, gridBagConstraints);
        ResourceBundle bundle = ResourceBundle.getBundle("de/riwagis/util/i18n/i18n");
        this.lblConnectionName.setText(bundle.getString("de.riwagis.LookJDBCDBMetaDialog.savedConnectionName"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 15, 6);
        this.jPanel3.add((Component)this.lblConnectionName, gridBagConstraints);
        this.txtConnectionName.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                LookupJDBCDBMetaDialog.this.txtConnectionNameFocusLost(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 15, 5);
        this.jPanel3.add((Component)this.txtConnectionName, gridBagConstraints);
        this.lblDriver.setText("Treiber:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 6);
        this.jPanel3.add((Component)this.lblDriver, gridBagConstraints);
        this.cmbDriver.setEditable(true);
        this.cmbDriver.setModel(new DefaultComboBoxModel<String>(new String[]{"oracle.jdbc.driver.OracleDriver", "com.mysql.jdbc.Driver"}));
        this.cmbDriver.addInputMethodListener(new InputMethodListener(){

            @Override
            public void caretPositionChanged(InputMethodEvent evt) {
            }

            @Override
            public void inputMethodTextChanged(InputMethodEvent evt) {
                LookupJDBCDBMetaDialog.this.cmbDriverInputMethodTextChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 5);
        this.jPanel3.add(this.cmbDriver, gridBagConstraints);
        this.lblURL.setText("URL:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 6);
        this.jPanel3.add((Component)this.lblURL, gridBagConstraints);
        this.cmbURL.setEditable(true);
        this.cmbURL.setModel(new DefaultComboBoxModel<String>(new String[]{"jdbc:oracle:thin:@host:port:sid", "jdbc:mysql://host:port/dbname", "jdbc:odbc:dsn_name;UID=uid;PWD=pwd"}));
        this.cmbURL.setPreferredSize(new Dimension(200, 22));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 5);
        this.jPanel3.add(this.cmbURL, gridBagConstraints);
        this.lblUser.setText("Benutzername:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 6);
        this.jPanel3.add((Component)this.lblUser, gridBagConstraints);
        this.txtUser.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                LookupJDBCDBMetaDialog.this.txtUserFocusLost(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 5);
        this.jPanel3.add((Component)this.txtUser, gridBagConstraints);
        this.lblPwd.setText("Passwort:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 6);
        this.jPanel3.add((Component)this.lblPwd, gridBagConstraints);
        this.txtPwd.setText("avs");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 5);
        this.jPanel3.add((Component)this.txtPwd, gridBagConstraints);
        this.lblServicename.setText("Servicename:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 6);
        this.jPanel3.add((Component)this.lblServicename, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 5);
        this.jPanel3.add((Component)this.txtServicename, gridBagConstraints);
        this.jPanel1.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        this.jPanel1.add((Component)this.jPanel5, gridBagConstraints);
        this.btnApply.setText(bundle.getString("common.apply"));
        this.btnApply.setHideActionText(true);
        this.btnApply.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LookupJDBCDBMetaDialog.this.btnApplyActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel1.add((Component)this.btnApply, gridBagConstraints);
        this.btnEdit.setText(bundle.getString("common.edit"));
        this.btnEdit.setHideActionText(true);
        this.btnEdit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LookupJDBCDBMetaDialog.this.btnEditActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel1.add((Component)this.btnEdit, gridBagConstraints);
        this.btnDelete.setText(bundle.getString("common.delete"));
        this.btnDelete.setHideActionText(true);
        this.btnDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LookupJDBCDBMetaDialog.this.btnDeleteActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel1.add((Component)this.btnDelete, gridBagConstraints);
        this.btnNew.setText(bundle.getString("common.new"));
        this.btnNew.setHideActionText(true);
        this.btnNew.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LookupJDBCDBMetaDialog.this.btnNewActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel1.add((Component)this.btnNew, gridBagConstraints);
        this.btnCancel.setText(bundle.getString("common.cancel"));
        this.btnCancel.setHideActionText(true);
        this.btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LookupJDBCDBMetaDialog.this.btnCancelActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel1.add((Component)this.btnCancel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.jPanel3.add((Component)this.jPanel1, gridBagConstraints);
        this.jSplitPane1.setRightComponent(this.jPanel3);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = -1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.getContentPane().add((Component)this.jSplitPane1, gridBagConstraints);
        this.jPanel2.setDoubleBuffered(false);
        this.jPanel2.setLayout(new GridBagLayout());
        this.btnOk.setText(bundle.getString("common.ok"));
        this.btnOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LookupJDBCDBMetaDialog.this.btnCloseActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel2.add((Component)this.btnOk, gridBagConstraints);
        this.btnCancelDialog.setText(bundle.getString("common.cancel"));
        this.btnCancelDialog.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LookupJDBCDBMetaDialog.this.btnCancelDialogActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel2.add((Component)this.btnCancelDialog, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.getContentPane().add((Component)this.jPanel2, gridBagConstraints);
        this.pack();
    }

    private void btnApplyActionPerformed(ActionEvent evt) {
        SavedJDBCDBConnectionEntry editEntry2 = this.editEntry;
        this.editEntry = null;
        this.updateControls();
        SavedJDBCDBConnectionEntry newEntry = this.getSavedJDBCDBConnectionEntry();
        if (editEntry2 != null) {
            this.m.replaceListObject(editEntry2, newEntry);
        }
        this.lastSelectedValue = newEntry;
        this.lstSavedDBMeta.setSelectedValue(newEntry, true);
    }

    private void btnCloseActionPerformed(ActionEvent evt) {
        boolean closeAllowed = this.askCloseAllowed();
        if (closeAllowed) {
            this.setVisible(false);
            this.modalResult = 0;
        }
    }

    private void btnDeleteActionPerformed(ActionEvent evt) {
        if (this.lastSelectedValue != null) {
            int lastIndex = this.lstSavedDBMeta.getSelectedIndex();
            this.m.removeListObject(this.lastSelectedValue);
            if (this.lstSavedDBMeta.getModel().getSize() > 0) {
                this.lstSavedDBMeta.setSelectedIndex(Math.max(0, lastIndex - 1));
            } else {
                this.lstSavedDBMeta.setSelectedIndex(Math.max(-1, lastIndex - 1));
            }
        }
        this.editEntry = null;
        this.updateControls();
    }

    private void btnCancelActionPerformed(ActionEvent evt) {
        this.setSavedJDBCDBConnectionEntry(this.lstSavedDBMeta.getSelectedValue());
        this.editEntry = null;
        this.updateControls();
    }

    private void lstSavedDBMetaValueChanged(ListSelectionEvent evt) {
        this.setSavedJDBCDBConnectionEntry(this.lstSavedDBMeta.getSelectedValue());
    }

    private void btnNewActionPerformed(ActionEvent evt) {
        SavedJDBCDBConnectionEntry newEntry = new SavedJDBCDBConnectionEntry(String.format("CONN_%d", System.currentTimeMillis()), null);
        this.setSavedJDBCDBConnectionEntry(newEntry);
        this.lstSavedDBMeta.setSelectedIndex(-1);
        this.editEntry = newEntry;
        this.updateControls();
    }

    private void btnEditActionPerformed(ActionEvent evt) {
        this.editEntry = this.lastSelectedValue;
        this.updateControls();
    }

    private void txtUserFocusLost(FocusEvent evt) {
        this.updateControls();
    }

    private void txtConnectionNameFocusLost(FocusEvent evt) {
        this.updateControls();
    }

    private void cmbDriverInputMethodTextChanged(InputMethodEvent evt) {
        this.updateControls();
    }

    private void btnCancelDialogActionPerformed(ActionEvent evt) {
        boolean closeAllowed = this.askCloseAllowed();
        if (closeAllowed) {
            this.setVisible(false);
            this.modalResult = 2;
        }
    }

    public SavedJDBCDBConnectionEntry getSelectedJDBCDBConnectionEntry() {
        return this.lstSavedDBMeta.getSelectedValue();
    }

    private SavedJDBCDBConnectionEntry getSavedJDBCDBConnectionEntry() {
        return new SavedJDBCDBConnectionEntry(this.txtConnectionName.getText(), (JDBCDBMetaInterface)new SimpleJDBCDBMeta(StringUtils.trim((String)ObjectUtils.toString((Object)this.cmbDriver.getSelectedItem())), StringUtils.trim((String)ObjectUtils.toString((Object)this.cmbURL.getSelectedItem())), StringUtils.trim((String)this.txtUser.getText()), String.valueOf(this.txtPwd.getPassword()), StringUtils.trim((String)this.txtServicename.getText())));
    }

    private void setSavedJDBCDBConnectionEntry(SavedJDBCDBConnectionEntry _savedDBMeta) {
        if (_savedDBMeta != null) {
            JDBCDBMetaInterface _dbMeta = _savedDBMeta.getDbMeta();
            this.txtConnectionName.setText(_savedDBMeta.getConnectionName());
            if (_dbMeta != null) {
                this.cmbDriver.setSelectedItem(_dbMeta.getDBDriver());
                this.cmbURL.setSelectedItem(_dbMeta.getDBUrl());
                this.txtUser.setText(_dbMeta.getUsername());
                this.txtPwd.setText(_dbMeta.getPassword());
                this.txtServicename.setText(_dbMeta.getDBService());
            }
        } else {
            this.txtConnectionName.setText("");
            this.cmbDriver.setSelectedItem("");
            this.cmbURL.setSelectedItem("");
            this.txtUser.setText("");
            this.txtPwd.setText("");
            this.txtServicename.setText("");
        }
        this.lastSelectedValue = _savedDBMeta;
        this.updateControls();
    }

    private void updateControls() {
        boolean editMode = this.editEntry != null;
        this.btnCancel.setEnabled(editMode);
        this.btnCancel.setVisible(editMode);
        this.btnNew.setEnabled(!editMode);
        this.btnNew.setVisible(!editMode);
        this.btnApply.setVisible(editMode);
        this.btnApply.setEnabled(editMode && this.isEntryValid());
        this.btnEdit.setVisible(!editMode);
        this.btnEdit.setEnabled(!editMode && this.lstSavedDBMeta.getSelectedValue() != null);
        this.btnDelete.setVisible(true);
        this.btnDelete.setEnabled(this.lstSavedDBMeta.getSelectedValue() != null);
        this.txtConnectionName.setEnabled(editMode);
        this.txtPwd.setEnabled(editMode);
        this.txtUser.setEnabled(editMode);
        this.txtServicename.setEnabled(editMode);
        this.cmbDriver.setEnabled(editMode);
        this.cmbURL.setEnabled(editMode);
        this.lstSavedDBMeta.setEnabled(!editMode);
        this.btnOk.setEnabled(true);
    }

    public void setModel(List<SavedJDBCDBConnectionEntry> _ListModel) {
        this.m.setList(_ListModel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SavedJDBCDBConnectionEntry lookup(Window _parent, List<SavedJDBCDBConnectionEntry> entries, SavedJDBCDBConnectionEntry _dbMeta) {
        SavedJDBCDBConnectionEntry res = _dbMeta;
        LookupJDBCDBMetaDialog dlg = new LookupJDBCDBMetaDialog(_parent, true);
        try {
            dlg.setModel(entries);
            dlg.setSavedJDBCDBConnectionEntry(_dbMeta);
            dlg.setVisible(true);
            if (dlg.getModalResult() == 0) {
                res = dlg.getSelectedJDBCDBConnectionEntry();
            }
        }
        finally {
            GUISupport.disposeQuietly(dlg);
        }
        return res;
    }

    private boolean isEntryValid() {
        return StringUtils.isNotBlank((CharSequence)this.txtConnectionName.getText());
    }
}

